(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7115,        182]*)
(*NotebookOutlinePosition[      8005,        212]*)
(*  CellTagsIndexPosition[      7961,        208]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["PERIASTROPACK", "Title"],

Cell[TextData[{
  "This is a MATHEMATICA package for the calculation and drawing of orbits of \
massive particles in the Schwarzschild metric. After letting the computer \
read the programme, the package is initialized by typing: ",
  StyleBox["periastro. \n",
    FontSlant->"Italic"],
  StyleBox["We suggest that you type periastro in a separate NoteBook, \
different from the NoteBook containing the package. ",
    FontVariations->{"CompatibilityType"->0}]
}], "Text"],

Cell[CellGroupData[{

Cell["Programme", "Section"],

Cell[CellGroupData[{

Cell["Main programme periastro", "Subsection"],

Cell["\<\
This is the main programme which asks for the inputs of the parameters and \
then calls the calculation subroutines\
\>", "Text"],

Cell[BoxData[
    \(\(periastro := {\[IndentingNewLine]Print["\<===========================\
\>"]; \[IndentingNewLine]Print["\<We make a comparison between orbits in \
Newton's Theory\>"]; \[IndentingNewLine]Print["\<and in Schwarzschild \
geometry\>"]; \[IndentingNewLine]Print["\<---------------------------\>"]; \
\[IndentingNewLine]Print["\<Input of geometrical parameters\>"]; \
\[IndentingNewLine]alpha = 
            Input["\<Semilatus rectum in units of Schwarzschild \
emiradius\>"]; \[IndentingNewLine]ec = 
            Input["\<eccentricity\>"]; \[IndentingNewLine]lq = 
            alpha*\((1 - 
                  ec\^2)\); \
\[IndentingNewLine]Print["\<===========================\>"]; \
\[IndentingNewLine]Print["\<PLOT of the ORBIT with the following \
parameters:\>"]; Print["\<Semilatus rectum =  \>", alpha, "\<m\>"]; 
          Print["\<eccentricity =  \>", 
            ec]; \[IndentingNewLine]Print["\<===========================\>"]; \
\[IndentingNewLine]Print["\<Keplerian orbit with these parameters\>"]; \
\[IndentingNewLine]perihelkep; \
\[IndentingNewLine]Print["\<===========================\>"]; \
\[IndentingNewLine]Print["\<The Schwarzschild orbit with the same \
parameters\>"]; \[IndentingNewLine]nn = 
            1; \[IndentingNewLine]perihelgr; \[IndentingNewLine]Label[
            ripeto]; \[IndentingNewLine]Print["\<After more revolutions, Yes \
or No?\>"]; \[IndentingNewLine]flagga = 
            Input["\<Yes or No\>"]; \[IndentingNewLine]If[flagga === Yes, 
            Goto[plotto], Goto[stoppo]]; \[IndentingNewLine]If[flagga === No, 
            Goto[stoppo], {pippo = 0}]; \[IndentingNewLine]Label[
            plotto]; \[IndentingNewLine]nn = 
            Input["\<number of revolutions\>"]; \[IndentingNewLine]perihelgr; \
\[IndentingNewLine]Goto[ripeto]; \[IndentingNewLine]Label[
            stoppo]; \[IndentingNewLine]Print["\<Finished\>"]; \
\[IndentingNewLine]Print["\<---------------------------\>"];};\)\)], "Input",
  CellLabel->"In[1]:="]
}, Closed]],

Cell[CellGroupData[{

Cell["Subroutine perihelkep", "Subsection"],

Cell["\<\
This is the routine that plots the Keplerian orbit with the chosen parameters\
\
\>", "Text"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(perihelkep := \
{\[IndentingNewLine]\(ParametricPlot[{alpha*\((1 - ec\^2)\)*
                Cos[phi]\/\(1 + ec*Cos[phi]\), \[IndentingNewLine]alpha*\((1 \
- ec\^2)\)*Sin[phi]\/\(1 + ec*Cos[phi]\)}, {phi, 0, 2*Pi}, 
            AxesLabel \[Rule] \ {x, y}, Ticks \[Rule] \ None, 
            PlotStyle \[Rule] \ {{Thickness[0.006]}}];\)}\)\)\)], "Input",
  CellLabel->"In[2]:="]
}, Closed]],

Cell[CellGroupData[{

Cell["Subroutine perihelgr", "Subsection"],

Cell["\<\
This is the subroutine for the calculation and drawing of the orbit with the \
same parameters in the Schwarzschild metric\
\>", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"perihelgr", ":=", 
        RowBox[{"{", "\[IndentingNewLine]", 
          
          RowBox[{\(Print["\<---------------------------\>"]\), ";", 
            "\[IndentingNewLine]", \(Print["\<After \>", 
              nn, "\< revolutions\>"]\), ";", "\[IndentingNewLine]", 
            RowBox[{"QQ", "=", 
              RowBox[{"NDSolve", "[", 
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          RowBox[{
                            SuperscriptBox["uu", "\[DoublePrime]",
                              MultilineFunction->None], "[", "phi", "]"}], 
                          "+", \(uu[phi]\), "-", \(3\ uu[phi]\^2\)}], 
                        "==", \(1\/lq\)}], ",", \(uu[0] == \(1 + ec\)\/lq\), 
                      ",", 
                      RowBox[{
                        RowBox[{
                          SuperscriptBox["uu", "\[Prime]",
                            MultilineFunction->None], "[", "0", "]"}], "==", 
                        "0"}]}], "}"}], ",", \({uu[phi]}\), 
                  ",", \({phi, 0, 2\ nn\ \[Pi]}\), 
                  ",", \(MaxSteps \[Rule] 500\)}], "]"}]}], ";", 
            "\[IndentingNewLine]", \(ParametricPlot[
              Evaluate[{Sin[phi]\/uu[phi], Cos[phi]\/uu[phi]} /. QQ], {phi, 
                0, 2\ nn\ \[Pi]}, AxesLabel \[Rule] {x, y}, 
              AspectRatio \[Rule] 1, Ticks \[Rule] None, 
              PlotStyle \[Rule] {{Thickness[0.006], RGBColor[1, 0, 0]}}]\), 
            ";"}], "}"}]}], "\[IndentingNewLine]"}]], "Input",
  CellLabel->"In[3]:="]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1440}, {0, 813}},
WindowToolbars->{},
WindowSize->{1264, 679},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
Magnification->1.5,
StyleDefinitions -> "Textbook.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 30, 0, 104, "Title"],
Cell[1809, 55, 472, 9, 86, "Text"],

Cell[CellGroupData[{
Cell[2306, 68, 28, 0, 127, "Section"],

Cell[CellGroupData[{
Cell[2359, 72, 46, 0, 65, "Subsection"],
Cell[2408, 74, 139, 3, 34, "Text"],
Cell[2550, 79, 1998, 33, 822, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4585, 117, 43, 0, 50, "Subsection"],
Cell[4631, 119, 103, 3, 34, "Text"],
Cell[4737, 124, 424, 7, 213, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[5198, 136, 42, 0, 50, "Subsection"],
Cell[5243, 138, 146, 3, 34, "Text"],
Cell[5392, 143, 1683, 34, 295, "Input"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

