PROGRAM Dioeqv; {pp. 336-337}
{Solves the diophantine equation ax-by=c}
(Input,Output);
LABEL 1;
VAR a,b,c,x : INTEGER;
  
FUNCTION lincon(a,b,c : INTEGER) : INTEGER;
{ Solves the linear congruence ax = c (mod b) }
LABEL 1,2;
VAR  sw,m,n,p0,p1,p2,q,r,u : INTEGER;
BEGIN
  sw:=1; m:=abs(b); n:=a; IF n<0 THEN
                              BEGIN c:=-c; n:=-n END
  {Here the signs are adjusted if a and b are negative};
  p0:=1; p1:=m DIV n; q:=p1 {Starting values!};
1: r:=m MOD n;
  IF r>0 THEN
    BEGIN sw:=-sw; m:=n; n:=r; q:=m DIV n;
      p2:=q*p1+p0; p0:=p1; p1:=p2; GOTO 1
      {This constitutes the continued fraction algorithm}
    END
  ELSE
    BEGIN IF n>1 THEN
      BEGIN b:=b DIV n; u:=c DIV n;
        IF c <> u*n
          THEN
            BEGIN writeln(tty,'Congruence not solvable!');
              sw:=0; GOTO 2
            END
          ELSE
            BEGIN c:=u;
              writeln(tty,'Modulus reduced to',b:8)
            END
      END;
    2:lincon:=sw*c*p0 MOD b
    END
END {lincon};
  
BEGIN
1:write(tty,'Input a,b,c in the congruence ax=c(mod b)');
  write(tty,'and ax-by=c: '); read(tty,a,b,c);
  IF a <> 0 THEN
    BEGIN x:=lincon(a,b,c);
      writeln(tty,'x=',x:8,' y=',(a*x-c)DIV b:8);
      GOTO 1
    END
 END.
