FUNCTION Lehmer(x : INTEGER) : INTEGER; {pp. 22-23}
{Computes pi(x) with Lehmer's formula. Makes use of the
  function phi(x,a) and of an array of integers, Prime,
  containing a "small" prime table}
VAR b,c,a,bi,z,w,sum,i,j : INTEGER;
BEGIN
  z:=trunc(sqrt(x+0.5)); b:=smallpi(z);
  c:=smallpi(trunc(exp(ln(x)/3)+0.5)); { pi(cube root(x) }
  a:=smallpi(trunc(sqrt(z)+0.5)); { pi(fourth root(x) }
  sum:=phi(x,a)+(b+a-2)*(b-a+1) DIV 2;
  FOR i:=a+1 TO b DO
    BEGIN w:=x DIV Prime[i]; sum:=sum-pi(w);
      IF i<=c THEN
        BEGIN
          bi:=smallpi(trunc(sqrt(w)+0.5));
          FOR j:=i TO bi DO sum:=sum-pi(w DIV Prime[j])+j-1
        END
    END;
  Lehmer:=sum
END {Lehmer};
