PROGRAM MultiplePrecisionPackage(Input,Output); {pp. 349--355}
{Tests the procedures in the Package}
LABEL 1,2;
CONST sqrtB=100000; vsize=20; lvsize=40;
TYPE vector    = ARRAY[0..vsize] OF INTEGER;
     string    = PACKED ARRAY[1..8] OF CHAR;
VAR a,b,c,d             : vector;
    Base,B1,B101        : INTEGER;
  
FUNCTION sign(x : INTEGER) : INTEGER;
BEGIN IF x=0 THEN sign := 0 ELSE sign := abs(x) DIV x
END {function sign};
  
PROCEDURE putin(txt : string; VAR a : vector);
{Prints a text string of 8 characters and reads one
  multiple-precision integer which is stored in a}
VAR a0,m,i : INTEGER;
  
BEGIN write(txt); read(a0); m:=abs(a0); a[0]:=a0;
 FOR i:=m DOWNTO 1 DO read(a[i]);
END {procedure putin};
  
PROCEDURE putout(txt : string; VAR a : vector);
{Prints a text string of 8 characters followed by one
  multiple-precision integer a}
CONST l=0.434294481 {const=1/ln(10)};
VAR a0,i,j,s,sa,t,u,v : INTEGER;
  
BEGIN write(txt); a0:=a[0]; sa:=sign(a0); a0:=abs(a0);
 IF sa<0 THEN write('-') ELSE write(' ');
 v:=trunc(l*ln(Base)+0.5) {v is the number of digits
    allowed in each component of a};
 IF a0=0 THEN write(0:v) ELSE
  BEGIN write(a[a0]:v);
   FOR i:=a0-1 DOWNTO 1 DO BEGIN t:=a[i];
    IF t=0 THEN s:=1 ELSE
     IF t=B101 THEN s:=v-1 ELSE
      IF t>=Base DIV 10 THEN s:=v ELSE
       s:=trunc(1+l*ln(t));
    u:=v-s; write(' ');
   FOR j:=1 TO u DO write('0');
   write(t:s) END END;
 writeln('') END {procedure putout};
  
PROCEDURE red(VAR c : vector);
{Reduces a multiple-precision integer to standard form
  in call of procedure addsub}
VAR c0,s,i,j : INTEGER;
  
BEGIN c0:=c[0]; s:=sign(c0); c0:=abs(c0); c[c0+1]:=0;
 WHILE (c0>0) AND (c[c0]=0) DO c0:=c0-1;
  {Here the leading zeros of c are removed}
  IF c[c0]<0 THEN FOR i:=0 TO c0 DO c[i]:=-c[i];
 FOR j:=1 TO 2 DO BEGIN
  FOR i:=1 TO c0 DO BEGIN IF c[i]>=Base
   THEN BEGIN c[i+1]:=c[i+1]+1; c[i]:=c[i]-Base END
    ELSE IF c[i]<0 THEN BEGIN
     c[i+1]:=c[i+1]-1; c[i]:=c[i]+Base END END END;
 c0:=c0+1; WHILE (c0>0) AND (c[c0]=0) DO c0:=c0-1;
 c[0]:=sign(c[0])*c0
END {procedure red};
  
PROCEDURE let(VAR a : vector; b : vector);
{Puts a:=b for multiple-precision integers a and b}
VAR s,i : INTEGER;
  
BEGIN s:=abs(b[0]);
  FOR i:=0 TO s DO a[i]:=b[i]
END {procedure let};
  
PROCEDURE addsub(a,b:vector; sgn:INTEGER; VAR c:vector);
{With a=sign(a[0])*sum a[i]*B^(i-1),
  b=sign(b[0])*sum b[j]*B^(j-1), and sgn=+1 or -1,
  c:=a+sgn*b. c may be one of a or b}
VAR sa,sb,q,r,max,min,i,s : INTEGER;
  
BEGIN sa:=a[0]; sb:=b[0]*sgn; q:=abs(sa); max:=q;
 r:=abs(sb); min:=r;
 IF min>max THEN BEGIN max:=r; min:=q END;
 s:=sign(sa)*sign(sb);
 FOR i:=1 TO min DO c[i]:=a[i]+s*b[i];
 FOR i:=min+1 TO max DO
  IF max=q THEN c[i]:=a[i] ELSE c[i]:=s*b[i];
 c[0]:=sa; c[max+1]:=0;
 IF sa=0 THEN let(c,b); {c:=b in case a=0}
 IF s<>0 THEN c[0]:=max*sign(sa);
  {Here the components of c may be >B or <0}
 red(c) END {procedure addsub};
  
PROCEDURE mul(a,b : vector; VAR c : vector);
{Computes c:=a*b for multiple-precision integers.
  c may be one of a or b}
TYPE vector     = ARRAY[0..vsize] OF INTEGER;
     longvector = ARRAY[0..lvsize] OF INTEGER;
VAR aa,bb : vector;
    cc    : longvector;
    m,n,p,sa,sb,sc,i,k,s,m2,n2,p2,m21,n21,mn : INTEGER;
  
BEGIN m:=a[0]; sa:=sign(m); m:=abs(m); n:=b[0];
 sb:=sign(n); n:=abs(n); p:=m+n; sc:=sa*sb; m2:=m*2;
 n2:=n*2; p2:=p*2; m21:=m2-1; n21:=n2-1; mn:=m2+n21;
 FOR i:=1 TO m DO BEGIN s:=a[i]; aa[2*i]:=s DIV sqrtB;
  aa[2*i-1]:=s MOD sqrtB END;
 FOR i:=1 TO n DO BEGIN s:=b[i]; bb[2*i]:=s DIV sqrtB;
  bb[2*i-1]:=s MOD sqrtB END;
 FOR i:=0 TO lvsize DO cc[i]:=0;
 IF m<=n THEN
  BEGIN
   FOR i:=1 TO m21 DO BEGIN s:=0;
    FOR k:=1 TO i DO BEGIN s:=s+aa[k]*bb[i+1-k];
     IF s>=Base THEN BEGIN s:=s-Base; cc[i+2]:=cc[i+2]+1;
                     END
    END; cc[i]:=cc[i]+s END;
 
   FOR i:=m2 TO n2 DO BEGIN s:=0;
    FOR k:=1 TO m2 DO BEGIN s:=s+aa[k]*bb[i+1-k];
     IF s>=Base THEN BEGIN s:=s-Base; cc[i+2]:=cc[i+2]+1;
                     END
    END; cc[i]:=cc[i]+s END;
  
   FOR i:=n2+1 TO mn DO BEGIN s:=0;
    FOR k:=i-n21 TO m2 DO BEGIN s:=s+aa[k]*bb[i+1-k];
     IF s>=Base THEN BEGIN s:=s-Base; cc[i+2]:=cc[i+2]+1;
                     END
    END; cc[i]:=cc[i]+s END;
  END
 ELSE BEGIN
   FOR i:=1 TO n21 DO BEGIN s:=0;
    FOR k:=1 TO i DO BEGIN s:=s+bb[k]*aa[i+1-k];
     IF s>=Base THEN BEGIN s:=s-Base; cc[i+2]:=cc[i+2]+1;
                     END
    END; cc[i]:=cc[i]+s END;
  
   FOR i:=n2 TO m2 DO BEGIN s:=0;
    FOR k:=1 TO n2 DO BEGIN s:=s+bb[k]*aa[i+1-k];
     IF s>=Base THEN BEGIN s:=s-Base; cc[i+2]:=cc[i+2]+1;
                     END
    END; cc[i]:=cc[i]+s END;
  
   FOR i:=m2+1 TO mn DO BEGIN s:=0;
    FOR k:=i-m21 TO n2 DO BEGIN s:=s+bb[k]*aa[i+1-k];
    IF s>=Base THEN BEGIN s:=s-Base; cc[i+2]:=cc[i+2]+1;
                    END
    END; cc[i]:=cc[i]+s END;
  END;
   
 FOR i:=1 TO p2 DO BEGIN cc[i+1]:=cc[i+1]+cc[i] DIV sqrtB;
  cc[i]:=cc[i] mod sqrtB END;
 FOR i:=1 TO p DO c[i]:=cc[2*i-1]+sqrtB*cc[2*i];
 IF c[p]=0 THEN p:=p-1; c[0]:=p*sc
END {procedure mul};
  
PROCEDURE quot(a,b : vector; VAR q,r : vector);
{Computes q and r satisfying a=b*q+r, 0<=r<b for multiple
   precision integers a and b. r may be either of a or b}
LABEL 1,2,3;
TYPE vector = ARRAY[0..vsize] OF INTEGER;
VAR one,qk,aa,bb,cc,qq              : vector;
    m,n,s,t,i,j,k,l,p,t1,j1,sa,sb,u : INTEGER;
    ar,br,qr                        : REAL;
  
BEGIN FOR i:=0 TO vsize DO qq[i]:=0; m:=a[0]; n:=b[0];
 sa:=sign(m); sb:=sign(n); s:=abs(m); t:=abs(n); l:=s-t+1;
 IF l<=0 THEN l:=1;
 IF s<t THEN u:=t ELSE u:=s;
 IF n=0 THEN BEGIN
  writeln('Division by zero attempted in quot');
  l:=0; GOTO 3 END;
 one[0]:=1; one[1]:=1; qk[0]:=1; t1:=t+1; b[0]:=t;
 let(aa,a); aa[0]:=s;
 IF t=1 THEN br:=b[1] ELSE br:=b[t]+b[t-1]/Base;
  {Here br := the leading part of b}
1: IF s<t THEN GOTO 3;
 IF s=t THEN BEGIN
  addsub(aa,b,-1,cc); IF cc[0]<0 THEN GOTO 3 END;
 j:=aa[0]-t;
 IF s<=1 THEN ar:=aa[s] ELSE ar:=aa[s]+aa[s-1]/Base;
  {Here ar := the leading part of a}
 qr:=ar/br; {qr := the approximate quotient a/b}
 IF (qr<1) AND (j=0) THEN GOTO 3 ELSE
  IF qr<1 THEN BEGIN qr:=qr*Base; j:=j-1;
   IF qr<1 THEN qr:=1 END;
 k:=trunc(qr); qk[1]:=k; qq[j+1]:=qq[j+1]+k;
2: mul(qk,b,bb); FOR i:=t1 DOWNTO 1 DO bb[i+j]:=bb[i];
 FOR i:=1 TO j DO bb[i]:=0;
 bb[0]:=bb[0]+j; addsub(aa,bb,-1,cc); s:=cc[0]; p:=s;
 IF p<0 THEN
  BEGIN qk[1]:=qk[1]-1; qq[j+1]:=qq[j+1]-1;
   IF qk[1]=0 THEN
    BEGIN qk[1]:=B1; qq[j]:=qq[j]+qk[1]; j:=j-1 END;
  GOTO 2 END;
 FOR i:=0 TO p DO aa[i]:=cc[i]; GOTO 1;
 
3: b[0]:=n; IF qq[l]=0 THEN l:=l-1;
 qq[0]:=l*sa*sb; let(q,qq);
 IF l=0 THEN aa[0]:=m ELSE aa[0]:=aa[0]*sa*sb;
 IF (sa*sb<0) AND (aa[0]<>0) THEN BEGIN
  addsub(q,one,-1,q); addsub(aa,b,sb,aa) END;
let(r,aa) END {procedure quot};
  
PROCEDURE Euclid(a,b : vector; VAR d : vector);
{Computes d=GCD(a,b) for multiple-precision integers
  with Euclid's algorithm}
TYPE vector = ARRAY[0..vsize] OF INTEGER;
VAR aa,bb,q,r          : vector;
    a0,b0,i,r0,aa0,bb0 : INTEGER;
  
BEGIN a0:=abs(a[0]); b0:=abs(b[0]);
  let(aa,a); aa[0]:=a0; let(bb,b); bb[0]:=b0;
 WHILE bb[0]>0 DO
  BEGIN quot(aa,bb,q,r); let(aa,bb); let(bb,r) END;
 let(d,aa)
END {procedure Euclid};
  
PROCEDURE apowerb(a,b,n : vector; VAR r : vector);
{Computes r = a^b (mod n) for multiple-precision
  integers, b>0}
LABEL 1;
TYPE vector = ARRAY[0..vsize] OF INTEGER;
VAR two,par,aa,bb,p,s,gb : vector;
  
BEGIN p[0]:=1; p[1]:=1; two[0]:=1; two[1]:=2; let(bb,b);
 IF bb[0]<=0 THEN BEGIN
  writeln('b<=0 attempted in apowerb'); GOTO 1 END;
 quot(a,n,gb,aa); WHILE bb[0]>0 DO
  BEGIN quot(bb,two,gb,par); let(bb,gb);
   IF par[0]=1 THEN BEGIN mul(aa,p,s); quot(s,n,gb,p) END;
   mul(aa,aa,s); quot(s,n,gb,aa) END;
 let(r,p);
1: END {procedure apowerb};
  
BEGIN {The test program for the package starts here}
  Base:=sqr(sqrtB); B1:=Base-1; B101:=Base DIV 10-1;
  writeln('Base=10^',trunc(0.434294481*ln(Base)+0.5):2);
1: putin('Give a: ',a); putin('Give b: ',b);
  IF (a[0]=0) AND (b[0]=0) THEN GOTO 2;
  addsub(a,b,1,c); putout('a+b =   ',c);
  addsub(a,b,-1,c); putout('a-b =   ',c);
  mul(a,b,c); putout('a*b =   ',c);
  quot(a,b,c,d); putout('a/b =   ',c);
  putout('remainder=',d); Euclid(a,b,c);
  putout('GCD(a,b)=',c);
  putin('Give c: ',c); apowerb(a,b,c,d);
  putout('a^b (c)=',d);
  GOTO 1;
  
2: END.


PROGRAM MultiPollard {pp. 355-356}
{Searches for factors with Pollard's rho method}
(Input,Output);
LABEL 1;
CONST sqrtB=100000; vsize=10; lvsize=20;
TYPE vector    = ARRAY[0..vsize] OF INTEGER;
     string    = PACKED ARRAY[1..8] OF CHAR;
VAR a,x1,x,y,Q,N,z,w,p    : vector;
    i,Base,B1,B101        : INTEGER;
  
FUNCTION sign(x : INTEGER) : INTEGER;
BEGIN IF x=0 THEN sign := 0 ELSE sign := abs(x) div x
END {sign};
  .
  .
1:  END {apowerb};
  
BEGIN  Base:=sqr(sqrtB); B1:=Base-1; B101:=Base DIV 10-1;
  {Pollard's method begins here}
  putin('Give a: ',a); putin(Give x1:',x1); let(x,x1);
  let(y,x1); Q[0]:=1; Q[1]:=1; putin('Give N: ',N);
 FOR i:=1 TO 10000 DO BEGIN
  mul(x,x,z); addsub(z,a,-1,z); quot(z,N,w,x);
   {x:=x^2-a mod N}
  mul(y,y,z); addsub(z,a,-1,z); quot(z,N,w,y);
   {y:=y^2-a mod N}
  mul(y,y,z); addsub(z,a,-1,z); quot(z,N,w,y);
   {y:=y^2-a mod N}
  addsub(y,x,-1,z); mul(Q,z,Q); quot(Q,N,w,Q);
   {Q:=Q*(y-x)mod N}
  IF i MOD 20 = 0 THEN
   BEGIN Euclid(Q,N,p);
    IF ((p[0]=1) AND (p[1]>1)) OR (p[0]>1) THEN
     BEGIN quot(N,p,z,w); IF w[0]=0 THEN
      BEGIN putout('factor= ',p);
       writeln(' discovered for i=',i:5);	
        {Here a factor of N is found and divided out}
       let(N,z); IF (N[0]=1) AND (N[1]=1) THEN GOTO 1
      END
     END
   END
 END;
 writeln('No factor discovered in 10000 cycles!');
1: END.
