PROGRAM Pollard {pp. 180-181}
(Input,Output);
LABEL 1,2;
VAR a,x1,x,y,Q,i,p,N : INTEGER;
  
FUNCTION Euclid(a,b : INTEGER) : INTEGER;
{Computes GCD(a,b) with Euclid's algorithm}
VAR m,n,r : INTEGER;
BEGIN m:=a; n:=b;
  WHILE n <> 0 DO BEGIN r:=m MOD n; m:=n; n:=r END;
  Euclid:=m
END {Euclid};
  
BEGIN
1: write('Input a <> 0, 2 and x1: '); read(a);
  IF a=0 THEN GOTO 2;
  read(x1); x:=x1; y:=x1; Q:=1;
  write('Input N for factorization: '); read(N);
  FOR i:=1 TO 10000 DO
    BEGIN
      x:=(x*x-a) MOD N; y:=(y*y-a) MOD N; y:=(y*y-a) MOD N;
      Q:=Q*(y-x) MOD N;
      IF i MOD 20 = 0 THEN
        BEGIN p:=Euclid(Q,N);
          IF p>1 THEN WHILE N MOD p = 0 DO
            BEGIN
              writeln('p=',p:8,' found for i=',i:4);
              N:=N DIV p;
              {Here a factor of N is found and divided out}
              IF N=1 THEN GOTO 1
            END
        END
    END;
  writeln('No factor found in 10,000 cycles');
  GOTO 1;
2: END.
