PROGRAM SQUFOF {pp. 190-192}
(Input,Output);
{Factorizes N < 10^20 by Shanks' Square Forms Factorization
  method. Computer arithmetic allowing integers up to 2^35
  is used. Warning: Make sure N is composite, otherwise the
  list could extend outside the specified index bounds! Be
  sure N is not a square!}

LABEL 1,2,3,4,5,6;
TYPE vector=ARRAY[0..30] OF INTEGER;
VAR List : vector;
    c,c2,sq,d,a,b,z,z1,z2,sq2sqN,Q,Q0,Q1,Q2,P1,P2,
    i,j,k,ks,u,r,w,s1,s2 : INTEGER;
  
PROCEDURE isqrtd(a,b : INTEGER; VAR sq,d : INTEGER);
{Computes n=10^10*a+b, sq:=trunc(sqrt(n)), d:=n-sq^2}
LABEL 1,2;
VAR c,c2,n,r,r1,r2,s,s1,s2,z,sw : INTEGER;
    rn,rsq,w,rs1,rs2 : REAL;
BEGIN
 c:=100000; c2:=10000000000; sw:=0;
 rn:=1E10*a+b; rsq:=sqrt(rn); r:=trunc(rsq);
 {r is a first approximation to sqrt(n)}
1: r1:=r DIV c; r2:=r MOD c; {r=10^5*r1+r2}
 z:=2*r1*r2; s1:=a-r1*r1- z DIV c;
 s2:=b-r2*r2-(z MOD c)*c;
 {Here d=n-r^2 has been computed as 10^10*s1+s2}
 IF sw=1 THEN GOTO 2 {d was <0 previously!};
 z:=2*r; rs1:=s1; rs2:=s2; w:=rs1*1E10+rs2;
 s:=trunc(w/z);
 {Here the correction s=(n-r^2)/(2r) has been computed}
 IF s <> 0 THEN BEGIN r:=r+s; GOTO 1 END;
2: d:=s1*c2+s2;
 IF d<0 THEN BEGIN r:=r-1; sw:=1; GOTO 1 END;
 sq:=r;
END {isqrtd};
  
BEGIN c:=100000; c2:=10000000000;
1: write('Input N = 10^10*a+b as two integers a, b: ');
 read(a); IF a<0 THEN GOTO 6; read(b);
 isqrtd(a,b,sq,d); IF d=0 THEN
  BEGIN writeln('N is the square of',sq:11); GOTO 1 END;
 z:=2*sq; IF d>=sq THEN z:=z+1 {trunc(2*sqrt(N))};
 sq2sqN:=trunc(sqrt(z)) {sqrt(2*sqrt(N))};
 List[0]:=1; Q0:=1; P1:=sq; Q1:=d;
 {Here all initial values are set for the continued
   fraction expansion}
 FOR i:=1 TO 10000000 DO
  BEGIN {Continued fraction expansion starts}
   IF i MOD 50000=0 THEN writeln(i:8,' cycles passed');
   Q:=(sq+P1) DIV Q1; P2:=Q*Q1-P1; Q2:=Q0+Q*(P1-P2);
   u:=Q1; IF NOT odd(u) THEN u:=u DIV 2;
   Q0:=Q1; Q1:=Q2; P1:=P2;
   IF (u < sq2sqN) AND (u > 1) THEN
    BEGIN List[List[0]]:=u; List[0]:=List[0]+1 END;
    {Here a small denominator is put in the list}
   IF odd(i) THEN
    BEGIN
     IF Q1 MOD 4 > 1 THEN GOTO 3 {No square, goto next i};
     r:=trunc(sqrt(Q1)); IF Q1=r*r THEN {A square!}
      BEGIN ks:=List[0]-1; FOR k:=1 TO ks DO
       IF r=List[k] THEN GOTO 3 {Square of no use, next i};
       IF r > 1 THEN GOTO 4 ELSE
        BEGIN
         write('The period has been searched (i=',i:7);
         writeln(') without finding any useful form');
         GOTO 1
        END
      END
    END;
3: END;
4: writeln('Number of steps to find a square was',i:8);
writeln('Number of elements in the list is',List[0]-1:3);

 {Here the computation of the square root of the
   square quadratic form found is started}
 z:=sq-(sq-P1) MOD r; z1:=z DIV c; z2:=z MOD c;
 {z=z1*10^5+z2 for the computation of (n-z^2)/r}
 w:=2*z1*z2; s1:=a-z1*z1-w DIV c; s2:=b-z2*z2-(w MOD c)*c;
5: IF s2<0 THEN
  BEGIN s2:=s2+c2; s1:=s1-1; GOTO 5 END;
  Q0:=r; P1:=z; z:=s1*c+s2 DIV c;
  Q1:=(z DIV r)*c+((z MOD r)*c+s2 MOD c)DIV r;
  FOR j:=1 TO 5000000 DO
   BEGIN {Here the expansion of the second form starts}
    Q:=(sq+P1) DIV Q1; P2:=Q*Q1-P1;
    Q2:=Q0+Q*(P1-P2); Q0:=Q1;
    u:=P1; P1:=P2; Q1:=Q2; IF u=P2 THEN
     BEGIN
      IF NOT odd(Q0) THEN Q0:=Q0 DIV 2;
      writeln('Factor=',Q0:11); GOTO 1
     END;
   END;
6: END.
