PROGRAM Squaretest(Input,Output); {pp. 361-362}
{Checks out the procedure square}
CONST sqrtR=100; vsize=33; lvsize=66;
TYPE vector     = ARRAY[0..vsize] OF INTEGER;
     string     = PACKED ARRAY[1..8] OF CHAR;
VAR a,b                  : vector;
    Radix,B1,B101         : INTEGER;
  
FUNCTION sign(x : INTEGER) : INTEGER;
BEGIN IF x=0 THEN sign := 0 ELSE sign := abs(x) DIV x
END {sign};
  
{Here the PROCEDUREs putin, putout, red, let, addsub and
 mul from the Multiple Precision Package must be inserted}
  
PROCEDURE expand(s : INTEGER; VAR u : vector);
{Multiplies a multiple precision integer u by Radix^s, s>0}
VAR u0,i,k    : INTEGER;
  
BEGIN u0:=abs(u[0]);
  FOR i:=1 TO u0 DO
    BEGIN k:=u0+1-i; u[k+s]:=u[k]; u[k]:=0 END;
  FOR i:=u0+1 TO s DO u[i]:=0;
  u[0]:=sign(u[0])*(u0+s)
END {expand};
  
PROCEDURE square(p : vector; VAR q : vector);
{Computes q=p^2 recursively by using (Bu+v)^2 =
  = u^2*B^2 + [u^2 + (u-v)^2 +v^2]*B + v^2}
LABEL 1;
TYPE vector     = ARRAY[0..vsize] OF INTEGER;
VAR u,v,z,u2,v2,uv,s   : vector;
    p0,ap0,ap02,i,k    : INTEGER;
  
BEGIN p0:=p[0]; ap0:=abs(p0); IF ap0<=1 THEN
 BEGIN q[0]:=0; IF ap0=1 THEN
  BEGIN i:=sqr(p[1]); q[1]:=i MOD Radix; q[2]:=i DIV Radix;
   IF q[2]=0 THEN q[0]:=1 ELSE q[0]:=2 END;
 {Here a piece of assembler code should replace the last
  two lines to compute the square of a single-word integer}
  GOTO 1
 END;
 ap02:=(ap0+1)DIV 2; p[0]:=ap02; let(v,p); p[0]:=p0;
  {Here v has been formed}
 u[0]:=ap0-ap02; FOR i:=1 TO u[0] DO u[i]:=p[i+ap02];
  {Here u has been formed}
 square(u,u2); addsub(u,v,-1,z); square(z,uv);
 square(v,v2); addsub(u2,uv,-1,z); addsub(z,v2,1,s);
  {Here u^2 - (u-v)^2 + v^2 has been formed}
 expand(ap02,s); expand(2*ap02,u2);
 addsub(u2,v2,1,z); addsub(z,s,1,q);
1: END {square};
  
BEGIN{Here begins a test program for the procedure square}
  Radix:=sqr(sqrtR); B1:=Radix-1; B101:=Radix DIV 10 - 1;
  writeln('Radix=10^',trunc(0.434294481*ln(Radix)+0.5):2);
putin('Give a= ',a); WHILE a[0]<>0 DO BEGIN
  square(a,b);putout('sqr(a)= ',b);putin('Give a= ',a) END
END.
