PROGRAM TrialDivision {Factors an integer N} {pp. 143-145}
(Input,Output);
LABEL 1;
CONST k=22;
TYPE vector=ARRAY[0..k] OF INTEGER;
VAR Factor : vector; N,G,i,m : INTEGER;
  
PROCEDURE divide(N,G : INTEGER; VAR Factor : vector;
                 VAR m : INTEGER);
{Places all prime factors <G in the integer array Factor.
The number of factors found is placed in Factor[0]. The
remaining cofactor is returned in m, unless the divisions
show this cofactor to be prime, in which case it is
included among the factors in the array Factor and the
value of m returned is 1}

VAR p,plimit : INTEGER;
  
PROCEDURE reduce(r : INTEGER);
 {Divides m by r, if possible}
BEGIN IF r>1 THEN WHILE m MOD r = 0 DO
  BEGIN m:=m DIV r; Factor[0]:=Factor[0]+1;
    Factor[Factor[0]]:=r
  END;
  plimit:=isqrt(m);
  IF plimit>G THEN plimit:=G
END {reduce};
  
BEGIN m:=N; Factor[0]:=0;
  reduce(2); reduce(3); p:=5;
  WHILE p<=plimit DO
    BEGIN IF m MOD p  = 0 THEN reduce(p);
          IF m MOD(p+2)=0 THEN reduce(p+2);
          p:=p+6
    END;
  IF p>isqrt(m) THEN reduce(m)
END {divide};
  
BEGIN
1: write('Input an integer N>0 for factorization: ');
  read(N);
  IF N>0 THEN
  BEGIN
    write('Input the search limit G: '); read(G);
    divide(N,G,Factor,m);
    FOR i:=1 TO Factor[0] DO write(Factor[i]:8);
    writeln; IF m=1 THEN writeln('Factorization complete')
                    ELSE
    writeln('Factorization incomplete. Cofactor=',m:8);
    GOTO 1
  END
END.
