PROGRAM phixa {Computes phi(x,a) for a=5} {pp.16-17}
(input,Output);
LABEL 1;
CONST a=5; ma=2310; {ma=p[1]*...*p[a]*a}
  ma2=1155; {ma2=ma\2} stop=578;
   {Since phi(x,a) never alters its value at even x,
    full information about phi(x,a) is retained if
    phi(x,a) is stored at odd values of x only. stop
    is the number of elements required in tabphia}
  phima=480; {phima=phi(ma,a)=prod(p[i]-1) for i=1,...,a}
VAR Prime : ARRAY[1..a] OF INTEGER;
  tabphia : ARRAY[0..stop] OF INTEGER;
  i,j,s,x : INTEGER;
  
FUNCTION phia(x : INTEGER) : INTEGER;
{For x<0, phi(x,a) is defined as -phi(-x,a). That is
  why abs(x) and sign(x)=abs(x) DIV x appear!}
VAR r,z : INTEGER;
BEGIN
  r:=abs(x) MOD ma; z:=(abs(x) DIV ma)*phima;
  IF r < ma2
    THEN z:=z+tabphia[(r+1) DIV 2]
    ELSE z:=z+phima-tabphia[(ma-r) DIV 2];
  phia:=abs(x) DIV x * z
END phia;
  
BEGIN
Prime[2]:=3; Prime[3]:=5; Prime[4]:=7; Prime[5]:=11;
FOR i:=2 TO a DO
  BEGIN j:=(Prime[i]+1) DIV 2;
    WHILE j <= stop DO
      BEGIN tabphia[j]:=1; j:=j+Prime[i] END
        {Here the sieving is performed}
  END;
s:=0; FOR i:=1 TO stop DO
  BEGIN IF tabphia[i]=0 THEN s:=s+1; tabphia[i]:=s END;
    {Here the sum of ZEROs is accumulated, and the table
      phixa, needed in the integer procedure phia(x), is 
      ready for use}
  
1: write('Input x: '); read(x);
IF x <> 0 THEN
  BEGIN 
   writeln('phi(',x:5,',',a:1,')=',phia(x):5); GOTO 1
  END
END.
