{ Shuffling of random numbers generated by this computer }
{ Written by Henri Schurz, 9.10. 1991                    }

PROGRAM EXX1X5X1; { PC-Exercise 1.9.6 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE;

CONST
 N=1000;       { number of random numbers                    }
 FREQUENCY=20; { length of the shuffle vector                }

TYPE
 VECTOR1=ARRAY[1..FREQUENCY] OF REAL;
 VECTOR2=ARRAY[1..2*N] OF REAL;

VAR
 I:INTEGER;           { counter                                          }
 I1,I2:INTEGER;       { index of the shuffle vector                      }
 IY,IX,LY,LX:INTEGER; { global scaling parameters                        }
 U0:REAL; { random number to get the current index of the shuffle vector }
 US1,US2:REAL;        { shuffled random numbers                          }
 UHELP:VECTOR1;       { help vector for the shuffle subroutine           }
 U:VECTOR2;           { unshuffled random numbers                        }

{ Draws two boxes on the screen and sets scaling parameters }

PROCEDURE SETBOXESAPARATOSCR;
BEGIN
 IX:=TRUNC(MAXX/9);LX:=3*IX;
 {IY:=TRUNC(IX*(MAXY/MAXX));LY:=TRUNC(LX*(MAXY/MAXX));}
 IY:=4*TEXTHEIGHT('M');;LY:=TRUNC(LX*(MAXY/(MAXX-15*TEXTHEIGHT('M'))));
 RECTANGLE(IX,IY,IX+LX,LY+IY);RECTANGLE(2*LX-IX,IY,3*LX-IX,LY+IY);
 OUTTEXTXY(IX-15,IY-5,'1');OUTTEXTXY(2*LX-IX-15,IY-5,'1');
 OUTTEXTXY(IX+LX+15,LY+IY+5,'1');OUTTEXTXY(3*LX-IX+15,LY+IY+5,'1');
 OUTTEXTXY(IX-15,LY+IY+5,'0');OUTTEXTXY(2*LX-IX-15,LY+IY+5,'0');
 OUTTEXTXY(TRUNC(6.5*IX),LY+IY+15,'with shuffling');
 OUTTEXTXY(IX+TRUNC(LX/2),LY+IY+15,'without shuffling');
END;{ SETBOXESAPARATOSCR }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW(''); { sets only the view port }
 STATUSLINE('The procedure works until all pixels have been generated!');
 SETBOXESAPARATOSCR; { draws boxes, sets scaling parameters }

{ Generation of the random numbers and output of the pixels on the screen : }

 I:=0;
 REPEAT
  I:=I+1; { index of the random pair }
  U[2*I-1]:=RANDOM;U[2*I]:=RANDOM; { random numbers using the generator }
  PUTPIXEL(TRUNC(IX+U[2*I-1]*LX),TRUNC(IY+LY*(1.0-U[2*I])),MAXCOLOR);
 UNTIL I=N;

{ Shuffel subroutine and output of the pixels on the screen : }

 FOR I:=1 TO FREQUENCY DO { initializes the shuffle vector }
  UHELP[I]:=RANDOM;
 I:=0;
 REPEAT
  I:=I+1; { index of the random pair }
  U0:=RANDOM;
  I1:=TRUNC(U0*FREQUENCY+1.0); { index of the first number picked }
  US1:=UHELP[I1];      { picks the random number     }
  UHELP[I1]:=U[2*I-1]; { prepares the shuffle vector }
  U0:=RANDOM;
  I2:=TRUNC(U0*FREQUENCY+1.0); { index of the second number picked }
  US2:=UHELP[I2];    { picks the random number           }
  UHELP[I2]:=U[2*I]; { prepares the shuffle vector       }
  PUTPIXEL(TRUNC(5*IX+US1*LX),TRUNC(IY+LY*(1.0-US2)),MAXCOLOR);
 UNTIL I=N;

 STATUSLINE('Shuffling of the random numbers generated by this computer');

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ EXX1X5X1 }