{ Approximation of the multiple Stratonovich integral J12                }
{ Calculates the multiple integral on the time interval [0,DELTA]        }
{ Estimates the sample average and variance of the multiple integral J12 }
{ approximated with the truncation parameters P1 < P2 < P3 <=100         }
{ Written by Henri Schurz, 9.10.1991                                     }

PROGRAM EXX2X3X1;

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
 N=1000;    { sample size          }
 DELTA=1.0; { time step size       }
 P1=5;      { truncation parameter }
 P2=20;     { truncation parameter }
 P3=100;    { truncation parameter }

TYPE
 VECTOR=ARRAY[1..N] OF REAL;

VAR
 CR:STRING;           { help string                                         }
 I:INTEGER;           { counter                                             }
 ROP1,ROP2,ROP3:REAL; { approximation parameters                            }
 SUMVAL:REAL;         { summation help variable                             }
 MU1,MU2:REAL;        { Gaussian random numbers                             }
 GSI1,GSI2:REAL; { Gaussian random numbers generating the Wiener increments }
 J12:REAL;            { multiple Stratonovich integral J12 approximated     }
 AV1,AV2,AV3:REAL;    { sample averages                                     }
 VAR1,VAR2,VAR3:REAL; { sample variances                                    }
 J12P1:VECTOR;        { sample values of the multiple integral J12 for P1   }
 J12P2:VECTOR;        { sample values of the multiple integral J12 for P2   }
 J12P3:VECTOR;        { sample values of the multiple integral J12 for P3   }

{ Prepares the screen and plots a table of the results }

PROCEDURE SETTABLETOSCR;
VAR
 CR:STRING;
 IK,L:INTEGER;
BEGIN
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 IK:=TRUNC((MAXX-2)/6);
 FOR L:=0 TO 4 DO LINE(0,80+L*20,6*IK,80+L*20);
 CR:='Sample average and variance of the multiple Stratonovich integral J12';
 OUTTEXTXY(TRUNC(MAXX/2),20,CR);
 CR:='approximated on the time interval [0,DELTA] with DELTA = '+CHCR(DELTA);
 OUTTEXTXY(TRUNC(MAXX/2),40,CR);
 OUTTEXTXY(3*IK,60,'using the sample size N = '+CHCR(N)+' : ');
 FOR L:=0 TO 4 DO
  BEGIN
   LINE(2*L*IK,80,2*L*IK,160);
   CASE L OF
     1 : CR:='p';
     2 : CR:='average';
     3 : CR:='variance';
    END;
   IF ((L<>0) AND (L<>4)) THEN OUTTEXTXY((2*L-1)*IK,90,CR);
  END;
 FOR L:=0 TO 2 DO
  CASE L OF
    0 : BEGIN
         FOR I:=0 TO 2 DO
          BEGIN
           CASE I OF
             0 : CR:=CHCR(P1);
             1 : CR:=CHCR(AV1);
             2 : CR:=CHCR(VAR1);
            END;
           OUTTEXTXY((2*I+1)*IK,110+L*20,CR);
          END;
        END;
    1 : BEGIN
         FOR I:=0 TO 2 DO
          BEGIN
           CASE I OF
             0 : CR:=CHCR(P2);
             1 : CR:=CHCR(AV2);
             2 : CR:=CHCR(VAR2);
            END;
           OUTTEXTXY((2*I+1)*IK,110+L*20,CR);
          END;
        END;
    2 : BEGIN
         FOR I:=0 TO 2 DO
          BEGIN
           CASE I OF
             0 : CR:=CHCR(P3);
             1 : CR:=CHCR(AV3);
             2 : CR:=CHCR(VAR3);
            END;
           OUTTEXTXY((2*I+1)*IK,110+L*20,CR);
          END;
        END;
   END;
 CR:=' whereas  E (0.5*W1(DELTA)*W2(DELTA)) = '+CHCR(0);
 OUTTEXTXY(3*IK,180,CR);
 CR:=' and  E (0.5*W1(DELTA)*W2(DELTA))^2 = '+CHCR(DELTA*DELTA/4);
 OUTTEXTXY(3*IK,200,CR);
END;{ SETTABLETOSCR }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Sets the parameter ROP of the procedure MULTIINTJ12 }

PROCEDURE SETUPPARAMULTIINTJ12(P:INTEGER;VAR ROP:REAL);
VAR
 R:INTEGER;
BEGIN
 ROP:=0.0;
 FOR R:=1 TO P DO ROP:=ROP+1/(R*R);
 ROP:=PI*PI/6-ROP;ROP:=ROP/(2*PI*PI);
END;{ SETUPPARAMULTIINTJ12 }

{ Generates the multiple Stratonovich integral J12                          }
{ Uses the time step size DELTA; PL and PR(<=100) are accuracy parameters   }
{ Assumes the Gaussian random numbers GSI1,GSI2,MU1 and MU2 have already    }
{ been generated and ROP has been calculated by SETUPPARAMULTIINTJ12 before }
{ GSI1 and GSI2 are involved in the generation of the Wiener increments     }
{ SUMVAL is the help value to continue the summations                       }

PROCEDURE MULTIINTJ12(PL,PR:INTEGER;ROP,DELTA,GSI1,GSI2,MU1,MU2:REAL;
                                    VAR SUMVAL,J12:REAL);
VAR
 R:INTEGER;
 ETA,ZETA:ARRAY[1..2,1..100] OF REAL;
BEGIN
 FOR R:=PL TO PR DO
  BEGIN
   GENERATE(ZETA[1,R],ZETA[2,R]);GENERATE(ETA[1,R],ETA[2,R]);
   SUMVAL:=SUMVAL+(1/R)*(ZETA[1,R]*(SQRT(2)*GSI2+ETA[2,R])
                 -ZETA[2,R]*(SQRT(2)*GSI1+ETA[1,R]));
  END;
 J12:=SUMVAL*DELTA/PI;
 J12:=J12+DELTA*(GSI1*GSI2/2+SQRT(ROP)*(MU1*GSI2-MU2*GSI1));
END;{ MULTIINTJ12 }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Exercise 2.3.1');
 STATUSLINE('Be patient! This will take the computer some time.');

{ Calculation of the current parameter ROP depending on P : }

 SETUPPARAMULTIINTJ12(P1,ROP1);
 SETUPPARAMULTIINTJ12(P2,ROP2);
 SETUPPARAMULTIINTJ12(P3,ROP3);

{ Generation of the sample : }

 I:=0; { data index }
 REPEAT
  I:=I+1;

 { Generation of GSI1 and GSI2 corresponding to the Wiener increments : }

  GENERATE(GSI1,GSI2); { uses the Polar Marsaglia method }

 { Approximation of the multiple Stratonovich integral J12 : }

  SUMVAL:=0.0;
  GENERATE(MU1,MU2); { Gaussian random numbers MU1 and MU2 }
  MULTIINTJ12(1,P1,ROP1,DELTA,GSI1,GSI2,MU1,MU2,SUMVAL,J12);J12P1[I]:=J12;
  MULTIINTJ12(P1+1,P2,ROP2,DELTA,GSI1,GSI2,MU1,MU2,SUMVAL,J12);J12P2[I]:=J12;
  MULTIINTJ12(P2+1,P3,ROP3,DELTA,GSI1,GSI2,MU1,MU2,SUMVAL,J12);J12P3[I]:=J12;

 UNTIL I=N;

{ Calculation of the sample parameters : }

 COMPSAMPLEPARA(N,J12P1,AV1,VAR1);
 COMPSAMPLEPARA(N,J12P2,AV2,VAR2);
 COMPSAMPLEPARA(N,J12P3,AV3,VAR3);

{ Printout of the data on the screen : }

 CLEARDEVICE;
 SETTABLETOSCR;
 CR:='Sample parameters of the multiple Stratonovich integral J12 ';
 CR:=CR+'approximated';
 STATUSLINE(CR);

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ EXX2X3X1 }