{ Simulation studies with a stiff stochastic differential equation          }
{ Comparison of the efficiency between selected schemes : implicit Euler    }
{ scheme, implicit Milstein scheme, implicit order 1.5 strong Taylor scheme,}
{ half-implicit order 2.0 strong Taylor scheme, implicit order 1.0 strong   }
{ Runge-Kutta scheme involving Stratonovich drift with and without simpli-  }
{ fied supporting value and the nonimplicit order 2.0 strong Taylor scheme  }
{ for scalar noise in the two-dimensional case at the time T                }
{ Considers the two-dimensional system of stochastic differential equations }
{  dX1(t) = ALPHA * (X2(t)-X1(t)) dt + BETA * X1(t) dW(t)  with X1(T0)=X10  }
{  dX2(t) = ALPHA * (X1(t)-X2(t)) dt + BETA * X2(t) dW(t)  with X2(T0)=X20  }
{ on the time interval [T0,T] where W(t) is a Wiener process                }
{ Equidistant approximation of X(.)(t) with different time step sizes DELTA }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the absolute errors at the }
{ time T using M batches(M=20) with the sample size N { without printout!)  }
{ Plots the log2 of the absolute errors against the log2 of the step sizes  }
{ Plots the log2 of the elapsed time against - log2 of these errors         }
{ Plots the log2 of the elapsed time against the log2 of the step sizes     }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch number remember that the corresponding per-  }
{        centage point of the t-distribution should also be changed.        }
{        For the measurement of the necessary time take the sample size     }
{        large enough. Confidence intervals can be plotted by calling the   }
{        routine CONFINV. See preparations at the end of this file.         }
{ This system is stiff iff  -0.5*BETA*BETA >> -0.5*BETA*BETA-2*ALPHA !      }

PROGRAM EXX4X4X4;

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,EXTGRAPH;

CONST
 NUM=9;         { number of different time step sizes                     }
 T0=0.0;        { left end point                                          }
 T=1.0;         { right end point                                         }
 DELTA=T-T0;    { largest time step size of the strong approximations     }
 X10=1.0;       { initial value of the first component                    }
 X20=0.0;       { initial value of the second component                   }
 ALPHA=5.0;     { parameter in the drift function A(t,x)                  }
 BETA=0.01;     { parameter in the diffusion function B(t,x)              }
 ALPHAK1=0.0;   { implicitness(0 <= ALPKAK1 <= 1) in the first component  }
 ALPHAK2=0.0;   { implicitness(0 <= ALPKAK2 <= 1) in the second component }
 BETAK1=0.0;    { implicitness(0 <= BETAK1 <= 1) in the first component   }
 BETAK2=0.0;    { implicitness(0 <= BETAK2 <= 1) in the second component  }
 M=20;          { number of batches                                       }
 N=100;         { sample size of one batch                                }
 QUANTILE=1.73; { percentage point of the t-distribution                  }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;             { help string                                       }
 TIME:STRING;           { elapsed total computational time in seconds       }
 HOUR,MINUTE,SECOND,SEC100:WORD; { help time values                         }
 THOUR,TMINUTE,TSECOND,TSEC100:WORD; { help time values                     }
 G:INTEGER;             { index of the current time step size               }
 I:INTEGER;             { time step index                                   }
 J:INTEGER;             { batch index                                       }
 K:INTEGER;             { sample index within the current batch             }
 RTIME:REAL;            { elapsed time converted in a REAL type             }
 SQRT3:REAL;            { square root of 3.0                                }
 TIOLD:REAL;            { left subinterval point                            }
 TI:REAL;               { right subinterval point                           }
 DELTA_Y:REAL;          { time step size of the strong approximation        }
 SQDELTA_Y:REAL;        { square root of the time step size DELTA_Y         }
 G1,G2:REAL;            { Gaussian random numbers                           }
 WT:REAL;               { value of the Wiener process at time ti            }
 DWTI:REAL;             { Wiener process increment  W(t(i+1)) - W(ti)       }
 I11,I111:REAL;         { multiple Ito integrals I11 and I111               }
 J111,J1111:REAL;       { multiple Stratonovich integrals J111 and J1111    }
 HH,HI,HII:REAL;        { local help numbers for the implicit schemes       }
 FI1,FI2:REAL;          { local help numbers(implicit Taylor 2.0 scheme)    }
 KAPPA,KAPPA0,KAPPA1,KAPPA2,KAPPA3:REAL; { scheme constants                 }
 KAPPA11,KAPPA12,KAPPA13:REAL; { scheme constants in the first component    }
 KAPPA21,KAPPA22,KAPPA23:REAL; { scheme constants in the second component   }
 KAPPA10,KAPPA14:REAL;  { scheme constants in the first component(R.-Kutta) }
 KAPPA20,KAPPA24:REAL;  { scheme constants in the second component(R.-Kutta)}
 A1,A2:REAL;            { Stratonovich drift values(order 2.0 Taylor)       }
 H1,H2:REAL;            { local help numbers for the order 2.0 Taylor scheme}
 LAMBDA1,LAMBDA2:REAL;  { Lyapunov exponents of this two-dimensional system }
 X1T,X2T:REAL;          { components of the exact solution (X1(ti),X2(ti))  }
 Y1T,Y2T:REAL;          { components of the approximation (Y1(ti),Y2(ti))   }
 AVERAGE,VARIANCE:REAL; { statistical parameters                            }
 EPSYLON:VECTOR0;       { sum of the absolute errors within a batch         }
 DEL:VECTOR1;           { time step sizes                                   }
 DIFFER:VECTOR1;        { half of the confidence interval lengths           }
 EPS:VECTOR1;           { absolute errors for different time step sizes     }
 INVEPS:VECTOR1;        { inverted errors EPS                               }
 TIMER:VECTOR1;         { time elapsed by the generation                    }

{ Generates the components of the exact solution }

PROCEDURE EXPLSOL(TI,WT:REAL;VAR X1,X2:REAL);
VAR
 EROP,EROM,Q1,Q2:REAL;
BEGIN
 EROP:=EXP(LAMBDA1*(TI-T0)+BETA*WT);EROM:=EXP(LAMBDA2*(TI-T0)+BETA*WT);
 Q1:=0.5*(EROP+EROM);Q2:=0.5*(EROP-EROM);
 X1:=Q1*X10+Q2*X20;X2:=Q2*X10+Q1*X20;
END;{ EXPLSOL }

{ Generates the error criterion formula using Euclidean norm }

FUNCTION SQRTERR(X1,X2,Y1,Y2:REAL):REAL;
BEGIN
 SQRTERR:=SQRT((X1-Y1)*(X1-Y1)+(X2-Y2)*(X2-Y2)); { Euclidean norm }
END;{ SQRTERR }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Takes the elapsed time in seconds for run times not exceeding one day }
{ Assumes GETTIME(HOUR,MINUTE,SECOND,SEC100) has been called before     }
{ Output time as a string TIME and as a real number RTIME               }

PROCEDURE TIMEINSEC(VAR TIME:STRING;VAR RTIME:REAL);
VAR
 ABSSEC,ABSSEC100,OLDHOUR,OLDMINUTE,OLDSEC100,OLDSECOND:WORD;
 CR:STRING;
BEGIN
 OLDHOUR:=HOUR;OLDMINUTE:=MINUTE;OLDSECOND:=SECOND;OLDSEC100:=SEC100;
 GETTIME(HOUR,MINUTE,SECOND,SEC100);
 IF SEC100<OLDSEC100 THEN
   BEGIN OLDSECOND:=OLDSECOND+1;ABSSEC100:=100-OLDSEC100+SEC100; END
  ELSE ABSSEC100:=SEC100-OLDSEC100;
 IF SECOND<OLDSECOND THEN
   BEGIN OLDMINUTE:=OLDMINUTE+1;ABSSEC:=60-OLDSECOND+SECOND; END
  ELSE ABSSEC:=SECOND-OLDSECOND;
 IF MINUTE<OLDMINUTE THEN
   BEGIN OLDHOUR:=OLDHOUR+1;ABSSEC:=ABSSEC+60*(60-OLDMINUTE+MINUTE); END
  ELSE ABSSEC:=ABSSEC+60*(MINUTE-OLDMINUTE);
 IF HOUR<OLDHOUR THEN ABSSEC:=ABSSEC+3600*(24-OLDHOUR+HOUR)
  ELSE ABSSEC:=ABSSEC+3600*(HOUR-OLDHOUR);
 STR(ABSSEC,CR);TIME:=CR+'.';STR(ABSSEC100,CR);
 IF ((LENGTH(CR)=1) AND (CR<>'0')) THEN CR:='0'+CR;
 TIME:=TIME+CR;
 RTIME:=ABSSEC+ABSSEC100/100;
END;{ TIMEINSEC }

{ Provides echo signals on the screen that parameters have been installed }
{ and schemes are just in progress or schemes have been done              }
{ Input NN determining the output line and scheme number                  }

PROCEDURE ECHO(NN:INTEGER;SCHEMETITLE:STRING);
VAR POS1,POS2,POS3,POS4,THM:INTEGER;
BEGIN
 THM:=TEXTHEIGHT('M');
 POS1:=TRUNC(MAXX/2);POS2:=3*(NN+5)*THM;POS3:=11*THM;POS4:=13*THM;
 CASE NN OF
  -4..-2   : OUTTEXTXY(POS1,POS2,SCHEMETITLE);
    -1     : OUTTEXTXY(POS1,POS2,SCHEMETITLE+' ... in progress');
   1..10   : BEGIN
              SETFILLSTYLE(0,0);BAR(1,POS3,MAXX-1,POS4);SETFILLSTYLE(0,1);
              OUTTEXTXY(POS1,POS2,SCHEMETITLE+' ... done');
             END;
  11,12,13 : OUTTEXTXY(POS1,POS2,SCHEMETITLE+' ... installed')
 END;
END;{ ECHO }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Exercise 4.4.4 (Efficiency comparison between implicit schemes)');
 STATUSLINE('Be patient! This will take the computer some time!');
 CR:='dX1(t)  =  ALPHA * ( X2(t) - X1(t) ) dt  +  BETA * X1(t) dW(t)';
 ECHO(-4,CR); { delivers an echo signal to the screen equation implemented }
 CR:='dX2(t)  =  ALPHA * ( X1(t) - X2(t) ) dt  +  BETA * X2(t) dW(t)';
 ECHO(-3,CR); { delivers an echo signal to the screen equation implemented }
 LAMBDA1:=-0.5*BETA*BETA;LAMBDA2:=LAMBDA1-2.*ALPHA;CR:=CHCR(LAMBDA2);
 CR:='with Lyapunov exponents LAMBDA1='+CHCR(LAMBDA1)+' and LAMBDA2='+CR;
 ECHO(-2,CR); { delivers an echo signal to the screen on Lyapunov exponents }
 CR:='<Parameters> : M='+CHCR(M)+'/N='+CHCR(N)+'/ALPHA='+CHCR(ALPHA);
 CR:=CR+'/BETA='+CHCR(BETA)+'/X1(0)='+CHCR(X10)+'/X2(0)='+CHCR(X20);
 ECHO(11,CR); { delivers an echo signal to the screen on parameters used }
 ECHO(12,'Number of different time step sizes used : '+CHCR(NUM));
 CR:='Implicitness used : ('+CHCR(ALPHAK1)+','+CHCR(ALPHAK2)+','+CHCR(BETAK1);
 CR:=CR+','+CHCR(BETAK2)+')';ECHO(13,CR);

{ Implicit Euler approximation : }

 CR:='Implicit Euler';
 ECHO(-1,CR); { displays the scheme being just in work }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time    }
  G:=G+1;                   { index of the time step size used   }
  DELTA_Y:=DELTA_Y/2;       { current time step size             }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y             }
  KAPPA0:=ALPHA*DELTA_Y;    { initialization of scheme constants }
  KAPPA1:=KAPPA0*(2.0-ALPHAK1-ALPHAK2);KAPPA2:=1.0+KAPPA0*(ALPHAK1+ALPHAK2);

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                }
   EPSYLON[J]:=0.0; { sum of the strong errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used         }
    WT:=0.0; { value of the Wiener process at t=T0  }

   { Generation of the Euler approximation and its strong error : }

    I:=0;
    TI:=T0;   { initial time                                           }
    Y1T:=X10; { initial value of first component of the approximation  }
    Y2T:=X20; { initial value of second component of the approximation }
    HII:=Y2T-Y1T;
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }

     { Implicit Euler scheme : }

      HH:=1.0+BETA*DWTI;
      HI:=HII;HII:=HII*(HH-KAPPA1)/KAPPA2;
      Y1T:=Y1T*HH+KAPPA0*(ALPHAK1*HII+(1.0-ALPHAK1)*HI);
      Y2T:=Y2T*HH-KAPPA0*(ALPHAK2*HII+(1.0-ALPHAK2)*HI);

     END;{ WHILE }

   { Summation of the errors : }

    EXPLSOL(TI,WT,X1T,X2T); { calculates the components of the solution }
    EPSYLON[J]:=EPSYLON[J]+SQRTERR(X1T,X2T,Y1T,Y2T);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);TIMER[G]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<1>  Implicit Euler in '+TIME+' seconds';
 ECHO(1,CR); { delivers an echo signal to the screen scheme ... done }

{ Implicit Milstein approximation : }

 CR:='Implicit Milstein';
 ECHO(-1,CR); { displays the scheme being just in work }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                   { index of the time step size used    }
  DELTA_Y:=DELTA_Y/2;       { current time step size              }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y              }
  KAPPA0:=ALPHA*DELTA_Y;    { initialization of scheme parameters }
  KAPPA1:=KAPPA0*(2.0-ALPHAK1-ALPHAK2);KAPPA2:=1.0+KAPPA0*(ALPHAK1+ALPHAK2);

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                }
   EPSYLON[J]:=0.0; { sum of the strong errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used         }
    WT:=0.0; { value of the Wiener process at t=T0  }

   { Generation of the implicit approximation and its strong error : }

    I:=0;
    TI:=T0;   { initial time                                           }
    Y1T:=X10; { initial value of first component of the approximation  }
    Y2T:=X20; { initial value of second component of the approximation }
    HII:=Y2T-Y1T;
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }
      I11:=0.5*(DWTI*DWTI-DELTA_Y); { multiple Ito integral I11         }

     { Implicit Milstein scheme : }

      HH:=1.0+BETA*(DWTI+BETA*I11);
      HI:=HII;HII:=HII*(HH-KAPPA1)/KAPPA2;
      Y1T:=Y1T*HH+KAPPA0*(ALPHAK1*HII+(1.0-ALPHAK1)*HI);
      Y2T:=Y2T*HH-KAPPA0*(ALPHAK2*HII+(1.0-ALPHAK2)*HI);

     END;{ WHILE }

   { Summation of the errors : }

    EXPLSOL(TI,WT,X1T,X2T); { calculates the components of the solution }
    EPSYLON[J]:=EPSYLON[J]+SQRTERR(X1T,X2T,Y1T,Y2T);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G+NUM]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G+NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G+NUM]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<2>  Implicit Milstein in '+TIME+' seconds';
 ECHO(2,CR); { delivers an echo signal to the screen scheme ... done }

{ Implicit order 1.5 strong Taylor approximation : }

 CR:='Implicit Taylor 1.5';
 ECHO(-1,CR); { displays the scheme being just in work }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 KAPPA13:=BETA*(1.-ALPHAK1);KAPPA23:=BETA*(1.-ALPHAK2); { global constants }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                   { index of the time step size used    }
  DELTA_Y:=DELTA_Y/2;       { current time step size              }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y              }
  KAPPA0:=ALPHA*DELTA_Y;    { initialization of scheme constants  }
  KAPPA11:=ALPHAK1-2.*(0.5-ALPHAK1)*BETAK1*KAPPA0;
  KAPPA12:=1.-ALPHAK1-2.*(0.5-ALPHAK1)*(1.-BETAK1)*KAPPA0;
  KAPPA21:=ALPHAK2-2.*(0.5-ALPHAK2)*BETAK2*KAPPA0;
  KAPPA22:=1.-ALPHAK2-2.*(0.5-ALPHAK2)*(1.-BETAK2)*KAPPA0;
  KAPPA:=1.+KAPPA0*(KAPPA11+KAPPA21);

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                }
   EPSYLON[J]:=0.0; { sum of the strong errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used         }
    WT:=0.0; { value of the Wiener process at t=T0  }

   { Generation of the implicit approximation and its strong error : }

    I:=0;
    TI:=T0;   { initial time                                           }
    Y1T:=X10; { initial value of first component of the approximation  }
    Y2T:=X20; { initial value of second component of the approximation }
    HII:=Y2T-Y1T;
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }
      I11:=0.5*(DWTI*DWTI-DELTA_Y); { multiple integral I11             }
      I111:=DWTI*(DWTI*DWTI-3.*DELTA_Y)/6.; { multiple integral I111    }

     { Implicit order 1.5 strong Taylor scheme(Ito version) : }

      HH:=1.0+BETA*(DWTI+BETA*(I11+BETA*I111));HI:=HII;
      HII:=HII*(HH-KAPPA0*(KAPPA12+KAPPA22+(KAPPA13+KAPPA23)*DWTI))/KAPPA;
      Y1T:=Y1T*HH+KAPPA0*(HII*KAPPA11+HI*(KAPPA12+KAPPA13*DWTI));
      Y2T:=Y2T*HH-KAPPA0*(HII*KAPPA21+HI*(KAPPA22+KAPPA23*DWTI));

     END;{ WHILE }

   { Summation of the errors : }

    EXPLSOL(TI,WT,X1T,X2T); { calculates the components of the solution }
    EPSYLON[J]:=EPSYLON[J]+SQRTERR(X1T,X2T,Y1T,Y2T);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+2*NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G+2*NUM]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G+2*NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G+2*NUM]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+2*NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<3>  Implicit Taylor 1.5 in '+TIME+' seconds';
 ECHO(3,CR); { delivers an echo signal to the screen scheme ... done }

{ Half-implicit order 2.0 strong Taylor approximation(fixed implicitness) : }

 CR:='Half-implicit Taylor 2.0';
 ECHO(-1,CR); { displays the scheme being just in work }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                    { index of the time step size used   }
  DELTA_Y:=DELTA_Y/2;        { current time step size             }
  SQDELTA_Y:=SQRT(DELTA_Y);  { square root of DELTA_Y             }
  KAPPA1:=0.5*ALPHA*DELTA_Y; { initialization of scheme constants }
  KAPPA:=1.0+DELTA_Y*BETA*BETA/4.;KAPPA0:=2.0-KAPPA;KAPPA2:=KAPPA0-KAPPA1;

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                }
   EPSYLON[J]:=0.0; { sum of the strong errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used         }
    WT:=0.0; { value of the Wiener process at t=T0  }

   { Generation of the implicit approximation and its strong error : }

    I:=0;
    TI:=T0;   { initial time                                           }
    Y1T:=X10; { initial value of first component of the approximation  }
    Y2T:=X20; { initial value of second component of the approximation }
    HII:=Y2T-Y1T;
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }
      J111:=DWTI*DWTI*DWTI/6.; { multiple integral J111 }
      J1111:=DWTI*J111/4.; { multiple integral J1111    }

     { Half-implicit order 2.0 strong Taylor scheme(Stratonovich version) : }

      HH:=(KAPPA2*Y1T+KAPPA1*Y2T)*(1.0+0.5*BETA*DWTI);
      FI1:=BETA*(DWTI*HH+BETA*BETA*Y1T*(J111+BETA*J1111));
      HH:=(KAPPA1*Y1T+KAPPA2*Y2T)*(1.0+0.5*BETA*DWTI);
      FI2:=BETA*(DWTI*HH+BETA*BETA*Y1T*(J111+BETA*J1111));
      HI:=HII;
      HII:=(HII*(KAPPA0-2.*KAPPA1)+FI2-FI1)/(KAPPA+2.*KAPPA1);
      Y1T:=(Y1T*KAPPA0+KAPPA1*(HII+HI)+FI1)/KAPPA;
      Y2T:=(Y2T*KAPPA0-KAPPA1*(HII+HI)+FI2)/KAPPA;

     END;{ WHILE }

   { Summation of the errors : }

    EXPLSOL(TI,WT,X1T,X2T); { calculates the components of the solution }
    EPSYLON[J]:=EPSYLON[J]+SQRTERR(X1T,X2T,Y1T,Y2T);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+3*NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G+3*NUM]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G+3*NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G+3*NUM]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+3*NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<4>  Half-implicit Taylor 2.0 in '+TIME+' seconds';
 ECHO(4,CR); { delivers an echo signal to the screen scheme ... done }

{ Implicit order 1.0 Runge-Kutta approximation : }

 CR:='Implicit Runge-Kutta 1.0';
 ECHO(-1,CR); { displays the scheme being just in work }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                   { index of the time step size used   }
  DELTA_Y:=DELTA_Y/2;       { current time step size             }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y             }
  KAPPA3:=ALPHA*DELTA_Y;    { initialization of scheme constants }
  KAPPA1:=0.5*BETA*BETA*DELTA_Y;KAPPA14:=1.0+ALPHAK1*KAPPA1;
  KAPPA24:=1.0+ALPHAK2*KAPPA1;KAPPA12:=ALPHAK1*KAPPA3;KAPPA22:=ALPHAK2*KAPPA3;
  KAPPA10:=KAPPA14-KAPPA1;KAPPA20:=KAPPA24-KAPPA1;KAPPA1:=2.0-KAPPA1;
  KAPPA:=1.0+KAPPA22/KAPPA24+KAPPA12/KAPPA14;

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                }
   EPSYLON[J]:=0.0; { sum of the strong errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used         }
    WT:=0.0; { value of the Wiener process at t=T0  }

   { Generation of the implicit approximation and its strong error : }

    I:=0;
    TI:=T0;   { initial time                                           }
    Y1T:=X10; { initial value of first component of the approximation  }
    Y2T:=X20; { initial value of second component of the approximation }
    HII:=Y2T-Y1T;
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }

     { Implicit order 1.0 Runge-Kutta scheme for commutative noise : }

      HH:=0.5*BETA*DWTI*(KAPPA1+BETA*DWTI);
      Y1T:=(Y1T*(KAPPA10+HH)+KAPPA3*(1.0-ALPHAK1+0.5*BETA*DWTI)*HII)/KAPPA14;
      Y2T:=(Y2T*(KAPPA20+HH)-KAPPA3*(1.0-ALPHAK2+0.5*BETA*DWTI)*HII)/KAPPA24;
      HII:=(Y2T-Y1T)/KAPPA;
      Y1T:=Y1T+KAPPA12*HII/KAPPA14;
      Y2T:=Y2T-KAPPA22*HII/KAPPA24;

     END;{ WHILE }

   { Summation of the errors : }

    EXPLSOL(TI,WT,X1T,X2T); { calculates the components of the solution }
    EPSYLON[J]:=EPSYLON[J]+SQRTERR(X1T,X2T,Y1T,Y2T);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+4*NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G+4*NUM]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G+4*NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G+4*NUM]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+4*NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<5>  Implicit Runge-Kutta 1.0 in '+TIME+' seconds';
 ECHO(5,CR); { delivers an echo signal to the screen scheme ... done }

{ Implicit order 1.0 Runge-Kutta approximation using simplified supporting }
{ value                                                                    }

 CR:='Implicit Runge-Kutta 1.0 using simplified supporting value';
 ECHO(-1,CR); { displays the scheme being just in work }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                   { index of the time step size used   }
  DELTA_Y:=DELTA_Y/2;       { current time step size             }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y             }
  KAPPA3:=ALPHA*DELTA_Y;    { initialization of scheme constants }
  KAPPA1:=0.5*BETA*BETA*DELTA_Y;KAPPA14:=1.0+ALPHAK1*KAPPA1;
  KAPPA24:=1.0+ALPHAK2*KAPPA1;KAPPA12:=ALPHAK1*KAPPA3;KAPPA22:=ALPHAK2*KAPPA3;
  KAPPA10:=KAPPA14-KAPPA1;KAPPA20:=KAPPA24-KAPPA1;KAPPA1:=2.0-KAPPA1;
  KAPPA:=1.0+KAPPA22/KAPPA24+KAPPA12/KAPPA14;

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                }
   EPSYLON[J]:=0.0; { sum of the strong errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used         }
    WT:=0.0; { value of the Wiener process at t=T0  }

   { Generation of the implicit approximation and its strong error : }

    I:=0;
    TI:=T0;   { initial time                                           }
    Y1T:=X10; { initial value of first component of the approximation  }
    Y2T:=X20; { initial value of second component of the approximation }
    HII:=Y2T-Y1T;
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }

     { Simplified impl. order 1.0 Runge-Kutta scheme for commutative noise : }

      HH:=0.5*BETA*DWTI*(2.0+BETA*DWTI);
      Y1T:=(Y1T*(KAPPA10+HH)+KAPPA3*(1.0-ALPHAK1)*HII)/KAPPA14;
      Y2T:=(Y2T*(KAPPA20+HH)-KAPPA3*(1.0-ALPHAK2)*HII)/KAPPA24;
      HII:=(Y2T-Y1T)/KAPPA;
      Y1T:=Y1T+KAPPA12*HII/KAPPA14;
      Y2T:=Y2T-KAPPA22*HII/KAPPA24;

     END;{ WHILE }

   { Summation of the errors : }

    EXPLSOL(TI,WT,X1T,X2T); { calculates the components of the solution }
    EPSYLON[J]:=EPSYLON[J]+SQRTERR(X1T,X2T,Y1T,Y2T);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+5*NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G+5*NUM]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G+5*NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G+5*NUM]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+5*NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<6>  Implicit Runge-Kutta 1.0(simplified support) in ';
 CR:=CR+TIME+' seconds';
 ECHO(6,CR); { delivers an echo signal to the screen scheme ... done }

{ The order 2.0 strong Taylor approximation(nonimplicit!): }

 CR:='Nonimplicit Taylor 2.0';
 ECHO(-1,CR); { displays the scheme being just in work }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time    }
  G:=G+1;                      { index of the time step size used   }
  DELTA_Y:=DELTA_Y/2;          { current time step size             }
  SQDELTA_Y:=SQRT(DELTA_Y);    { square root of DELTA_Y             }
  KAPPA0:=ALPHA+0.5*BETA*BETA; { initialization of scheme constants }
  KAPPA1:=1.0-0.5*KAPPA0*DELTA_Y;KAPPA2:=0.5*ALPHA*DELTA_Y*DELTA_Y;

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                }
   EPSYLON[J]:=0.0; { sum of the strong errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used         }
    WT:=0.0; { value of the Wiener process at t=T0  }

   { Generation of the order 2.0 Taylor approximation and its strong error : }

    I:=0;
    TI:=T0;   { initial time                                           }
    Y1T:=X10; { initial value of first component of the approximation  }
    Y2T:=X20; { initial value of second component of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }

     { The order 2.0 Taylor scheme(nonimplicit!) : }

      A1:=ALPHA*Y2T-KAPPA0*Y1T; { Stratonovich drift 1 }
      A2:=ALPHA*Y1T-KAPPA0*Y2T; { Stratonovich drift 2 }
  H1:=1.0+BETA*DWTI*(1.0+0.5*BETA*DWTI*(1.0+BETA*DWTI*(1.0+BETA*DWTI/4.0)/3.0));
      H2:=(KAPPA1+BETA*DWTI*(1.0+0.5*BETA*DWTI))*DELTA_Y;
      Y1T:=Y1T*H1+A1*H2+A2*KAPPA2;
      Y2T:=Y2T*H1+A2*H2+A1*KAPPA2;

     END;{ WHILE }

   { Summation of the errors : }

    EXPLSOL(TI,WT,X1T,X2T); { calculates the components of the solution }
    EPSYLON[J]:=EPSYLON[J]+SQRTERR(X1T,X2T,Y1T,Y2T);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+6*NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G+6*NUM]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G+6*NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G+6*NUM]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+6*NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<7>  Nonimplicit Taylor 2.0 in '+TIME+' seconds';
 ECHO(7,CR); { delivers an echo signal to the screen scheme ... done }
 STATUSLINE('Ready. Press any key except <ESC> !');
 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the error graphs in the logarithmic graphic table : }

 CLEARDEVICE;
 GRAPH441(7,NUM,EPS,DEL,'log2(EPS)','log2(DELTA)');
 CR:='Linearly interpolated (log2(EPS),log2(DELTA)) - graph';
 CR:=CR+'<Implicit,Taylor 2.0,t='+CHCR(T)+'>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the logarithmic graphic table for the efficiency comparison : }

 CLEARDEVICE;
 GRAPH441(7,NUM,TIMER,INVEPS,'log2(TIME)','-log2(EPS)');
 CR:='Linearly interpolated (-log2(EPS),log2(TIME)) - graph';
 CR:=CR+'<Implicit,Taylor 2.0,t='+CHCR(T)+'>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the time consumption in the logarithmic graphic table : }

 CLEARDEVICE;
 GRAPH441(7,NUM,TIMER,DEL,'log2(TIME)','log2(DELTA)');
 CR:='Linearly interpolated (log2(TIME),log2(DELTA)) - graph';
 CR:=CR+'<Implicit,Taylor 2.0,t='+CHCR(T)+'>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ EXX4X4X4 }

{ If desired
    choose the corresponding confidence intervals by EPS, DIFFER and DEL
   and add the following :

  Printout of the confidence intervals :

 CLEARDEVICE;
 CONFINV(NUM,EPS,DIFFER,DEL,'EPS','DELTA');
 CR:='90% Confidence intervals for the absolute error EPS(t=';
 CR:=CR+CHCR(T)+')'+'  <Implicit>';
 STATUSLINE(CR);
}