{ Simulation studies with a nonlinear stochastic differential equation      }
{ Comparison of the efficiency between selected schemes : Euler, Milstein,  }
{ 1.5 order Taylor and 2.0 order Taylor scheme which are generally imple-   }
{ mented(without any use of the particular structure of the given equation  }
{ in the one-dimensional case at the time t = T                             }
{ Considers the nonlinear stochastic differential equation                  }
{   dX(t) = ( ALPHA^2/(t+1) - 2 * (X(t)-SQRT(X(t)*X(0))) )/(t+1)  dt        }
{               + 2 * ALPHA * SQRT(X(t))/(t+1) dW(t)     with  X(T0) = X0   }
{ on the time interval [T0,T] where W(t) is a Wiener process                }
{ Equidistant approximation of X(t) with different time step sizes DELTA    }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the absolute errors at the }
{ time T using M batches(M=20) with the sample size N { without printout!)  }
{ Plots the log2 of the absolute errors against the log2 of the step sizes  }
{ Plots the log2 of the elapsed time against  - log2 of these errors        }
{ Plots the log2 of the elapsed time against the log2 of the step sizes     }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch number remember that the corresponding per-  }
{        centage point of the t-distribution should also be changed.        }
{        For the measurement of the necessary time take the sample size     }
{        large enough. Confidence intervals can be plotted by calling the   }
{        routine CONFINV. See preparations at the end of this file.         }
{ Run time errors may occur if the current approximation value YT is nega-  }
{ tive. How often this happens depends on the choice of (ALPHA,X0) !        }

PROGRAM EXX4X4X4;

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,EXTGRAPH;

CONST
 NUM=9;         { number of different time step sizes                 }
 T0=0.0;        { left end point                                      }
 T=1.0;         { right end point                                     }
 DELTA=T-T0;    { largest time step size of the strong approximations }
 X0=100;        { initial value                                       }
 ALPHA=2.0;     { parameter in the drift A(t,x) and diffusion B(t,x)  }
 P=5;           { truncation parameter for the multiple integrals     }
 M=20;          { number of batches                                   }
 N=100;         { sample size of one batch                            }
 QUANTILE=1.73; { percentage point of the t-distribution              }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;             { help string                                       }
 TIME:STRING;           { elapsed total computational time in seconds       }
 HOUR,MINUTE,SECOND,SEC100:WORD; { help time values                         }
 THOUR,TMINUTE,TSECOND,TSEC100:WORD; { help time values                     }
 G:INTEGER;             { index of the current time step size               }
 I:INTEGER;             { time step index                                   }
 J:INTEGER;             { batch index                                       }
 K:INTEGER;             { sample index within the current batch             }
 RTIME:REAL;            { elapsed time converted in a REAL type             }
 SQRT3:REAL;            { square root of 3.0                                }
 Q,QQ,QQ2,SQRTXI,SQRTX0:REAL; { help values                                 }
 TIOLD:REAL;            { left subinterval point                            }
 TI:REAL;               { right subinterval point                           }
 DELTA_Y:REAL;          { time step size of the strong approximation        }
 SQDELTA_Y:REAL;        { square root of the time step size DELTA_Y         }
 G1,G2:REAL;            { Gaussian random numbers                           }
 WT:REAL;               { value of the Wiener process at time ti            }
 DWTI:REAL;             { Wiener process increment  W(t(i+1)) - W(ti)       }
 AA,DADX,BB,DBDX:REAL;  { function values for the Taylor schemes            }
 DDADXX,DDBDXX:REAL;    { function values for the Taylor schemes            }
 DDBDXT,DDDBDXXX:REAL;  { function values for the order 2.0 Taylor scheme   }
 CORRDRIFT:REAL;        { value of the corresponding Stratonovich drift     }
 L0A11,L0B11,L1A11,L1B11,L1L1B11:REAL; { values of the functional operators }
 L1L1A11,L1L0B11,L0L1B11,L1L1L1B11:REAL;{ values of the functional operators}
 DL1B11DX:REAL;         { help variable(derivative of the operator L1B11)   }
 I1,I11,I10,I01,I00,I111:REAL; { multiple Ito integrals                     }
 J1,J11,J00,J111,J1111:REAL; { multiple Stratonovich integrals              }
 J10,J01,J110,J101,J011:REAL;{ multiple Stratonovich integrals approximated }
 ALPHAP,ROP:REAL;       { approximation parameter of the multiple integrals }
 XT:REAL;               { value of the exact solution X(t)                  }
 YT:REAL;               { value of the strong approximation using DELTA_Y   }
 AVERAGE,VARIANCE:REAL; { statistical parameters                            }
 EPSYLON:VECTOR0;       { sum of the absolute errors within a batch         }
 DEL:VECTOR1;           { time step sizes                                   }
 DIFFER:VECTOR1;        { half of the confidence interval lengths           }
 EPS:VECTOR1;           { absolute errors for different time step sizes     }
 INVEPS:VECTOR1;        { inverted errors EPS                               }
 TIMER:VECTOR1;         { time elapsed by the generation                    }

{ Generates help values for the scheme evaluation                   }
{ Reduces the number of frequently appearing expressions            }
{ Variable SCHEME controls the number of the necessary help values. }

PROCEDURE HELPSCHEME(SCHEME:INTEGER;TI,XI:REAL);
BEGIN
 SQRTXI:=SQRT(XI);QQ:=TI+1.0;
 IF SCHEME>1 THEN Q:=ALPHA/SQRTXI;
 IF SCHEME>2 THEN QQ2:=QQ*QQ;;
END;{ HELPSCHEME }

{ Generates the drift function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=(ALPHA*ALPHA/QQ-2.*(XI-SQRTX0*SQRTXI))/QQ;
END;{ A }

{ Generates the first partial derivatives of the drift function A(t,x) }

FUNCTION DAX(TI,XI:REAL):REAL; { x derivative }
BEGIN
 DAX:=-2.*(1.-0.5*SQRTX0/SQRTXI)/QQ;
END;{ DAX }

FUNCTION DAT(TI,XI:REAL):REAL; { t derivative }
BEGIN
 DAT:=-2.*(ALPHA*ALPHA/QQ-XI+SQRTX0*SQRTXI)/QQ2;
END;{ DAT }

{ Generates the second x partial derivative of the drift function A(t,x) }

FUNCTION DDAXX(TI,XI:REAL):REAL; { x derivative }
BEGIN
 DDAXX:=-0.5*SQRTX0/(SQRTXI*XI*QQ);
END;{ DDAXX }

{ Generates the diffusion function B(t,x) }

FUNCTION B(TI,XI:REAL):REAL;
BEGIN
 B:=2.*ALPHA*SQRTXI/QQ;
END;{ B }

{ Generates the first partial derivatives of the diffusion function B(t,x) }

FUNCTION DBX(TI,XI:REAL):REAL; { x derivative }
BEGIN
 DBX:=Q/QQ; { = ALPHA/(SQRT(XI)*(TI+1)) }
END;{ DBX }

FUNCTION DBT(TI,XI:REAL):REAL; { t derivative }
BEGIN
 DBT:=-2.*ALPHA*SQRTXI/QQ2;
END;{ DBT }

{ Generates the second partial derivatives of the diffusion function B(t,x) }

FUNCTION DDBXX(TI,XI:REAL):REAL; { x derivative }
BEGIN
 DDBXX:=-0.5*Q/(XI*QQ); { = -0.5*ALPHA/(XI*SQRT(XI)*(TI+1)) }
END;{ DDBXX }

FUNCTION DDBXT(TI,XI:REAL):REAL; { derivative w.r.t. x and t }
BEGIN
 DDBXT:=-Q/QQ2; { = -ALPHA/(SQRT(XI)*(TI+1)*(TI+1)) }
END;{ DDBXT }

FUNCTION DDBTX(TI,XI:REAL):REAL; { derivative w.r.t. t and x }
BEGIN
 DDBTX:=-Q/QQ2; { identical with DDBXT in this case }
END;{ DDBTX }

{ Generates the third x partial derivative of the diffusion function B(t,x) }

FUNCTION DDDBXXX(TI,XI:REAL):REAL; { x derivative }
BEGIN
 DDDBXXX:=0.75*Q/(XI*XI*QQ);  { = 0.75*ALPHA/(XI*XI*SQRT(XI)*(TI+1)) }
END;{ DDDBXXX }

{ Generates the functional form of the exact solution }

FUNCTION EXPLSOL(TI,WT:REAL):REAL;
BEGIN
 EXPLSOL:=(ALPHA*WT/(TI+1.0)+SQRTX0)*(ALPHA*WT/(TI+1.0)+SQRTX0);
END;{ EXPLSOL }

{ Generates the error criterion formula }

FUNCTION ABSERR(XT,YT:REAL):REAL;
BEGIN
 ABSERR:=ABS(XT-YT); { absolute error }
END;{ ABSERR }

{ Sets the parameters for the procedure MULTIINT }

PROCEDURE SETUPPARAMULTIINT(P:INTEGER;VAR ALPHAP,ROP:REAL);
VAR
 R:INTEGER;
 INCRE:REAL;
BEGIN
 ALPHAP:=0.0;ROP:=0.0;
 FOR R:=1 TO P DO
  BEGIN
   INCRE:=1/(R*R);ROP:=ROP+INCRE;ALPHAP:=ALPHAP+INCRE*INCRE;
  END;
 ALPHAP:=(PI*PI*PI*PI/90-ALPHAP)/(2*PI*PI);
 ROP:=PI*PI/6-ROP;ROP:=ROP/(2*PI*PI);
END;{ SETUPPARAMULTIINT }

{ Generates the multiple Stratonovich integrals                         }
{ J1, J01, J10, J11, J011, J101, and J110                               }
{ Uses the time step size DELTA_Y; P = accuracy parameter               }
{ Assumes the Gaussian random number DWT has already been generated and }
{ SETUPPARAMULTIINT has been called before                              }

PROCEDURE MULTIINT(P:INTEGER;DWT:REAL;VAR J1,J01,J10,J11,J011,J101,J110:REAL);
VAR
 R,L:INTEGER;
 A10,B11P,B1P,C11P,FI1P,GSI,MUE1P:REAL;
 ETA1,FI1:VECTOR;
BEGIN
 GENERATE(FI1P,MUE1P);
 A10:=0.0;B1P:=0.0;B11P:=0.0;
 FOR R:=1 TO P DO
  BEGIN
   GENERATE(FI1[R],ETA1[R]);
   A10:=A10+FI1[R]/R;
   B1P:=B1P+ETA1[R]/(R*R);
   B11P:=B11P+(FI1[R]*FI1[R]+ETA1[R]*ETA1[R])/(R*R);
  END;
 A10:=-(1./PI)*A10*SQRT(2.0)*SQDELTA_Y;
 A10:=A10-2.*SQDELTA_Y*SQRT(ROP)*MUE1P;
 B1P:=B1P*SQDELTA_Y/SQRT(2.0)+SQDELTA_Y*SQRT(ALPHAP)*FI1P;
 B11P:=B11P/(4.*PI*PI);
 GSI:=DWT;
 J1:=GSI*SQDELTA_Y; { increment of the Wiener trajectory = J1 }
 J10:=0.5*DELTA_Y*(J1+A10); { multiple integral J10 }
 J01:=J1*DELTA_Y-J10; { multiple integral J01 }
 J11:=0.5*J1*J1; { multiple integral J11 }
 C11P:=0.0;
 R:=0;
 REPEAT
  R:=R+1;
  L:=0;
  REPEAT
   L:=L+1;
   IF L<>R THEN
    C11P:=C11P+(R/(R*R-L*L))*(FI1[R]*FI1[L]/L-ETA1[R]*ETA1[L]*L/R);
  UNTIL L=P;
 UNTIL R=P;
 C11P:=-C11P/(2.*PI*PI);
 J101:=SQR(DELTA_Y*GSI)/6-DELTA_Y*A10*A10/4;
 J101:=J101+SQDELTA_Y*DELTA_Y*GSI*B1P/PI;
 J101:=J101-DELTA_Y*DELTA_Y*B11P; { multiple integral J101 }
 J110:=SQR(DELTA_Y*GSI)/6+DELTA_Y*A10*A10/4;
 J110:=J110-SQDELTA_Y*DELTA_Y*GSI*B1P/(2.*PI);
 J110:=J110+SQDELTA_Y*DELTA_Y*A10*GSI/4;
 J110:=J110-DELTA_Y*DELTA_Y*C11P; { multiple integral J110 }
 J011:=J11*DELTA_Y-J101-J110; { multiple integral J011 }
END;{ MULTIINT }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Takes the elapsed time in seconds for run times not exceeding one day }
{ Assumes GETTIME(HOUR,MINUTE,SECOND,SEC100) has been called before     }
{ Output time as a string TIME and as a real number RTIME               }

PROCEDURE TIMEINSEC(VAR TIME:STRING;VAR RTIME:REAL);
VAR
 ABSSEC,ABSSEC100,OLDHOUR,OLDMINUTE,OLDSEC100,OLDSECOND:WORD;
 CR:STRING;
BEGIN
 OLDHOUR:=HOUR;OLDMINUTE:=MINUTE;OLDSECOND:=SECOND;OLDSEC100:=SEC100;
 GETTIME(HOUR,MINUTE,SECOND,SEC100);
 IF SEC100<OLDSEC100 THEN
   BEGIN OLDSECOND:=OLDSECOND+1;ABSSEC100:=100-OLDSEC100+SEC100; END
  ELSE ABSSEC100:=SEC100-OLDSEC100;
 IF SECOND<OLDSECOND THEN
   BEGIN OLDMINUTE:=OLDMINUTE+1;ABSSEC:=60-OLDSECOND+SECOND; END
  ELSE ABSSEC:=SECOND-OLDSECOND;
 IF MINUTE<OLDMINUTE THEN
   BEGIN OLDHOUR:=OLDHOUR+1;ABSSEC:=ABSSEC+60*(60-OLDMINUTE+MINUTE); END
  ELSE ABSSEC:=ABSSEC+60*(MINUTE-OLDMINUTE);
 IF HOUR<OLDHOUR THEN ABSSEC:=ABSSEC+3600*(24-OLDHOUR+HOUR)
  ELSE ABSSEC:=ABSSEC+3600*(HOUR-OLDHOUR);
 STR(ABSSEC,CR);TIME:=CR+'.';STR(ABSSEC100,CR);
 IF ((LENGTH(CR)=1) AND (CR<>'0')) THEN CR:='0'+CR;
 TIME:=TIME+CR;
 RTIME:=ABSSEC+ABSSEC100/100;
END;{ TIMEINSEC }

{ Provides echo signals on the screen that parameters have been installed }
{ and schemes are just in progress or schemes have been done              }
{ Input NN determining the output line and scheme number                  }

PROCEDURE ECHO(NN:INTEGER;SCHEMETITLE:STRING);
VAR POS1,POS2,POS3,POS4,THM:INTEGER;
BEGIN
 THM:=TEXTHEIGHT('M');
 POS1:=TRUNC(MAXX/2);POS2:=3*(NN+5)*THM;POS3:=11*THM;POS4:=13*THM;
 CASE NN OF
  -4..-2   : OUTTEXTXY(POS1,POS2,SCHEMETITLE);
    -1     : OUTTEXTXY(POS1,POS2,SCHEMETITLE+' ... in progress');
   1..10   : BEGIN
              SETFILLSTYLE(0,0);BAR(1,POS3,MAXX-1,POS4);SETFILLSTYLE(0,1);
              OUTTEXTXY(POS1,POS2,SCHEMETITLE+' ... done');
             END;
   11,12   : OUTTEXTXY(POS1,POS2,SCHEMETITLE+' ... installed')
 END;
END;{ ECHO }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Exercise 4.4.4 (Efficiency with a nonlinear example)');
 STATUSLINE('Be patient! This will take the computer some time!');
 CR:='dX(t) = ( ALPHA^2/(t+1) - 2*(X(t)-SQRT(X(t)*X(0))) )/(t+1)  dt';
 ECHO(-4,CR); { delivers an echo signal to the screen equation implemented }
 CR:='+ 2*ALPHA*SQRT(X(t))/(t+1)  dW(t)';
 ECHO(-3,CR); { delivers an echo signal to the screen equation implemented }
 CR:='<Parameters> : P='+CHCR(P)+'/M='+CHCR(M)+'/N='+CHCR(N)+'/ALPHA=';
 CR:=CR+CHCR(ALPHA)+'/X(0)='+CHCR(X0);
 ECHO(11,CR); { delivers an echo signal to the screen on parameters used }
 ECHO(12,'Number of different time step sizes used : '+CHCR(NUM));

 SQRTX0:=SQRT(X0); { global constant }

{ Euler approximation : }

 ECHO(-1,'Euler'); { screen output scheme in progress }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used          }
    WT:=0.0; { value of the Wiener process at t = T0 }

   { Generation of the Euler approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }
      HELPSCHEME(1,TI-DELTA_Y,YT); { computes local constants }

     { Euler scheme : }

      YT:=YT+A(TI-DELTA_Y,YT)*DELTA_Y+B(TI-DELTA_Y,YT)*DWTI;

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);TIMER[G]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<1>  Euler in '+TIME+' seconds';
 ECHO(1,CR); { delivers an echo signal to the screen scheme ... done }

{ Milstein approximation : }

 ECHO(-1,'Milstein'); { screen output scheme in progress }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }
    WT:=0.0; { value of the Wiener process at t=T0 }

   { Generation of the Milstein approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }
      HELPSCHEME(2,TI-DELTA_Y,YT); { computes local constants }

     { Milstein scheme(Ito version) : }

      I1:=DWTI;I11:=0.5*(DWTI*DWTI-DELTA_Y);
      AA:=A(TI-DELTA_Y,YT);BB:=B(TI-DELTA_Y,YT);
      DBDX:=DBX(TI-DELTA_Y,YT);L1B11:=BB*DBDX;
      YT:=YT+AA*DELTA_Y       { drift part     }
            +BB*I1+L1B11*I11; { diffusion part }

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G+NUM]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G+NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G+NUM]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<2>  Milstein in '+TIME+' seconds';
 ECHO(2,CR); { delivers an echo signal to the screen scheme ... done }

{ The order 1.5 Taylor approximation : }

 ECHO(-1,'Taylor 1.5'); { screen output scheme in progress }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 SQRT3:=SQRT(3);DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }
    WT:=0.0; { value of the Wiener process at t=T0 }

   { Generation of the Taylor approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;             { time step index                             }
      TI:=TI+DELTA_Y;     { current time                                }
      GENERATE(G1,G2);    { uses the Polar Marsaglia method             }
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }
      HELPSCHEME(3,TI-DELTA_Y,YT); { computes local constants }

     { Generation of the multiple Ito integrals : }

      I1:=DWTI;I11:=0.5*(DWTI*DWTI-DELTA_Y);I00:=0.5*DELTA_Y*DELTA_Y;
      I10:=0.5*SQDELTA_Y*DELTA_Y*(G1+G2/SQRT3);I01:=DWTI*DELTA_Y-I10;
      I111:=0.5*(DWTI*DWTI/3-DELTA_Y)*DWTI;

     { 1.5 order strong Taylor scheme(Ito version) : }

      TIOLD:=TI-DELTA_Y;
      AA:=A(TIOLD,YT);DADX:=DAX(TIOLD,YT);
      BB:=B(TIOLD,YT);DBDX:=DBX(TIOLD,YT);
      L0A11:=DAT(TIOLD,YT)+AA*DADX+0.5*BB*BB*DDAXX(TIOLD,YT);
      L0B11:=DBT(TIOLD,YT)+AA*DBDX+0.5*BB*BB*DDBXX(TIOLD,YT);
      L1A11:=BB*DADX;L1B11:=BB*DBDX;
      L1L1B11:=BB*(DBDX*DBDX+BB*DDBXX(TIOLD,YT));
      YT:=YT+AA*DELTA_Y+BB*I1+L1B11*I11+L1A11*I10+L0B11*I01+L0A11*I00
            +L1L1B11*I111;

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+2*NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G+2*NUM]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G+2*NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G+2*NUM]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+2*NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<3>  Taylor 1.5 in '+TIME+' seconds';
 ECHO(3,CR); { delivers an echo signal to the screen scheme ... done }

{ The order 2.0 Taylor approximation generally implemented : }

 ECHO(-1,'Taylor 2.0'); { screen output scheme in progress }
 GETTIME(THOUR,TMINUTE,TSECOND,TSEC100); { gets the current time }
 SETUPPARAMULTIINT(P,ALPHAP,ROP); { sets the parameters for MULTIINT }
 DELTA_Y:=2.*DELTA;G:=0;
 REPEAT { for different time step sizes }
  GETTIME(HOUR,MINUTE,SECOND,SEC100); { gets the current time }
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                                  }
   EPSYLON[J]:=0.0; { sum of the absolute errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1;  { index of the trajectory used        }
    WT:=0.0; { value of the Wiener process at t=T0 }

   { Generation of the Taylor approximation and its absolute error : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      IF I MOD 2 = 1 THEN GENERATE(G1,G2) { uses the Polar Marsaglia method }
       ELSE G1:=G2;
      DWTI:=G1*SQDELTA_Y; { Wiener process increment  W(t(i+1)) - W(ti) }
      WT:=WT+DWTI;        { value of the Wiener process W(t) at t = TI  }
      HELPSCHEME(4,TI-DELTA_Y,YT); { computes local constants }

     { Generation of the multiple integrals : }

      MULTIINT(P,G1,J1,J01,J10,J11,J011,J101,J110);
      J00:=0.5*DELTA_Y*DELTA_Y;J111:=J11*DWTI/3;J1111:=J111*DWTI/4;

     { 2.0 order strong Taylor scheme(Stratonovich version) : }

      TIOLD:=TI-DELTA_Y;
      AA:=A(TIOLD,YT);DADX:=DAX(TIOLD,YT);DDADXX:=DDAXX(TIOLD,YT);
      BB:=B(TIOLD,YT);DBDX:=DBX(TIOLD,YT);DDBDXX:=DDBXX(TIOLD,YT);
      DDBDXT:=DDBXT(TIOLD,YT);DDDBDXXX:=DDDBXXX(TIOLD,YT);
      L1B11:=BB*DBDX;CORRDRIFT:=AA-0.5*L1B11;DL1B11DX:=DBDX*DBDX+BB*DDBDXX;
      L0A11:=DAT(TIOLD,YT)-0.5*(DBT(TIOLD,YT)*DBDX+BB*DDBDXT);
      L0A11:=L0A11+CORRDRIFT*(DADX-0.5*DL1B11DX);
      L1A11:=BB*(DADX-0.5*DL1B11DX);
      L1L1A11:=DBDX*L1A11+BB*BB*(DDADXX-0.5*(3.*DBDX*DDBDXX+BB*DDDBDXXX));
      L0B11:=DBT(TIOLD,YT)+CORRDRIFT*DBDX;
      L0L1B11:=DBT(TIOLD,YT)*DBDX+BB*DDBDXT+CORRDRIFT*DL1B11DX;
      L1L0B11:=BB*(DDBTX(TIOLD,YT)+(DADX-0.5*DL1B11DX)*DBDX+CORRDRIFT*DDBDXX);
      L1L1B11:=BB*DL1B11DX;
      L1L1L1B11:=DBDX*L1L1B11+BB*BB*(3.*DBDX*DDBDXX+BB*DDDBDXXX);
      YT:=YT+CORRDRIFT*DELTA_Y+BB*J1+L1B11*J11+L1A11*J10+L0B11*J01;
      YT:=YT+L0A11*J00+L1L1B11*J111+L1L1L1B11*J1111;
      YT:=YT+L0L1B11*J011+L1L0B11*J101+L1L1A11*J110;

     END;{ WHILE }

   { Summation of the absolute errors : }

    XT:=EXPLSOL(TI,WT); { exact value of the solution }
    EPSYLON[J]:=EPSYLON[J]+ABSERR(XT,YT);

   UNTIL K=N;{ REPEAT for different samples }
   EPSYLON[J]:=EPSYLON[J]/N; { estimate of the absolute error of the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G+3*NUM]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,EPSYLON,AVERAGE,VARIANCE);
  EPS[G+3*NUM]:=AVERAGE;           { midpoint of the confidence interval }
  DIFFER[G+3*NUM]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  INVEPS[G+3*NUM]:=1./AVERAGE; { inverted error EPS }
  TIMEINSEC(TIME,RTIME);
  TIMER[G+3*NUM]:=RTIME; { elapsed time for the step size }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

 HOUR:=THOUR;MINUTE:=TMINUTE;SECOND:=TSECOND;SEC100:=TSEC100;
 TIMEINSEC(TIME,RTIME); { gets the total computational time elapsed }
 CR:='<4>  Taylor 2.0 in '+TIME+' seconds';
 ECHO(4,CR); { delivers an echo signal to the screen scheme ... done }
 STATUSLINE('Ready. Press any key except <ESC> !');
 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the error graphs in the logarithmic graphic table : }

 CLEARDEVICE;
 GRAPH441(4,NUM,EPS,DEL,'log2(EPS)','log2(DELTA)');
 CR:='Linearly interpolated (log2(EPS),log2(DELTA)) - graph at t=';
 CR:=CR+CHCR(T)+' <Strong Taylor>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the logarithmic graphic table for the efficiency comparison : }

 CLEARDEVICE;
 GRAPH441(4,NUM,TIMER,INVEPS,'log2(TIME)','-log2(EPS)');
 CR:='Linearly interpolated (-log2(EPS),log2(TIME)) - graph at t=';
 CR:=CR+CHCR(T)+' <Strong Taylor>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the time consumption in the logarithmic graphic table : }

 CLEARDEVICE;
 GRAPH441(4,NUM,TIMER,DEL,'log2(TIME)','log2(DELTA)');
 CR:='Linearly interpolated (log2(TIME),log2(DELTA)) - graph at t=';
 CR:=CR+CHCR(T)+' <Strong Taylor>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ EXX4X4X4 }

{ If desired
    choose the corresponding confidence intervals by EPS, DIFFER and DEL
   and add the following :

  Printout of the confidence intervals :

 CLEARDEVICE;
 CONFINV(NUM,EPS,DIFFER,DEL,'EPS','DELTA');
 CR:='90% Confidence intervals for the absolute error EPS(t=';
 CR:=CR+CHCR(T)+')'+'  <2.0 Taylor>';
 STATUSLINE(CR);
}