{ Confidence intervals for the errors E ( g(Y(T) - g(X(T)) ) for the expli- }
{ cit order 3.0 weak approximations for scalar multiplicative noise in the  }
{ autonomous case at the time T w.r.t. a given function g(.), also plotting }
{ the (log2,log2) - graph for the absolute values of these errors           }
{ Considers the autonomous stochastic differential equation                 }
{   dX(t) = ALPHA * X(t) dt + BETA * X(t) dW(t)      with X(T0) = X0        }
{  on the time interval [T0,T] where W(t) is a Wiener process               }
{ Equidistant approximation of X(t) with different time step sizes DELTA    }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Estimation of the 90% confidence intervals for the mean errors at the     }
{ time T using M batches(M=20) with the sample size N                       }
{ Plots the confidence intervals for different time step sizes              }
{ Plots the log2 of the absolute errors against the log2 of the step sizes  }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch numbers remember that the corresponding per- }
{        centage points should also be changed.                             }

PROGRAM EXX5X2X1; { PC-Exercise 15.2.2 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 NUM=4;{6}       { number of different time step sizes               }
 T0=0.0;         { initial time                                      }
 T=1.0;          { final time                                        }
 DELTA=(T-T0)/4; { largest time step size of the weak approximations }
 X0=0.1;         { initial value                                     }
 ALPHA=1.5;      { parameter in the drift function A(x)              }
 BETA=0.01;      { parameter in the diffusion function B(x)          }
 M=200;          { number of batches                                 }
 N=1000;         { batch size                                        }
 QUANTILE=1.65;  { percentage point of the t-distribution            }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;             { help string                                      }
 G:INTEGER;             { index of the current time step size              }
 I:INTEGER;             { time step index                                  }
 J:INTEGER;             { batch index                                      }
 K:INTEGER;             { sample index within the current batch            }
 TI:REAL;               { subinterval point                                }
 DELTA_Y:REAL;          { time step size of the weak approximation         }
 SQDELTA_Y:REAL;        { square root of the time step size DELTA_Y        }
 KAPPA,KAPPA0,KAPPA1,KAPPA2:REAL; { scheme constants                       }
 KAPPA3,KAPPA4,KAPPA5,KAPPA6:REAL; { scheme constants                      }
 H1,H2,H3,H4,H5:REAL;   { help values                                      }
 GSI,RO:REAL;           { independent two-point distributed random numbers }
 G1,G2:REAL;            { independent Gaussian distributed random numbers  }
 DWTI:REAL;             { Wiener process increment  W(t(i+1)) - W(ti)      }
 DELZ:REAL;             { multiple Ito integral I10                        }
 EGXT:REAL;             { value of  E g(X(t)) at t = T                     }
 YT:REAL;               { value of the weak approximation using DELTA_Y    }
 AVERAGE,VARIANCE:REAL; { statistical parameters                           }
 MUYLON:VECTOR0;        { sum of the mean errors within a batch            }
 DEL:VECTOR1;           { time step sizes                                  }
 DIFFER:VECTOR1;        { half of the confidence interval lengths          }
 MU:VECTOR1;            { mean errors for different time step sizes        }

{ Generates the exact mean value of the function g(X(t)) }

FUNCTION MEANGXT(TI:REAL):REAL;
BEGIN
 MEANGXT:=X0*EXP(ALPHA*(TI-T0)); { first moment of g(X(t)) }
END;{ MEANGXT }

{ Generates the functional form of g(.) }

FUNCTION GXT(X:REAL):REAL;
BEGIN
 GXT:=X; { compares the first moments }
END;{ GXT }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Exercise 5.2.1 (PC-Exercise 15.2.2)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Estimation of the confidence intervals for the mean errors MU }
{ for different time step sizes :                               }

 KAPPA:=SQRT(3.0); { scheme constant      }
 EGXT:=MEANGXT(T); { calculates E g(X(T)) }
 DELTA_Y:=2.*DELTA;
 G:=0;
 REPEAT
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }
  KAPPA0:=ALPHA*DELTA_Y;    { scheme constants                 }
  KAPPA1:=ALPHA*BETA;KAPPA2:=1.0+KAPPA0;KAPPA6:=KAPPA0*KAPPA0;
  KAPPA3:=KAPPA2+4.*KAPPA6;KAPPA5:=BETA*SQDELTA_Y;KAPPA4:=KAPPA0*KAPPA5;
  KAPPA0:=KAPPA2+0.5*KAPPA6;

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;         { batch index                         }
   MUYLON[J]:=0.0; { sum of the errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1; { index of the trajectory used }

   { Generation of the weak approximation and its mean error MU : }

    I:=0;
    TI:=T0; { initial time                       }
    YT:=X0; { initial value of the approximation }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }
      GENER01(0.5,+1,-1,GSI); { two-point distributed random number GSI   }
      GENER01(0.5,+1,-1,RO);  { two-point distributed random number RO    }
      GENERATE(G1,G2);    { generation of Gaussian i.i.d. random numbers  }
      DWTI:=G1*SQDELTA_Y; { Wiener process increment W(t(i+1))-W(ti)      }
      DELZ:=0.5*SQDELTA_Y*DELTA_Y*(G1+G2/KAPPA); { multiple integral I10  }

     { Autonomous explicit order 3.0 weak scheme for multiplicative noise : }

      H1:=ALPHA*(KAPPA6+KAPPA4*(GSI+RO)+KAPPA5*KAPPA5*GSI*RO)/6.;
      H1:=H1*(DELTA_Y+(GSI+RO)*SQDELTA_Y*DWTI+GSI*RO*(DWTI*DWTI-DELTA_Y));
      H2:=BETA*DWTI*(KAPPA3+2.*KAPPA4*(GSI+RO)+KAPPA5*GSI)/24.;
      H3:=BETA*GSI*(DWTI*DWTI-DELTA_Y)*(KAPPA2+(4.*KAPPA4+KAPPA5)*GSI);
      H3:=H3/(24.*SQDELTA_Y);H4:=BETA*DWTI*(DWTI*DWTI-3.0)*GSI*RO;
      H4:=H4*((4.*KAPPA5*RO-1.0)*KAPPA5*GSI-KAPPA2)/(24.*DELTA_Y);
      H5:=-BETA*SQDELTA_Y*(DWTI*DWTI-DELTA_Y)*(KAPPA2+KAPPA5*GSI)/24.;
      YT:=YT*(KAPPA0+BETA*DWTI+KAPPA1*(1.0+GSI*GSI)*DELZ
              +SQR(BETA*GSI)*(DWTI*DWTI-DELTA_Y)+H1+H2+H3+H4+H5);

     END;{ WHILE }

   { Summation of the functional values g(Y(T)) : }

    MUYLON[J]:=MUYLON[J]+GXT(YT);

   UNTIL K=N;{ REPEAT for different samples }
   MUYLON[J]:=MUYLON[J]/N-EGXT; { estimate of the mean error for the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,MUYLON,AVERAGE,VARIANCE);
  MU[G]:=AVERAGE;            { midpoint of the confidence interval }
  DIFFER[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

{ Printout of the results : }

 CLEARDEVICE;
 CONFINV(NUM,MU,DIFFER,DEL,'MU','DELTA');
 CR:='90% Confidence intervals for the mean error MU(Expl. order 3.0 weak';
 CR:=CR+',t='+CHCR(T)+')';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the graph of the logarithms : }

 CLEARDEVICE;
 FOR G:=1 TO NUM DO MU[G]:=ABS(MU[G]); { plotting requires positive data }
 GRAPH313(NUM,MU,DEL,'log2(ABS(MU))','log2(DELTA)','');
 CR:='Linearly interpolated (log2(ABS(MU)),log2(DELTA))-graph at t=';
 CR:=CR+CHCR(T)+' <Expl 3.0 weak>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ EXX5X2X4 }