{ Confidence intervals for the errors E ( g(Y(T) - g(X(T)) ) for the deri-  }
{ vative-free implicit order 2.0 weak approximations due to Platen (with    }
{ fixed implicitness ALPHA=0.5) at the time T w.r.t. a given function g(.), }
{ also plotting of the (log2,log2) - graph for the absolute values          }
{ Considers the two-dimensional stochastic differential equation            }
{     dX1(t) = A * ( X2(t) - X1(t) ) dt + B * X1(t) dW(t)  , X1(T0)=X10     }
{     dX2(t) = A * ( X1(t) - X2(t) ) dt + B * X2(t) dW(t)  , X2(T0)=X20     }
{ on the time interval [T0,T] where W(t) is a Wiener process                }
{ Equidistant approximation of X(t) with different time step sizes DELTA    }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers       }
{ Componentwise estimation of the 90% confidence intervals for the mean er- }
{ rors at the time T using M batches(M=20) with the sample size N           }
{ Plots the confidence intervals for different time step sizes              }
{ Plots the log2 of the absolute errors against the log2 of the step sizes  }
{ Written by Henri Schurz, 9.10. 1991                                       }
{ Note : If changing the batch numbers remember that the corresponding per- }
{        centage points should also be changed.                             }
{ For the given linear equation the predictor-corrector schemes of Problem  }
{ 5.3.2 and Exercise 5.3.2 are identical each another!                      }

PROGRAM EXX5X3X2; { PC-Exercise 15.4.7 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 NUM=4;           { number of different time step sizes               }
 T0=0.0;          { initial time                                      }
 T=1.0;           { final time                                        }
 DELTA=(T-T0)/32; { largest time step size of the weak approximations }
 X10=1.0;         { initial value of the first component              }
 X20=0.0;         { initial value of the second component             }
 A=5.0;           { parameter in the drift matrix A(t,x)              }
 B=0.000001;      { parameter in the diffusion matrix B(t,x)          }
 M=20;            { number of batches                                 }
 N=100;           { batch size                                        }
 QUANTILE=1.73;   { percentage point of the t-distribution            }

TYPE
 VECTOR0=ARRAY[1..M] OF REAL;

VAR
 CR:STRING;             { help string                                       }
 G:INTEGER;             { index of the current time step size               }
 I:INTEGER;             { time step index                                   }
 J:INTEGER;             { batch index                                       }
 K:INTEGER;             { sample index within the current batch             }
 TI:REAL;               { subinterval point                                 }
 DELTA_Y:REAL;          { time step size of the weak approximation          }
 SQDELTA_Y:REAL;        { square root of the time step size DELTA_Y         }
 HH,HI,HII:REAL;        { help values supporting scheme evaluation          }
 KAPPA,KAPPA0,KAPPA1:REAL; { global constants                               }
 U:REAL;                { three-point distributed random number             }
 DWTI:REAL;             { three-point distributed increment W(t(i+1))-W(ti) }
 DELZ:REAL;             { random increment corresponding to mult. int. I10  }
 I11:REAL;              { random increment corresponding to mult. int. I11  }
 EGX1T:REAL;            { value of  E g(X1(t)) at t = T                     }
 EGX2T:REAL;            { value of  E g(X2(t)) at t = T                     }
 Y1T:REAL;        { first component of the weak approximation using DELTA_Y }
 Y2T:REAL;       { second component of the weak approximation using DELTA_Y }
 AVERAGE,VARIANCE:REAL; { statistical parameters                            }
 MU1YLON:VECTOR0;       { sum of the mean errors within a batch             }
 MU2YLON:VECTOR0;       { sum of the mean errors within a batch             }
 DEL:VECTOR1;           { time step sizes                                   }
 DIFFER1:VECTOR1;       { half of the confidence interval lengths           }
 DIFFER2:VECTOR1;       { half of the confidence interval lengths           }
 MU1:VECTOR1;           { mean errors MU1 for different time step sizes     }
 MU2:VECTOR1;           { mean errors MU2 for different time step sizes     }
 MU:VECTOR1;       { vector norm of (MU1,MU2) for different time step sizes }

{ Generates the exact mean value of the function g(X1(t)) }

FUNCTION MEANGX1T(TI:REAL):REAL;
VAR
 FACTOR:REAL;
BEGIN
 FACTOR:=EXP(-2.*A*TI);
 MEANGX1T:=0.5*(X10*(1.+FACTOR)+X20*(1.-FACTOR)); { first moment of g(X1(t)) }
END;{ MEANGX1T }

{ Generates the exact mean value of the function g(X2(t)) }

FUNCTION MEANGX2T(TI:REAL):REAL;
VAR
 FACTOR:REAL;
BEGIN
 FACTOR:=EXP(-2.*A*TI);
 MEANGX2T:=0.5*(X10*(1.-FACTOR)+X20*(1.+FACTOR)); { first moment of g(X2(t)) }
END;{ MEANGX2T }

{ Generates the functional form of g(.) }

FUNCTION GXT(X:REAL):REAL;
BEGIN
 GXT:=X; { compares the first moments }
END;{ GXT }

{ Generates the functional form of the norm used }

FUNCTION NORM(X1,X2:REAL):REAL;
BEGIN
 NORM:=SQRT(X1*X1+X2*X2); { Euclidean norm }
END;{ NORM }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR0;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 CR:='Exercise 5.3.2 (PC-Exercise 15.4.7)';MAINWINDOW(CR);
 STATUSLINE('Be patient! This will take the computer some time!');

{ Estimation of the confidence intervals for the mean errors MU1 and MU2 }
{ for different time step sizes :                                        }

 EGX1T:=MEANGX1T(T); { calculates E g(X1(T)) }
 EGX2T:=MEANGX2T(T); { calculates E g(X2(T)) }
 DELTA_Y:=2.*DELTA;
 G:=0;
 REPEAT
  G:=G+1;                   { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;       { current time step size           }
  SQDELTA_Y:=SQRT(DELTA_Y); { square root of DELTA_Y           }
  KAPPA:=A*DELTA_Y;KAPPA0:=1.-KAPPA; { global constants        }
  KAPPA1:=1.+KAPPA;KAPPA:=0.5*KAPPA;

 { Generation for different batches : }

  J:=0;
  REPEAT
   J:=J+1;          { batch index                         }
   MU1YLON[J]:=0.0; { sum of the errors of the batch used }
   MU2YLON[J]:=0.0; { sum of the errors of the batch used }

  { Generation of different trajectories : }

   K:=0;
   REPEAT
    K:=K+1; { index of the trajectory used }

   { Generation of the weak approximation and its mean errors MU1 and MU2 : }

    I:=0;
    TI:=T0; { initial time }
    Y1T:=X10; { initial value of the first component of the approximation  }
    Y2T:=X20; { initial value of the second component of the approximation }
    HII:=X20-X10; { help value }
    WHILE TI<T DO
     BEGIN
      I:=I+1;         { time step index }
      TI:=TI+DELTA_Y; { current time    }

     { Generation of the simplified random increments W(.)(t(i+1)) - W(.)(ti) }

      U:=RANDOM; { generation of the three-point distributed U }
      IF U>1./3. THEN U:=0.0 ELSE
       IF U>1./6. THEN U:=-1.0 ELSE U:=+1.0;
      DWTI:=U*SQDELTA_Y*SQRT(3.0);{ simplified increment  W(t(i+1)) - W(ti) }
      DELZ:=0.5*DELTA_Y*DWTI; { corresponds to the multiple integral I10    }
      I11:=0.5*(DWTI*DWTI-DELTA_Y); { corresponds to multiple integral I11  }

     { Derivative-free drift-implicit order 2.0 weak scheme : }

      HH:=B*DWTI+B*B*I11;HI:=HII;
      HII:=(KAPPA0+HH-B*A*DELTA_Y*DWTI)*HI/KAPPA1;HH:=1.+HH;
      Y1T:=HH*Y1T+B*KAPPA*DWTI*HI+KAPPA*(HI+HII);
      Y2T:=HH*Y2T-B*KAPPA*DWTI*HI-KAPPA*(HI+HII);

     END;{ WHILE }

   { Summation of the functional values g(Y(T)) : }

    MU1YLON[J]:=MU1YLON[J]+GXT(Y1T);
    MU2YLON[J]:=MU2YLON[J]+GXT(Y2T);

   UNTIL K=N;{ REPEAT for different samples }
   MU1YLON[J]:=MU1YLON[J]/N-EGX1T; { estimate of the mean error for the batch }
   MU2YLON[J]:=MU2YLON[J]/N-EGX2T; { estimate of the mean error for the batch }
  UNTIL J=M;{ REPEAT for different batches }

{ Calculation of the confidence interval and initialization of data : }

  DEL[G]:=DELTA_Y; { current time step size }
  COMPSAMPLEPARA(M,MU1YLON,AVERAGE,VARIANCE);
  MU1[G]:=AVERAGE;            { midpoint of the confidence interval }
  DIFFER1[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }
  COMPSAMPLEPARA(M,MU2YLON,AVERAGE,VARIANCE);
  MU2[G]:=AVERAGE;            { midpoint of the confidence interval }
  DIFFER2[G]:=QUANTILE*SQRT(VARIANCE/M); { half the interval length }

 UNTIL G=NUM;{ REPEAT for different time step sizes }

{ Printout of the results : }

 CLEARDEVICE;
 CONFINV(NUM,MU1,DIFFER1,DEL,'MU1','DELTA'); { confidence intervals for MU1 }
 CR:='90% Confidence intervals for the mean error MU1(Implicit 2.0 weak,t=';
 CR:=CR+CHCR(T)+')';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 CLEARDEVICE;
 CONFINV(NUM,MU2,DIFFER2,DEL,'MU2','DELTA'); { confidence intervals for MU2 }
 CR:='90% Confidence intervals for the mean error MU2(Implicit 2.0 weak,t=';
 CR:=CR+CHCR(T)+')';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

{ Printout of the graph of the logarithms of the vector norm of (MU1,MU2) : }

 CLEARDEVICE;
 FOR G:=1 TO NUM DO MU[G]:=NORM(MU1[G],MU2[G]); { norm of the estimates }
 GRAPH313(NUM,MU,DEL,'log2(ABS(MU))','log2(DELTA)','');
 CR:='Linearly interpolated (log2(ABS(MU)),log2(DELTA)) - graph at t=';
 CR:=CR+CHCR(T)+'<Impl.w.2.0>';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ EXX5X3X2 }