{ Illustrates the local roundoff error                                      }
{ Plots the histogram of the relative frequencies divided by subinterval    }
{ length for the local roundoff errors arising in a given iteration scheme  }
{ Rounding off to S significant digits                                      }
{ Written by Henri Schurz, 9.10.1991                                        }
{ Note : Be careful if changing N because of the range of ROUNDed data per- }
{        mitted in TURBO-PASCAL-version used(must be of LONGINT-type).      }
{        For a correct printout of the histogram one has to choose the      }
{        scaling parameter carefully. Peaks in the histogram may occur de-  }
{        depending on the scheme generated, but are generally smaller than  }
{        1/INVLENGTH. Values outside the given interval are not counted.    }
{        Please change the truncation parameter ACCUR of the procedure CHCR }
{        in the unit SERVICE to convert absolute values smaller than 10E-6  }
{        (ACCUR=10). Otherwise these values are displayed with '0'.         }

PROGRAM PR3X1X10; { PC-Exercise 8.4.1 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE;

CONST
 N=300;                          { number of iterations              }
 S=4;                            { number of the significant figures }
 Y0=0.1;                         { initial value for the iteration   }
 ABSCMIN=-0.00005;               { left end point                    }
 ABSCMAX=+0.00005;               { right end point                   }
 INVLENGTH=(ABSCMAX-ABSCMIN)/40; { length of subinterval             }
 ORDMIN=0.0;                     { minimum of the ordinate           }
 ORDMAX=1/(10*INVLENGTH);        { maximum of the ordinate           }
 ORDPOINT=ORDMAX/4;              { significant ordinate point        }

TYPE
 VECTOR=ARRAY[1..N] OF REAL;

VAR
 CR:STRING;             { help string                        }
 I:INTEGER;             { counter                            }
 AXISX,AXISY:INTEGER;   { location of the axes               }
 DISTX,DISTY:INTEGER;   { scale parameters                   }
 Q0:REAL;               { constant 10^S for the rounding off }
 YI:REAL;               { current iteration value            }
 AVERAGE,VARIANCE:REAL; { statistical parameters             }
 LROE:VECTOR;           { local roundoff errors              }

{ Generates the functional form of the iteration scheme }

FUNCTION ITSTEP(YI:REAL):REAL;
BEGIN
 ITSTEP:=PI*YI/3;
END;{ ITSTEP }

{ Prepares the screen for the printout of the histogram required }

PROCEDURE COORDSYS;
VAR
 FACTOR,I0,I1,I2,IH,K:INTEGER;
 DX,DY:REAL;
BEGIN
 IH:=TEXTHEIGHT('M')+5;
 AXISX:=TRUNC(13*MAXY/16);
 I0:=TEXTWIDTH(CHCR(ORDMAX))+7;I1:=TEXTWIDTH(CHCR(ORDMIN))+7;
 I2:=TEXTWIDTH(CHCR(ORDPOINT))+7;IF I0<I1 THEN I0:=I1;
 IF I0<I2 THEN I0:=I2;I1:=TRUNC(MAXX/10);
 IF I0>MAXX-NUMINV-40 THEN I0:=MAXX-NUMINV-40;
 IF I0<I1 THEN AXISY:=I1 ELSE AXISY:=I0;
 DISTX:=NUMINV;DISTY:=AXISX-3*IH-5;
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY,IH+5,'^');OUTTEXTXY(AXISY,IH-5,'f(x)');
 LINE(AXISY,IH+5,AXISY,AXISX+5);LINE(AXISY-5,AXISX,AXISY+30+DISTX,AXISX);
 SETTEXTJUSTIFY(2,1);I0:=AXISX-10-DISTY;
 LINE(AXISY-3,I0,AXISY+3,I0);OUTTEXTXY(AXISY-7,I0,CHCR(ORDMAX));
 DY:=(ORDPOINT-ORDMIN)/(ORDMAX-ORDMIN);I0:=AXISX-10-TRUNC(DY*DISTY);
 LINE(AXISY-3,I0,AXISY+3,I0);OUTTEXTXY(AXISY-7,I0,CHCR(ORDPOINT));
 LINE(AXISY-3,AXISX-10,AXISY+3,AXISX-10);
 OUTTEXTXY(AXISY-7,AXISX-10,CHCR(ORDMIN));SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY+30+DISTX,AXISX+1,'>');OUTTEXTXY(AXISY+30+DISTX,AXISX+2*IH,'x');
 IF ((ABSCMAX-ABSCMIN=2.0) OR (ABSCMAX+ABSCMIN=0.0)) THEN FACTOR:=2 ELSE
  IF ABSCMAX-ABSCMIN=3.0 THEN FACTOR:=3 ELSE
   IF ABSCMAX-ABSCMIN=4.0 THEN FACTOR:=4 ELSE
    IF ((ABSCMAX-ABSCMIN=5.0) OR ((ABSCMAX-ABSCMIN=1.0) AND (ABSCMIN=0.0)))
     THEN FACTOR:=5 ELSE FACTOR:=1;
 DX:=(ABSCMAX-ABSCMIN)/FACTOR;
 FOR K:=0 TO FACTOR DO
  BEGIN
   I1:=AXISY+10+TRUNC(K*DISTX/FACTOR+0.5);I2:=AXISX+IH;
   LINE(I1,AXISX+3,I1,AXISX-3);
   OUTTEXTXY(I1,I2,CHCR(ABSCMIN+K*DX));
  END;
END;{ COORDSYS }

{ Realizes the quick-sort-algorithm for a vector }

PROCEDURE QSORT(DOWN,UP:INTEGER;VAR F:VECTOR);
VAR I,J:INTEGER;
    TMP,MIDDLE:REAL;
BEGIN
 I:=DOWN;J:=UP;MIDDLE:=F[TRUNC((DOWN+UP)/2)];
 REPEAT
  WHILE ((I<UP) AND (F[I]<MIDDLE)) DO I:=I+1;
  WHILE ((J>DOWN) AND (F[J]>MIDDLE)) DO J:=J-1;
  IF I<=J THEN
   BEGIN
    TMP:=F[I];F[I]:=F[J];F[J]:=TMP;I:=I+1;J:=J-1
   END;
 UNTIL I>J;
 IF DOWN<J THEN QSORT(DOWN,J,F);
 IF I<UP THEN QSORT(I,UP,F);
END;{ QSORT }

{ Provides the histogram of the relative frequencies }
{ Assumes COORDSYS has been called before            }
{ Aborts if data out of range                        }

PROCEDURE HISTOGRAM(NN:INTEGER;F:VECTOR); { assumes a sorted vector F }
VAR
 CR:STRING;
 ENDS:BOOLEAN;
 I,IH,IL,IR,K,KLOWER,KUPPER:INTEGER;
 FACTORX,FACTORY:REAL; { scaling factors         }
 INVEND:REAL;          { current subinterval end }
BEGIN
 FACTORX:=DISTX/(ABSCMAX-ABSCMIN);
 FACTORY:=DISTY/(ORDMAX-ORDMIN);
 INVEND:=ABSCMIN;

{ Control over data used and the printout of the histogram : }

 ENDS:=FALSE; { permitted data }
 KLOWER:=0;KUPPER:=NN+1;
 I:=NN+1;
 IF F[NN]<ABSCMIN THEN ENDS:=TRUE ELSE
  IF F[1]>ABSCMAX THEN ENDS:=TRUE ELSE
   BEGIN
    WHILE ((I>2) AND (F[I-1]>ABSCMAX)) DO I:=I-1;
    IF I>1 THEN KUPPER:=I-1
     ELSE ENDS:=TRUE; { out of range }
    I:=0;
    WHILE ((I<NN-1) AND (F[I+1]<ABSCMIN)) DO I:=I+1;
    IF I<NN THEN KLOWER:=I
     ELSE ENDS:=TRUE; { out of range }
   END;
 IF ENDS=FALSE THEN
   BEGIN
    I:=KLOWER;
    REPEAT
     INVEND:=INVEND+INVLENGTH;I:=I+1;K:=0;
     WHILE ((I+K<NN) AND (F[I+K]<=INVEND)) DO K:=K+1;
     IF ((I+K=NN) AND (F[I+K]<=INVEND)) THEN K:=K+1;
     IF K>0 THEN
       BEGIN
        I:=I+K-1;
        IL:=AXISY+10+TRUNC((INVEND-INVLENGTH-ABSCMIN)*FACTORX);
        IR:=AXISY+10+TRUNC((INVEND-ABSCMIN)*FACTORX);
        IH:=AXISX-10-TRUNC((((K/NN)/INVLENGTH)-ORDMIN)*FACTORY);
        LINE(IL,AXISX-10,IL,IH);LINE(IL,IH,IR,IH);LINE(IR,IH,IR,AXISX-10);
        LINE(IL,AXISX-10,IR,AXISX-10);
       END
      ELSE I:=I-1;
    UNTIL ((INVEND>=ABSCMAX) OR (I>=KUPPER));
   END
  ELSE { terminates the program because of nonallowable data configuration }
   BEGIN
    CR:='Please, use another interval!';
    OUTTEXTXY(TRUNC(MAXX/2),TRUNC(MAXY/2),CR);
    CR:='Data out of range! Press <ESC> and check data';
    STATUSLINE(CR);
    WAITTOGO;
   END;
END;{ HISTOGRAM }

{ Computes the sample average and variance of a given data vector X }
{ with the sample size NN                                           }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Prints out the sample parameters on the screen }

PROCEDURE STATDATATOSCR(AVERAGE,VARIANCE:REAL);
VAR
 CR:STRING;
 IH,IL:INTEGER;
BEGIN
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 IH:=TRUNC(MAXX/2);IL:=TEXTHEIGHT('M');
 CR:=CHCR(AVERAGE);CR:='sample average  = '+CR;OUTTEXTXY(IH,IL+2,CR);
 CR:=CHCR(SQRT(VARIANCE));CR:='standard deviation = '+CR;
 OUTTEXTXY(IH,2+3*IL,CR);
END;{ STATDATATOSCR }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Problem 3.1.10 (PC-Exercise 8.4.1)');
 STATUSLINE('Be patient! This will take the computer some time.');

{ Generation of the roundoff errors locally arising in the given scheme }
{ Calculation of the sample average and variance :                      }

 Q0:=EXP(S*LN(10)); { roundoff constant    }
 YI:=Y0;  { initial value for the iteration }
 FOR I:=1 TO N DO
  BEGIN
   YI:=ITSTEP(YI);              { iteration step       }
   LROE[I]:=YI-ROUND(YI*Q0)/Q0; { local roundoff error }
  END;
 COMPSAMPLEPARA(N,LROE,AVERAGE,VARIANCE); { computes the sample parameters }

{ Printout : }

 QSORT(1,N,LROE); { sorts the vector LROE }
 CLEARDEVICE;
 COORDSYS;  { draws the coordinate system }
 HISTOGRAM(N,LROE); { plots the histogram }
 STATDATATOSCR(AVERAGE,VARIANCE);
 CR:='Relative frequency histogram of the local roundoff errors';
 STATUSLINE(CR);

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PR3X1X10 }