{ Confidence intervals for the mean value of the accumulative roundoff   }
{ error generated by the Euler scheme                                    }
{ Rounding off to S significant digits                                   }
{ Considers the deterministic ordinary differential equation             }
{  dX(t) = A(t,X(t)) dt   with  X(T0) = X0   on the time interval [T0,T] }
{ Equidistant Euler approximation of X(t) with the time step size DELTA  }
{ Plots the 90% confidence intervals for the mean values against DELTA   }
{ Written by Henri Schurz, 9.10.1991                                     }

PROGRAM PR3X1X12; { PC-Exercise 8.4.3 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,AAGRAPHS;

CONST
 NUM=4;          { number of different time step sizes used          }
 T0=0.0;         { left end point                                    }
 T=1.0;          { right end point                                   }
 DELTA=(T-T0)/4; { largest time step size of the Euler approximation }
 S=4;            { number of significant figures                     }
 N=200;          { number of initial values X0 : X1 < X0 < X2        }
 X1=0.4;         { left border for the initial values                }
 X2=0.6;         { right border for the initial values               }
 ALPHA=1.0;      { parameter of the function A(t,x)                  }
 QUANTILE=1.65;  { percentage point of the t-distribution            }

VAR
 CR:STRING;             { help string                                     }
 I:INTEGER;             { time step                                       }
 K:INTEGER;             { index of the initial value used                 }
 L:INTEGER;             { index of the time step size used                }
 TI:REAL;               { subinterval point                               }
 DELTA_Y:REAL;          { current time step size                          }
 X0:REAL;               { current initial value of the approximation      }
 YT:REAL;               { values of the Euler approximation using DELTA_Y }
 YTWR:REAL;             { values of the Euler approximation with roundoff }
 Q0:REAL;               { constant 10^S for the rounding off              }
 AVERAGE,VARIANCE:REAL; { statistical parameters                          }
 AROE:VECTOR;           { accumulative roundoff errors                    }
 ABSCISSA:VECTOR1;      { time step sizes                                 }
 DIFFER:VECTOR1;        { half of the confidence interval length          }
 MEANVAL:VECTOR1;       { mean values estimated                           }

{ Generates the function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=ALPHA*XI;
END;{ A }

{ Computes the sample average and variance of a given data vector X }
{ with the sample size NN                                           }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 3.1.12 (PC-Exercise 8.4.3)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Generation of the roundoff errors locally arising in the Euler scheme }
{ Calculation of the sample average and variance :                      }

 Q0:=EXP(S*LN(10)); { roundoff constant }

{ Generation of the accumulative roundoff errors for different step sizes : }

 DELTA_Y:=2.*DELTA;
 L:=0;
 REPEAT
  L:=L+1; { index of the time step size used }
  DELTA_Y:=DELTA_Y/2;

 { Generation of the Euler approximation for different initial values }
 { Summation of the local roundoff errors :                           }

  K:=0;
  REPEAT
   K:=K+1;                   { index of the initial value used      }
   X0:=X1+(K/(N+1))*(X2-X1); { current initial value                }
   YT:=X0;YTWR:=X0;          { initialization of the approximations }
   AROE[K]:=0.0;             { initial accumulative error           }
   TI:=T0;
   I:=0;
   WHILE TI<T DO
    BEGIN
     I:=I+1;                          { time step                         }
     TI:=TI+DELTA_Y;                  { time                              }
     YT:=YT+A(TI-DELTA_Y,YT)*DELTA_Y; { Euler scheme without rounding off }
     AROE[K]:=AROE[K]+YT-ROUND(YT*Q0)/Q0; { accumulative roundoff error   }
    END;
  UNTIL K=N;
  COMPSAMPLEPARA(N,AROE,AVERAGE,VARIANCE); { computes the sample parameters }
  MEANVAL[L]:=AVERAGE;                  { mean value estimated        }
  DIFFER[L]:=QUANTILE*SQRT(VARIANCE/N); { half of the interval length }
  ABSCISSA[L]:=DELTA_Y;                 { value of the x-axis         }
 UNTIL L=NUM;

{ Printout : }

 CLEARDEVICE;
 CONFINV(NUM,MEANVAL,DIFFER,ABSCISSA,'Mean value','DELTA');
 CR:='90% confidence intervals of the mean value of the accumulative ';
 CR:=CR+'roundoff errors';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PR3X1X12 }