{ To provide the Gaussian density function in an interval [X1,X2] }
{ Written by Henri Schurz, 9.10. 1991                             }

PROGRAM PRX1X1X1;

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,AAGRAPHS;

CONST
 X1=-4.0;  { left end point  }
 X2=+4.0;  { right end point }

VAR
 CR:STRING;       { help string                                  }
 K:INTEGER;       { counter                                      }
 DELTA:REAL;      { step size                                    }
 X:REAL;          { actual interval point                        }
 ABSCISSA:VECTOR; { vector of the values of the interval points  }
 FX:VECTOR;       { vector of the values of the density function }

{ Generates one value of the standard Gaussian density function }

FUNCTION F(X:REAL):REAL;
BEGIN
 F:=EXP(-X*X/2)/SQRT(PI+PI);
END;{ F }

{ Main program : }

BEGIN

 INITIALIZE;  { standard initialization }
 MAINWINDOW(''); { sets a view port     }

{ Generation of data : }

 DELTA:=NUMINV;
 DELTA:=(X2-X1)/DELTA; { highest possible screen resolution }
 X:=X1-DELTA;
 K:=-1;
 REPEAT
  K:=K+1;
  X:=X+DELTA;
  ABSCISSA[K]:=X; { values of the X-axes }
  FX[K]:=F(X);    { values of the Y-axes }
 UNTIL K=NUMINV;

{ Plots the graph of the density function using AAGRAPHS routine }
{ ! Scaling of the x-axes is done in powers of 2                 }
{ ! Scaling of the y-axes corresponds to the extremas of data    }

 GRAPH111(FX,ABSCISSA,'f(x)','x','');

 CR:='The Gaussian density function f(x) = exp(-x*x/2)/sqrt(2*pi)';
 STATUSLINE(CR);  { draws the bottom line    }
 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X1X1 }