{ To provide independent two-point distributed pseudo-random numbers }
{ Written by Henri Schurz, 9.10. 1991                                }

PROGRAM PRX1X2X2;

USES CRT,DOS,GRAPH,INIT,SERVICE;

CONST
 N=10;    { number of random numbers to be generated }
 X1=1.0;  { first value of the random variable X     }
 X2=-1.0; { second value of the random variable X    }
 P1=0.5;  { probability that X = X1                  }

VAR
 CR,CS,CT,CU:STRING; { help strings                        }
 SIGN:STRING;        { char for positive integers          }
 K:INTEGER;          { counter                             }
 U:REAL;             { actual value of yhe random variable }

{ Generates a two-point distributed random number }

PROCEDURE GENER01(P,X1,X2:REAL;VAR XU:REAL);
BEGIN
 XU:=RANDOM;
 IF XU <= P THEN XU:=X1 ELSE XU:=X2;
END;{ GENER01 }

{ Main program : }

BEGIN

 INITIALIZE;CLEARDEVICE; { standard initialization not necessary here }
 RESTORECRTMODE;         { restores the CRT mode                      }

 CLRSCR;
 CR:='Two-point distributed random numbers';
 CS:=CHCR(X1);IF X1>0.0 THEN CS:='+'+CS;CS:='first value  : x1 = '+CS;
 CT:=CHCR(X2);IF X2>0.0 THEN CT:='+'+CT;CT:='second value : x2 = '+CT;
 CU:='probability p1 in [0,1] that X = x1 : p1 = '+CHCR(P1);
 WRITELN(CR);WRITELN(CS);WRITELN(CT);WRITELN(CU);
 K:=0;
 REPEAT
  K:=K+1;
  GENER01(P1,X1,X2,U);
  IF U>=0.0 THEN SIGN:='+' ELSE SIGN:='';
  WRITELN(K:4,'. value  U = ',SIGN+CHCR(U));
  IF ((K MOD 20 = 0) AND (K<N)) THEN
   BEGIN
    WAITE;CLRSCR;
    WRITELN(CR);WRITELN(CS);WRITELN(CT);WRITELN(CU);
   END;
 UNTIL K=N;
 WAITE; { waits for <ENTER> to be pressed }

 SETGRAPHMODE(GETGRAPHMODE); { returns to graphics mode }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X2X2 }