{ To provide independent exponentially distributed pseudo-random numbers }
{ Written by Henri Schurz, 9.10. 1991                                    }

PROGRAM PRX1X2X3;

USES CRT,DOS,GRAPH,INIT,SERVICE;

CONST
 N=10;       { number of random numbers to be generated  }
 LAMBDA=2.0; { parameter of the exponential distribution }

VAR
 CR,CS:STRING; { help strings                        }
 K:INTEGER;    { counter                             }
 U:REAL;       { actual value of the random variable }

{ Generates an exponentially distributed random number }
{ with parameter Lambda > 0.0                          }

PROCEDURE GENER02(LAMBDA:REAL;VAR XU:REAL);
BEGIN
 XU:=RANDOM;
 IF XU > 0. THEN XU:=-LN(XU)/LAMBDA ELSE XU:=0.;
END;{ GENER02 }

{ Main program : }

BEGIN

 INITIALIZE;CLEARDEVICE; { standard initialization not necessary here }
 RESTORECRTMODE;         { restores the CRT mode                      }

 CLRSCR;
 CR:='Exponentially distributed random numbers';
 CS:=' with parameter Lambda = '+CHCR(LAMBDA);
 WRITELN(CR);WRITELN(CS);
 K:=0;
 REPEAT
  K:=K+1;
  GENER02(LAMBDA,U);
  WRITELN(K:4,'. value  U = ',CHCR(U));
  IF ((K MOD 20 = 0) AND (K<N)) THEN
   BEGIN
    WAITE;CLRSCR;
    WRITELN(CR);WRITELN(CS);
   END;
 UNTIL K=N;
 WAITE; { waits for <ENTER> to be pressed }

 SETGRAPHMODE(GETGRAPHMODE); { returns to graphics mode }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X2X3 }