{ To provide independent Gaussian distributed pseudo-random numbers }
{ Written by Henri Schurz, 9.10. 1991                               }

PROGRAM PRX1X2X4;

USES CRT,DOS,GRAPH,INIT,SERVICE;

CONST
 N=10; { number of random pairs to be generated }

VAR
 CR,CS:STRING; { help strings                     }
 K:INTEGER;    { counter                          }
 U1,U2:REAL;   { actual values of the random pair }

{ Generates pairs of independent N(0,1) random numbers }
{ by the Box-Muller method                             }

PROCEDURE GENER03(VAR G1,G2:REAL);
VAR
 U1,U2:REAL;
BEGIN
 REPEAT U1:=RANDOM UNTIL U1>0.;U2:=RANDOM;
 U1:=LN(U1);U2:=PI*U2;
 U1:=SQRT(-U1-U1);U2:=U2+U2;
 G1:=U1*COS(U2);G2:=U1*SIN(U2);
END;{ GENER03 }

{ Main program : }

BEGIN

 INITIALIZE;CLEARDEVICE; { standard initialization not necessary here }
 RESTORECRTMODE;         { restores the CRT mode                      }

 CLRSCR;
 CR:='Gaussian distributed random numbers';
 CS:=' generated with Box-Muller method';
 WRITELN(CR);WRITELN(CS);
 K:=0;
 REPEAT
  K:=K+1;
  GENER03(U1,U2);
  WRITELN(K:4,'. pair : ',CHCR(U1):20,' | ',CHCR(U2):20);
  IF ((K MOD 20 = 0) AND (K<N)) THEN
   BEGIN
    WAITE;CLRSCR;
    WRITELN(CR);WRITELN(CS);
   END;
 UNTIL K=N;
 WAITE; { waits for <ENTER> to be pressed }

 SETGRAPHMODE(GETGRAPHMODE); { returns to graphics mode }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X2X4 }