{ To provide independent Gaussian distributed pseudo-random numbers }
{ Written by Henri Schurz, 9.10. 1991                               }

PROGRAM PRX1X2X5;

USES CRT,DOS,GRAPH,INIT,SERVICE;

CONST
 N=10; { number of random pairs to be generated }

VAR
 CR,CS:STRING; { help strings                     }
 K:INTEGER;    { counter                          }
 U1,U2:REAL;   { actual values of the random pair }

{ Generates pairs of independent N(0,1) random numbers }
{ by the Polar-Marsaglia method                        }

PROCEDURE GENERATE(VAR G1,G2:REAL);
VAR
 V1,V2,W,LW:REAL;
BEGIN
 REPEAT
  V1:=2.*RANDOM-1.;V2:=2.*RANDOM-1.;W:=V1*V1+V2*V2;
 UNTIL ((W<=1.0) AND (W>0.0)); { obviously LN(0) does not exist. }
 LW:=LN(W)/W;LW:=SQRT(-LW-LW);G1:=V1*LW;G2:=V2*LW;
END;{ GENERATE }

{ Main program : }

BEGIN

 INITIALIZE;CLEARDEVICE; { standard initialization not necessary here }
 RESTORECRTMODE;         { restores the CRT mode                      }

 CLRSCR;
 CR:='Gaussian distributed random numbers';
 CS:=' generated with Polar Marsaglia method';
 WRITELN(CR);WRITELN(CS);
 K:=0;
 REPEAT
  K:=K+1;
  GENERATE(U1,U2);
  WRITELN(K:4,'. pair : ',CHCR(U1):20,' | ',CHCR(U2):20);
  IF ((K MOD 20 = 0) AND (K<N)) THEN
   BEGIN
    WAITE;CLRSCR;
    WRITELN(CR);WRITELN(CS);
   END;
 UNTIL K=N;
 WAITE; { waits for <ENTER> to be pressed }

 SETGRAPHMODE(GETGRAPHMODE); { returns to graphics mode }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X2X5 }