{ To generate two-point, exponentially and Gaussian distributed random numbers }
{ Written by Henri Schurz, 9.10. 1991                                          }

PROGRAM PRX1X2X6; { PC-Exercise 1.3.1 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
 BORDER=1000; { maximal number of random numbers }

TYPE
 VECTOR=ARRAY[1..BORDER] OF REAL;

VAR
 CR,CH,CL,CV:STRING;
 QUESTION:CHAR;
 ENDS:BOOLEAN;
 I,K,N,N1,N2:INTEGER;
 LAMBDA,U0,P,X1,X2:REAL;
 U:VECTOR; { vector of random numbers }

{ Some control on the number of random numbers required }

PROCEDURE COUNTING(VAR N:INTEGER);
VAR CR:STRING;
BEGIN
 CR:='How many random numbers?  N =';WRITE(CR);
 REPEAT
  READLN(N);
  IF ((N<1) OR (N>BORDER)) THEN
   BEGIN
    WRITELN('Pardon ?');
    WAITE;CLRSCR;
   END;
 UNTIL ((N>=1) AND (N<=BORDER));
 CH:=CHCR(N);CH:=CR+CH;
END;{ COUNTING }

{ Control and output }

PROCEDURE GENER(I:INTEGER);
BEGIN
 CASE I OF
   1 : BEGIN
        GOTOXY(10,10);WRITE('first value : X[1] =');READLN(X1);
        GOTOXY(10,12);WRITE('second value : X[2] =');READLN(X2);
        GOTOXY(10,15);
        WRITE('probability p in [0,1] that X=X[1] : p =');READLN(P);
        CLRSCR;WRITELN('Two-point distributed random numbers');
        CR:=CHCR(P);CR:='with probability p ='+CR+' that X=x[1] :';
        WRITELN(CR);WRITELN(CH);
        K:=0;
        REPEAT
         K:=K+1;
         GENER01(P,X1,X2,U0);U[K]:=U0;
         WRITELN(K:4,'. value U=',CHCR(U0));
         IF ((K MOD 20 = 0) AND (K<N)) THEN
          BEGIN
           WAITE;CLRSCR;WRITELN('Two-point distributed random numbers');
           WRITELN(CR);WRITELN(CH);
          END
        UNTIL K=N;
        WAITE;
      END;
   2 : BEGIN
        WRITE('Lambda=');
        REPEAT
         READLN(CR);VAL(CR,LAMBDA,K)
        UNTIL ((LAMBDA>0) AND (LAMBDA<=BORDER) AND (K=0));
        CLRSCR;
        CR:=CHCR(LAMBDA);
        CR:='Exponent. distrib. random numbers with Lambda = '+CR;
        WRITELN(CR);
        K:=0;
        REPEAT
         K:=K+1;
         GENER02(LAMBDA,U0);
         U[K]:=U0;
         WRITELN(K:4,'. value U=',CHCR(U0));
         IF ((K MOD 20 =0) AND (K<N)) THEN
          BEGIN
           WAITE;CLRSCR;WRITELN(CR);WRITELN(CH);
          END;
        UNTIL K=N;
        WAITE;
       END;
   3 : BEGIN
        CLRSCR;
        CR:='N(0,1) Gaussian distributed random numbers';WRITELN(CR);
        CH:='Box-Muller method';WRITELN(CH);
        STR(N,CL);CL:='Number of random pairs N = '+CL;WRITELN(CL);
        K:=0;
        REPEAT
         K:=K+1;
         GENER03(U[2*K-1],U[2*K]);
         WRITELN(K:4,'. pair : ',CHCR(U[2*K-1]):20,' | ',CHCR(U[2*K]):20);
         IF ((K MOD 20 = 0) AND (K<N)) THEN
          BEGIN
           WAITE;CLRSCR;WRITELN(CR);WRITELN(CH);WRITELN(CL);
          END;
        UNTIL K=N;
        WAITE;
       END;
   4 : BEGIN
        CLRSCR;
        CR:='N(0,1) Gaussian distributed random numbers';WRITELN(CR);
        CH:='Polar Marsaglia method';WRITELN(CH);
        STR(N,CL);CL:='Number of random pairs N = '+CL;WRITELN(CL);
        K:=0;
        REPEAT
         K:=K+1;
         GENERATE(U[2*K-1],U[2*K]);
         WRITELN(K:4,'. pair : ',CHCR(U[2*K-1]):20,' | ',CHCR(U[2*K]):20);
         IF ((K MOD 20 = 0) AND (K<N)) THEN
          BEGIN
           WAITE;CLRSCR;WRITELN(CR);WRITELN(CH);WRITELN(CL);
          END;
        UNTIL K=N;
        WAITE;
       END
   END;{ CASE }
END;{ GENER }

{ Main program : }

BEGIN
 INITIALIZE;
 N1:=TRUNC(7*MAXX/16);
 N2:=TRUNC(7*MAXX/8);
 ENDS:=FALSE;
 REPEAT
  MAINWINDOW('Problem 1.2.6 (PC-Exercise 1.3.1)');
  OUTTEXTXY(N1,60,'To generate two-point distributed random variables');
  OUTTEXTXY(N2,60,'1');
  OUTTEXTXY(N1,80,'To generate exponentially distributed random variables');
  OUTTEXTXY(N2,80,'2');
  OUTTEXTXY(N1,100,'To generate Gaussian distributed random variables');
  OUTTEXTXY(N1,120,'with Box-Muller method');
  OUTTEXTXY(N2,120,'3');
  OUTTEXTXY(N1,140,'with Polar Marsaglia method');
  OUTTEXTXY(N2,140,'4');OUTTEXTXY(N1,160,'To end');
  OUTTEXTXY(N2,160,'E');
  STATUSLINE('Input one of {1,2,3,4,E} or else nothing will happen');
  REPEAT
   QUESTION:=UPCASE(READKEY);
  UNTIL QUESTION IN ['1','2','3','4','E'];
  CLEARDEVICE;RESTORECRTMODE;
  CASE QUESTION OF
   '1' : BEGIN
          CV:='To generate two-point distributed random variables';
          WRITELN(CV);
          COUNTING(N);GENER(1);
         END;
   '2' : BEGIN
          CV:='To generate exponentially distributed random variables';
          WRITELN(CV);
          COUNTING(N);GENER(2);
         END;
   '3' : BEGIN
          CV:='To generate Gaussian distributed random variables with Box-';
          CV:=CV+'Muller method';
          WRITELN(CV);
          COUNTING(N);GENER(3);
         END;
   '4' : BEGIN
          CV:='To generate Gaussian distributed random variables with Polar';
          CV:=CV+' Marsaglia method';
          WRITELN(CV);
          COUNTING(N);GENER(4);
         END;
   'E' : ENDS:=TRUE
   END;{ CASE }
  SETGRAPHMODE(GETGRAPHMODE) { returns to graphics mode }
 UNTIL ENDS;

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X2X6 }