{ To compare the computational time in seconds elapsed by the generation of }
{ independent Gaussian distributed pseudo-random numbers                    }
{ Uses Box-Muller and Polar Marsaglia method                                }
{ Requires the PC to have a built-in clock                                  }
{ Written by Henri Schurz, 9.10. 1991                                       }

PROGRAM PRX1X2X7;

USES CRT,DOS,GRAPH,INIT,SERVICE,SETSCR,RANDNUMB;

CONST
 N=5000; { number of random pairs to be generated }

VAR
 CR:STRING;   { help string                       }
 TIME:STRING; { time in seconds                   }
 K:LONGINT;   { counter                           }
 U1,U2:REAL;  { current values of the random pair }
 HOUR,MINUTE,SECOND,SEC100:WORD;

{ Takes the elapsed time in seconds for run times not exceeding one day }
{ Assumes GETTIME(HOUR,MINUTE,SECOND,SEC100) has been called before     }

PROCEDURE TIMEINSEC(VAR TIME:STRING);
VAR
 ABSSEC,ABSSEC100,OLDHOUR,OLDMINUTE,OLDSEC100,OLDSECOND:WORD;
 CR:STRING;
BEGIN
 OLDHOUR:=HOUR;OLDMINUTE:=MINUTE;OLDSECOND:=SECOND;OLDSEC100:=SEC100;
 GETTIME(HOUR,MINUTE,SECOND,SEC100);
 IF SEC100<OLDSEC100 THEN
   BEGIN OLDSECOND:=OLDSECOND+1;ABSSEC100:=100-OLDSEC100+SEC100; END
  ELSE ABSSEC100:=SEC100-OLDSEC100;
 IF SECOND<OLDSECOND THEN
   BEGIN OLDMINUTE:=OLDMINUTE+1;ABSSEC:=60-OLDSECOND+SECOND; END
  ELSE ABSSEC:=SECOND-OLDSECOND;
 IF MINUTE<OLDMINUTE THEN
   BEGIN OLDHOUR:=OLDHOUR+1;ABSSEC:=ABSSEC+60*(60-OLDMINUTE+MINUTE); END
  ELSE ABSSEC:=ABSSEC+60*(MINUTE-OLDMINUTE);
 IF HOUR<OLDHOUR THEN ABSSEC:=ABSSEC+3600*(24-OLDHOUR+HOUR)
  ELSE ABSSEC:=ABSSEC+3600*(HOUR-OLDHOUR);
 STR(ABSSEC,CR);TIME:=CR+'.';STR(ABSSEC100,CR);
 IF ((LENGTH(CR)=1) AND (CR<>'0')) THEN CR:='0'+CR;
 TIME:=TIME+CR;
END;{ TIMEINSEC }

{ Main program : }

BEGIN

 INITIALIZE;CLEARDEVICE; { standard initialization not necessary here }
 MAINWINDOW('');
 IF N>10000 THEN
  STATUSLINE('Be patient! This will take the computer some time!');

{ Random number generation by the Box-Muller method : }

 GETTIME(HOUR,MINUTE,SECOND,SEC100);
 K:=0;
 REPEAT
  K:=K+1;
  GENER03(U1,U2);
 UNTIL K=N;
 TIMEINSEC(TIME);CR:='Box-Muller CPU-run-time in seconds : '+TIME;
 OUTTEXTXY(TRUNC(MAXX/2),TRUNC(MAXY/2)-2*TEXTHEIGHT('M'),CR);

{ Random number generation by the Polar-Marsaglia method : }

 GETTIME(HOUR,MINUTE,SECOND,SEC100);
 K:=0;
 REPEAT
  K:=K+1;
  GENERATE(U1,U2);
 UNTIL K=N;
 TIMEINSEC(TIME);CR:='Polar Marsaglia CPU-run-time in seconds : '+TIME;
 OUTTEXTXY(TRUNC(MAXX/2),TRUNC(MAXY/2)+2*TEXTHEIGHT('M'),CR);

 STATUSLINE('Computational time elapsed by the random number generation');
 WAITTOGO; { waits for <ENTER> to be pressed }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X2X7 }