{ Averages of exponentiallly distributed pseudo-random numbers }
{ Written by Henri Schurz, 9.10. 1991                          }

PROGRAM PRX1X3X4; { PC-Exerxise 1.4.10 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
  NUMBER=1000; { number of the random numbers              }
  LAMBDA=0.5;  { parameter of the exponential distribution }
  EX=1/LAMBDA; { identities                                }
  EX1=1.0+EX;
  EX2=2.0+EX;
  EX3=3.0+EX;
  EX4=4.0+EX;

TYPE
  VECTOR=ARRAY[0..4] OF REAL;

VAR
  I:INTEGER;                { counter                  }
  L:ARRAY[1..4] OF INTEGER; { index counter            }
  X:REAL;                   { random value             }
  E:VECTOR;                 { estimate of the averages }

{ Prints out the table of the sample parameters and the corresponding exact }
{ values on the screen                                                      }

PROCEDURE SETTABLETOSCR;
VAR
 CR,CS:STRING;
 I1,I2,K:INTEGER;
BEGIN
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 LINE(0,40,0,100);LINE(MAXX-2,40,MAXX-2,100);
 LINE(0,40,MAXX-2,40);LINE(0,60,MAXX-2,60);
 LINE(0,80,MAXX-2,80);LINE(0,100,MAXX-2,100);
 I1:=TRUNC((MAXX-2)/12);I2:=2*I1;
 FOR K:=0 TO 5 DO { preparation of the table }
  BEGIN
   IF K<5 THEN LINE((K+1)*I2,40,(K+1)*I2,100);
   CASE K OF
     0 : BEGIN CR:='';CS:='exact values';END;
     1 : BEGIN CR:='EX';CS:=CHCR(EX);END;
     2 : BEGIN CR:='E(X:X>=1.0)';CS:=CHCR(EX1);END;
     3 : BEGIN CR:='E(X:X>=2.0)';CS:=CHCR(EX2);END;
     4 : BEGIN CR:='E(X:X>=3.0)';CS:=CHCR(EX3);END;
     5 : BEGIN CR:='E(X:X>=4.0)';CS:=CHCR(EX4);END;
    END;
   OUTTEXTXY(I1+K*I2,50,CR);OUTTEXTXY(I1+K*I2,70,CS);
  END;
 OUTTEXTXY(I1,90,'estimat. val.');
 FOR K:=0 TO 4 DO { output of the estimated averages }
  BEGIN
   CR:=CHCR(E[K]);
   OUTTEXTXY(I1+(K+1)*I2,90,CR);
  END;
END;{ SETTABLETOSCR }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Problem 1.3.4 (PC-Exercise 1.4.10)');
 STATUSLINE('Be patient! This will take the computer some time!');

 FOR I:=1 TO 4 DO { intialization }
  BEGIN
   L[I]:=0;   { index counter           }
   E[I]:=0.0; { conditional expectation }
  END;
 I:=0;
 E[0]:=0.0;
 REPEAT
  I:=I+1;
  GENER02(LAMBDA,X);
  E[0]:=E[0]+X;
  IF X>=1.0 THEN
   BEGIN
    L[1]:=L[1]+1;
    E[1]:=E[1]+X;
    IF X>=2.0 THEN
     BEGIN
      L[2]:=L[2]+1;
      E[2]:=E[2]+X;
      IF X>=3.0 THEN
       BEGIN
        L[3]:=L[3]+1;
        E[3]:=E[3]+X;
        IF X>=4.0 THEN
         BEGIN
          L[4]:=L[4]+1;
          E[4]:=E[4]+X;
         END;
       END;
     END;
   END;
 UNTIL I=NUMBER;
 E[0]:=E[0]/NUMBER;
 FOR I:=1 TO 4 DO IF L[I]>0 THEN E[I]:=E[I]/L[I];

{ Printout : }

 CLEARDEVICE;
 SETTABLETOSCR; { Sets the data table on the screen }
 STATUSLINE('Averages of exponentially distributed random numbers');

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X3X4 }