{ Generation of correlated Gaussian pseudo-random numbers }
{ Written by Henri Schurz, 9.10. 1991                     }

PROGRAM PRX1X3X5; { PC-Exercise 1.4.12 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
  NUMBER=1000; { number of pairs of random numbers }
  H1=0.1;      { constants for covariances         }
  H2=1.0;
  H3=10.0;

TYPE
  MATRIX=ARRAY[1..2,1..2] OF REAL;

VAR
  I,K:INTEGER;           { counters                        }
  V1,V2,X1,X2:REAL;      { random numbers                  }
  COV:MATRIX;            { covariances                     }
  H:ARRAY[1..3] OF REAL; { constants of the covariances    }
  EX1,EX2:REAL;          { estimates of the first moments  }
  E2X1,E2X2:REAL;        { estimates of the second moments }
  EX1X2:REAL;            { estimate of the mixed moment    }

{ Prints out the sample parameters and the corresponding exact values }
{ on the screen                                                       }

PROCEDURE SETTABLETOSCR;
VAR
 CR:STRING;
 I,I1,I2,K:INTEGER;
BEGIN
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 I1:=TRUNC((MAXX-2)/12);I2:=2*I1;
 OUTTEXTXY(TRUNC((MAXX-2)/2),25,'The sample averages and covariances :');
 LINE(0,40,MAXX,40);LINE(0,60,MAXX,60);
 LINE(0,40,0,200);LINE(MAXX-2,40,MAXX-2,200);
 FOR I:=1 TO 6 DO
  BEGIN
   IF I<6 THEN LINE(I*I2,40,I*I2,60);
   CASE I OF
     1 : CR:='h';
     2 : CR:='EX1';
     3 : CR:='EX2';
     4 : CR:='E2X1';
     5 : CR:='E2X2';
     6 : CR:='EX1X2';
    END;
   OUTTEXTXY(I1+(I-1)*I2,50,CR);
  END;
 OUTTEXTXY(TRUNC((MAXX-2)/2),130,'... and the corresponding exact values :');
 FOR K:=1 TO 3 DO
  BEGIN
   LINE(0,60+K*20,MAXX,60+K*20);
   LINE(0,140+K*20,MAXX,140+K*20);
   CASE K OF
     1 : CR:=CHCR(H1);
     2 : CR:=CHCR(H2);
     3 : CR:=CHCR(H3);
    END;
   OUTTEXTXY(I1,50+K*20,CR);OUTTEXTXY(I1,130+K*20,CR);
   FOR I:=1 TO 5 DO
    BEGIN
     LINE(I*I2,60+(K-1)*20,I*I2,60+K*20);
     LINE(I*I2,140+(K-1)*20,I*I2,140+K*20);
     CASE K OF
       1 : CASE I OF
             1 : CR:='0';
             2 : CR:='0';
             3 : CR:=CHCR(H1);
             4 : CR:=CHCR(H1*H1*H1/3);
             5 : CR:=CHCR(H1*H1/2);
            END;
       2 : CASE I OF
             1 : CR:='0';
             2 : CR:='0';
             3 : CR:=CHCR(H2);
             4 : CR:=CHCR(H2*H2*H2/3);
             5 : CR:=CHCR(H2*H2/2);
            END;
       3 : CASE I OF
             1 : CR:='0';
             2 : CR:='0';
             3 : CR:=CHCR(H3);
             4 : CR:=CHCR(H3*H3*H3/3);
             5 : CR:=CHCR(H3*H3/2);
            END;
      END;
     OUTTEXTXY(I1+I*I2,130+K*20,CR);
    END;
  END;
END;{ SETTABLETOSCR }

{ The following procedure transforms the independent Gaussian random num-  }
{ bers V1 and V2 into the correlated Gaussian random numbers X1 and X2.    }

PROCEDURE TRANSFOR(V1,V2:REAL;VAR X1,X2:REAL;COV:MATRIX);
VAR A,B,C,D:REAL;
BEGIN
  A:=0;B:=SQRT(COV[1,1]);
  D:=COV[1,2]/B;C:=SQRT(COV[2,2]-D*D);
  X1:=A*V1+B*V2;
  X2:=C*V1+D*V2;
END;{ TRANSFOR }

{ Output of the estimates : }

PROCEDURE SETESTIMATESTOSCR;
VAR
 CR:STRING;
 I1,I2,L:INTEGER;
BEGIN
 I1:=TRUNC((MAXX-2)/12);I2:=2*I1;
 FOR L:=1 TO 5 DO { output of the estimates }
  BEGIN
   CASE L OF
     1 : CR:=CHCR(EX1);
     2 : CR:=CHCR(EX2);
     3 : CR:=CHCR(E2X1);
     4 : CR:=CHCR(E2X2);
     5 : CR:=CHCR(EX1X2);
    END;
   OUTTEXTXY(I1+L*I2,50+K*20,CR);
  END;
END;{ SETESTIMATESTOSCR }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Problem 1.3.5 (PC-Exercise 1.4.12)');
 STATUSLINE('Be patient! This will take the computer some time !');

 K:=0;
 REPEAT
  K:=K+1;
  CASE K OF { initialization of some parameters }
    1 : H[K]:=H1;
    2 : H[K]:=H2;
    3 : H[K]:=H3;
   END;
  COV[1,1]:=H[K];COV[1,2]:=H[K]*H[K]/2; { initialization of the covariances }
  COV[2,1]:=COV[1,2];COV[2,2]:=H[K]*H[K]*H[K]/3;
  EX1:=0;EX2:=0;E2X1:=0;E2X2:=0;EX1X2:=0; { initialization of the moments }
  I:=0;
  REPEAT
   I:=I+1;
   GENERATE(V1,V2); { generates the Gaussian random numbers }
   TRANSFOR(V1,V2,X1,X2,COV); { transforms to dependent random numbers }
   EX1:=EX1+X1;EX2:=EX2+X2;E2X1:=E2X1+X1*X1;E2X2:=E2X2+X2*X2;
   EX1X2:=EX1X2+X1*X2;
  UNTIL I=NUMBER;
  EX1:=EX1/NUMBER;EX2:=EX2/NUMBER;
  E2X1:=E2X1/(NUMBER-1);E2X2:=E2X2/(NUMBER-1);
  EX1X2:=EX1X2/NUMBER;
  IF K=1 THEN
   BEGIN
    CLEARDEVICE;SETTABLETOSCR;
    STATUSLINE('Be patient! This will take the computer some time !');
   END;
  SETESTIMATESTOSCR; { output of the estimates }
 UNTIL K=3;

 STATUSLINE('Generation of correlated Gaussian pseudo-random numbers');

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X3X5 }