{ Generation of Gaussian pseudo-random numbers                    }
{ Checking numerically whether or not the jointly Gaussian random }
{ variables X1 and X2 are independent                             }
{ Written by Henri Schurz, 9.10. 1991                             }

PROGRAM PRX1X3X6; { PC-Exercise 1.4.13 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
  NUMBER=1000; { number of pairs of random numbers   }
  H1=0.1;      { constants for the covariances       }
  H2=1.0;
  H3=10.0;

TYPE
  MATRIX=ARRAY[1..2,1..2] OF REAL;

VAR
  I,K:INTEGER;               { counters                               }
  V1,V2,X1,X2:REAL;          { random variables                       }
  COV:MATRIX;                { covariances                            }
  H:ARRAY[1..3] OF REAL;     { constants of the covariance            }
  EX1,EX2:REAL;              { estimates of the first moments         }
  E2X1,E2X2:REAL;            { estimates of the second moments        }
  EX1X2:REAL;                { estimate of the mixed moment           }
  E2X1AX2:REAL;              { estimate of the second moment of X1+X2 }
  VARX1,VARX2,VARX1AX2:REAL; { estimates of the variances             }

{ Prints out the table of the sample parameters and the corresponding exact }
{ values on the screen                                                      }

PROCEDURE SETTABLETOSCR;
VAR
 CR,CS:STRING;
 I1,I2,K:INTEGER;
BEGIN
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 LINE(0,40,0,120);LINE(0,40,MAXX-2,40);LINE(0,60,MAXX-2,60);
 LINE(MAXX-2,40,MAXX-2,120);
 I1:=TRUNC((MAXX-2)/10);I2:=2*I1;
 FOR K:=1 TO 5 DO { preparation of the table }
  BEGIN
   IF K<5 THEN LINE(K*I2,40,K*I2,120);
   CASE K OF
     1 : CR:='h';
     2 : CR:='VAR(X1)';
     3 : CR:='VAR(X2)';
     4 : CR:='VAR(X1+X2)';
     5 : CR:='VAR(X1)+VAR(X2)';
    END;
   OUTTEXTXY(I1+(K-1)*I2,50,CR);
  END;
 FOR K:=1 TO 3 DO
  BEGIN
   LINE(0,60+K*20,MAXX-2,60+K*20);
   CASE K OF { output of parameters }
     1 : CR:=CHCR(H1);
     2 : CR:=CHCR(H2);
     3 : CR:=CHCR(H3);
    END;
   OUTTEXTXY(I1,50+K*20,CR);
  END;
END;{ SETTABLETOSCR }

{ Output of the estimates : }

PROCEDURE SETESTIMATESTOSCR;
VAR
 CR:STRING;
 I,I1,I2:INTEGER;
BEGIN
 I1:=TRUNC((MAXX-2)/10);I2:=2*I1;
 FOR I:=1 TO 4 DO { output of the variances }
  BEGIN
   CASE I OF
     1 : CR:=CHCR(VARX1);
     2 : CR:=CHCR(VARX2);
     3 : CR:=CHCR(VARX1AX2);
     4 : CR:=CHCR(VARX1+VARX2);
    END;
   OUTTEXTXY(I1+I*I2,50+K*20,CR);
  END;
END;{ SETESTIMATESTOSCR }

{ The following procedure transforms the independent Gaussian random num-  }
{ bers V1 and V2 into the correlated Gaussian random numbers X1 and X2.    }

PROCEDURE TRANSFOR(V1,V2:REAL;VAR X1,X2:REAL;COV:MATRIX);
VAR A,B,C,D:REAL;
BEGIN
  A:=0;B:=SQRT(COV[1,1]);
  D:=COV[1,2]/B;C:=SQRT(COV[2,2]-D*D);
  X1:=A*V1+B*V2;
  X2:=C*V1+D*V2;
END;{ TRANSFOR }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Problem 1.3.6 (PC-Exercise 1.4.13)');
 STATUSLINE('Be patient! This will take the computer some time !');

 K:=0;
 REPEAT
  K:=K+1;
  CASE K OF
    1 : H[K]:=H1;
    2 : H[K]:=H2;
    3 : H[K]:=H3;
   END;
  COV[1,1]:=H[K];COV[1,2]:=H[K]*H[K]/2; { initialization of the covariances }
  COV[2,1]:=COV[1,2];COV[2,2]:=H[K]*H[K]*H[K]/3;
  EX1:=0;EX2:=0;E2X1:=0;E2X2:=0; { initialization of the moments }
  EX1X2:=0;E2X1AX2:=0;
  I:=0;
  REPEAT
   I:=I+1;
   GENERATE(V1,V2);
   TRANSFOR(V1,V2,X1,X2,COV);
   EX1:=EX1+X1;EX2:=EX2+X2;E2X1:=E2X1+X1*X1;E2X2:=E2X2+X2*X2;
   EX1X2:=EX1X2+X1*X2;E2X1AX2:=E2X1AX2+(X1+X2)*(X1+X2);
  UNTIL I=NUMBER;
  EX1:=EX1/NUMBER;EX2:=EX2/NUMBER;
  E2X1:=E2X1/(NUMBER-1);E2X2:=E2X2/(NUMBER-1);
  EX1X2:=EX1X2/NUMBER;E2X1AX2:=E2X1AX2/(NUMBER-1);
  VARX1:=E2X1-EX1*EX1;VARX2:=E2X2-EX2*EX2;
  VARX1AX2:=E2X1AX2-(EX1+EX2)*(EX1+EX2);
  IF K=1 THEN
   BEGIN
    CLEARDEVICE;
    SETTABLETOSCR; { sets the data table on the screen }
    STATUSLINE('Be patient! This will take the computer some time !');
   END;
  SETESTIMATESTOSCR; { output of the variances }
 UNTIL K=3;

 STATUSLINE('Are the Gaussian random variables X1 and X2 independent?');

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X3X6 }