{ Convergence of  E SQR(An-mu) to show the law of large numbers }
{ where  An = (X1+X2+...+Xn)/n  (n=10,100,1000)  and            }
{ Xi are i.i.d. random variables with  mu = E(Xi)               }
{ Written by Henri Schurz, 9.10. 1991                           }

PROGRAM PRX1X4X2; { PC-Exercise 1.5.4 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
  NUMBER=100; { sample size                               }
  P=0.2;      { probability that Xi = X1                  }
  X1=0.0;     { first value of the random variable Xi     }
  X2=1.0;     { second value of the random variable Xi    }
  LAMBDA=0.5; { parameter of the exponential distribution }

VAR
  CR:STRING;             { help string                     }
  I,I1,I2,K,L,M:INTEGER; { running numbers                 }
  N:INTEGER;             { number of the random variables  }
  AN,MU:REAL;            { sample average, true mean       }
  X,Y:REAL;              { random numbers                  }
  E:ARRAY[1..3] OF REAL; { estimate of  E SQR(An-mu)       }

{ Prints out a table on the screen }

PROCEDURE SETTABLETOSCR;
VAR
 CR:STRING;
 I,I1,I2,K:INTEGER;
BEGIN
 CLEARDEVICE;
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(TRUNC((MAXX-2)/2),30,'Averaging of  SQR ( An - mu )');
 LINE(0,40,MAXX-2,40);LINE(0,60,MAXX-2,60);
 LINE(0,40,0,120);LINE(MAXX-2,40,MAXX-2,120);
 I1:=TRUNC(MAXX/8);I2:=2*I1;
 FOR I:=1 TO 4 DO { output of some header strings }
  BEGIN
   IF I<4 THEN LINE(I*I2,40,I*I2,120);
   CASE I OF
     1 : CR:='N';
     2 : CR:='two-point';
     3 : CR:='exponential';
     4 : CR:='Gaussian';
    END;
   OUTTEXTXY(I1+(I-1)*I2,50,CR);
  END;
 FOR I:=1 TO 3 DO { output of the used n }
  BEGIN
   LINE(0,60+I*20,MAXX-2,60+I*20);
   LINE(I*I2,60+(I-1)*20,I*I2,60+I*20);
   CASE I OF
     1 : CR:='10';
     2 : CR:='100';
     3 : CR:='1000';
    END;
   OUTTEXTXY(I1,50+I*20,CR);
  END;
END;{ SETTABLETOSCR }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 CLEARDEVICE;MAINWINDOW('Problem 1.4.2 (PC-Exercise 1.5.4)');
 STATUSLINE('Be patient! This will take the computer some time!');
 I1:=TRUNC(MAXX/8);I2:=2*I1;

 K:=0;
 REPEAT
  K:=K+1;
  CASE K OF { generates the actual number of the random variables }
    1 : N:=10;
    2 : N:=100;
    3 : N:=1000;
   END;
  FOR I:=1 TO 3 DO E[I]:=0; { initialization of the moments to be estimated }
  I:=0;
  REPEAT
   I:=I+1; { generation number }
   FOR L:=1 TO 3 DO
    BEGIN
     AN:=0;
     FOR M:=1 TO N DO
      BEGIN
       CASE L OF { choice of random numbers to be used }
         1 : GENER01(P,X1,X2,X);
         2 : GENER02(LAMBDA,X);
         3 : GENERATE(X,Y);
        END;
       AN:=AN+X;
      END;
     AN:=AN/N;
     CASE L OF
       1 : MU:=X1*P+X2*(1-P);
       2 : MU:=1/LAMBDA;
       3 : MU:=0.0;
      END;
     E[L]:=E[L]+(AN-MU)*(AN-MU);
    END;
  UNTIL I=NUMBER;
  FOR I:=1 TO 3 DO E[I]:=E[I]/(NUMBER-1);
  IF K=1 THEN
   BEGIN
    SETTABLETOSCR; { preparation of the screen }
    STATUSLINE('Be patient! This will take the computer some time!');
   END;
  FOR I:=1 TO 3 DO { output of the estimates }
   BEGIN
    CR:=CHCR(E[I]);
    OUTTEXTXY(I1+I*I2,50+K*20,CR);
   END;
 UNTIL K=3;

 STATUSLINE('To verify the law of large numbers');

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X4X2 }