{ Illustrates the central limit theorem                                     }
{ Convergence of the empirical density function of Zn to the Gaussian       }
{ density function                                                          }
{ Zn = (Sn-n*mu)/(sigma*sqrt(n) where Sn = X1+X2+...+Xn   (n=100,500,1000)  }
{ and Xi are i.i.d. random variables with  mu = E(Xi)                       }
{ Using uniformly, two-point, exponentially and Gaussian distributed random }
{ variables(Polar Marsaglia method to generate Gaussian distributed)        }
{ Plots the histogram of the relative frequencies                           }
{ Written by Henri Schurz, 9.10.1991                                        }
{ Note : For a correct printout of the histogram one has to choose the      }
{        scaling parameter carefully. Peaks in the histogram may occur de-  }
{        pending on the random numbers generated, but are generally smaller }
{        than 1/INVLENGTH. Values outside the given interval are not        }
{        counted. With the INDEX-variable one controls how often one wants  }
{        to see the current histogram(it assumes (N MOD INDEX)=0!)          }
{ Important : Change parameter M to get other distributions.                }

PROGRAM PRX1X4X3; { PC-Exercise 1.5.6 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
 M=1;            { parameter to choose uniformly '1', two-point '2',       }
                 { expon. '3', Gaussian '4' distributed random variables   }
 N=500;          { parameter n here to change                              }
 NUMBER=1000;    { sample size                                             }
 P=0.2;          { probability that Xi = X1                                }
 X1=0.0;         { first value of the random variable Xi                   }
 X2=1.0;         { second value of the random variable Xi                  }
 LAMBDA=0.5;     { parameter of the exponential distribution               }
 INDEX=10;       { determines the frequency of printing of a new histogram }
 INVLENGTH=0.05; { length of subinterval                                   }
 ABSCMIN=-2.5;   { left end point                                          }
 ABSCMAX=2.5;    { right end point                                         }
 ORDMIN=0.0;     { minimum of the ordinate                                 }
 ORDMAX=0.7;     { maximum of the ordinate                                 }
 ORDPOINT=0.5;   { significant ordinate point                              }

TYPE
 VECTOR=ARRAY[1..NUMBER] OF REAL;

VAR
 CR:STRING;           { help string                     }
 I,N1,L:INTEGER;      { help variables                  }
 AXISX,AXISY:INTEGER; { location of the axes            }
 DISTX,DISTY:INTEGER; { scale parameters                }
 ROOTN1:REAL;         { sqrt(1/n1)                      }
 X,Y:REAL;            { generated randon numbers        }
 MU,SIGMA:REAL;       { average and sqrt(variance)      }
 SN:VECTOR;           { vector of the random sum Sn     }
 ZN:VECTOR;           { vector of the random numbers Zn }

{ Prepares the screen for the printout of the histogram required }

PROCEDURE COORDSYS;
VAR
 FACTOR,I0,I1,I2,IH,K:INTEGER;
 DX,DY:REAL;
BEGIN
 IH:=TEXTHEIGHT('M')+5;
 AXISX:=TRUNC(13*MAXY/16);
 I0:=TEXTWIDTH(CHCR(ORDMAX))+7;I1:=TEXTWIDTH(CHCR(ORDMIN))+7;
 I2:=TEXTWIDTH(CHCR(ORDPOINT))+7;IF I0<I1 THEN I0:=I1;
 IF I0<I2 THEN I0:=I2;I1:=TRUNC(MAXX/10);
 IF I0>MAXX-NUMINV-40 THEN I0:=MAXX-NUMINV-40;
 IF I0<I1 THEN AXISY:=I1 ELSE AXISY:=I0;
 DISTX:=NUMINV;DISTY:=AXISX-3*IH-5;
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY,IH+5,'^');OUTTEXTXY(AXISY,IH-5,'f(x)');
 LINE(AXISY,IH+5,AXISY,AXISX+5);LINE(AXISY-5,AXISX,AXISY+30+DISTX,AXISX);
 SETTEXTJUSTIFY(2,1);I0:=AXISX-10-DISTY;
 LINE(AXISY-3,I0,AXISY+3,I0);OUTTEXTXY(AXISY-7,I0,CHCR(ORDMAX));
 DY:=(ORDPOINT-ORDMIN)/(ORDMAX-ORDMIN);I0:=AXISX-10-TRUNC(DY*DISTY);
 LINE(AXISY-3,I0,AXISY+3,I0);OUTTEXTXY(AXISY-7,I0,CHCR(ORDPOINT));
 LINE(AXISY-3,AXISX-10,AXISY+3,AXISX-10);
 OUTTEXTXY(AXISY-7,AXISX-10,CHCR(ORDMIN));SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY+30+DISTX,AXISX+1,'>');OUTTEXTXY(AXISY+30+DISTX,AXISX+2*IH,'x');
 IF ((ABSCMAX-ABSCMIN=2.0) OR (ABSCMAX+ABSCMIN=0.0)) THEN FACTOR:=2 ELSE
  IF ABSCMAX-ABSCMIN=3.0 THEN FACTOR:=3 ELSE
   IF ABSCMAX-ABSCMIN=4.0 THEN FACTOR:=4 ELSE
    IF ((ABSCMAX-ABSCMIN=5.0) OR ((ABSCMAX-ABSCMIN=1.0) AND (ABSCMIN=0.0)))
     THEN FACTOR:=5 ELSE FACTOR:=1;
 DX:=(ABSCMAX-ABSCMIN)/FACTOR;
 FOR K:=0 TO FACTOR DO
  BEGIN
   I1:=AXISY+10+TRUNC(K*DISTX/FACTOR+0.5);I2:=AXISX+IH;
   LINE(I1,AXISX+3,I1,AXISX-3);
   OUTTEXTXY(I1,I2,CHCR(ABSCMIN+K*DX));
  END;
END;{ COORDSYS }

{ Realizes the quick-sort-algorithm for a vector }

PROCEDURE QSORT(DOWN,UP:INTEGER;VAR F:VECTOR);
VAR I,J:INTEGER;
    TMP,MIDDLE:REAL;
BEGIN
 I:=DOWN;J:=UP;MIDDLE:=F[TRUNC((DOWN+UP)/2)];
 REPEAT
  WHILE ((I<UP) AND (F[I]<MIDDLE)) DO I:=I+1;
  WHILE ((J>DOWN) AND (F[J]>MIDDLE)) DO J:=J-1;
  IF I<=J THEN
   BEGIN
    TMP:=F[I];F[I]:=F[J];F[J]:=TMP;I:=I+1;J:=J-1
   END;
 UNTIL I>J;
 IF DOWN<J THEN QSORT(DOWN,J,F);
 IF I<UP THEN QSORT(I,UP,F);
END;{ QSORT }

{ Provides the histogram of the relative frequencies }
{ Assumes COORDSYS has been called before            }
{ Aborts if data out of range                        }

PROCEDURE HISTOGRAM(NN:INTEGER;F:VECTOR); { assumes a sorted vector F }
VAR
 CR:STRING;
 ENDS:BOOLEAN;
 I,IH,IL,IR,K,KLOWER,KUPPER:INTEGER;
 FACTORX,FACTORY:REAL; { scaling factors         }
 INVEND:REAL;          { current subinterval end }
BEGIN
 FACTORX:=DISTX/(ABSCMAX-ABSCMIN);
 FACTORY:=DISTY/(ORDMAX-ORDMIN);
 INVEND:=ABSCMIN;

{ Control over data used and the printout of the histogram : }

 ENDS:=FALSE; { permitted data }
 KLOWER:=0;KUPPER:=NN+1;
 I:=NN+1;
 IF F[NN]<ABSCMIN THEN ENDS:=TRUE ELSE
  IF F[1]>ABSCMAX THEN ENDS:=TRUE ELSE
   BEGIN
    WHILE ((I>2) AND (F[I-1]>ABSCMAX)) DO I:=I-1;
    IF I>1 THEN KUPPER:=I-1
     ELSE ENDS:=TRUE; { out of range }
    I:=0;
    WHILE ((I<NN-1) AND (F[I+1]<ABSCMIN)) DO I:=I+1;
    IF I<NN THEN KLOWER:=I
     ELSE ENDS:=TRUE; { out of range }
   END;
 IF ENDS=FALSE THEN
   BEGIN
    I:=KLOWER;
    REPEAT
     INVEND:=INVEND+INVLENGTH;I:=I+1;K:=0;
     WHILE ((I+K<NN) AND (F[I+K]<=INVEND)) DO K:=K+1;
     IF ((I+K=NN) AND (F[I+K]<=INVEND)) THEN K:=K+1;
     IF K>0 THEN
       BEGIN
        I:=I+K-1;
        IL:=AXISY+10+TRUNC((INVEND-INVLENGTH-ABSCMIN)*FACTORX);
        IR:=AXISY+10+TRUNC((INVEND-ABSCMIN)*FACTORX);
        IH:=AXISX-10-TRUNC((((K/NN)/INVLENGTH)-ORDMIN)*FACTORY);
        LINE(IL,AXISX-10,IL,IH);LINE(IL,IH,IR,IH);LINE(IR,IH,IR,AXISX-10);
        LINE(IL,AXISX-10,IR,AXISX-10);
       END
      ELSE I:=I-1;
    UNTIL ((INVEND>=ABSCMAX) OR (I>=KUPPER));
   END
  ELSE { terminates the program because of nonallowable data configuration }
   BEGIN
    CR:='Please, use another interval!';
    OUTTEXTXY(TRUNC(MAXX/2),TRUNC(MAXY/2),CR);
    CR:='Data out of range! Press <ESC> and check data';
    STATUSLINE(CR);
    WAITTOGO;
   END;
END;{ HISTOGRAM }

{ Prints out some parameters on the screen }

PROCEDURE SETPARATOSCR(AVERAGE,VARIANCE,CURRENTNUMBER:REAL);
VAR
 CR:STRING;
 IH,IL:INTEGER;
BEGIN
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 IH:=TRUNC(MAXX/2);IL:=TEXTHEIGHT('M');
 CR:=CHCR(AVERAGE);CR:='average  E(Xi) = '+CR;OUTTEXTXY(IH,IL+2,CR);
 CR:=CHCR(VARIANCE);CR:='variance VAR(Xi) = '+CR;OUTTEXTXY(IH,2+3*IL,CR);
 CR:=CHCR(CURRENTNUMBER);CR:='number of random variables = '+CR;
 OUTTEXTXY(IH,2+5*IL,CR);
END;{ SETPARATOSCR }

{ Main program : }

BEGIN

 INITIALIZE; { initialization  }
 MAINWINDOW('Problem 1.4.3 (PC-Exercise 1.5.6)');
 STATUSLINE('Be patient! This will take the computer some time!');

 CASE M OF { initialization of the average MU and the variance SIGMA*SIGMA }
  1 : BEGIN MU:=0.5;SIGMA:=SQRT(1/12);END;
  2 : BEGIN MU:=X1*P+X2*(1-P);SIGMA:=SQRT(X1*X1*P+X2*X2*(1-P)-MU*MU);END;
  3 : BEGIN MU:=1/LAMBDA;SIGMA:=MU;END;
  4 : BEGIN MU:=0.0;SIGMA:=1.0;END;
 END;
 FOR I:=1 TO NUMBER DO SN[I]:=0.0;
 N1:=0;
 REPEAT
  N1:=N1+INDEX;
  ROOTN1:=SQRT(N1);
  FOR I:=1 TO NUMBER DO
   BEGIN
    L:=N1-INDEX;
    REPEAT
     L:=L+1;
     CASE M OF
       1 : X:=RANDOM;
       2 : GENER01(P,X1,X2,X);
       3 : GENER02(LAMBDA,X);
       4 : IF I MOD 2 = 1 THEN GENERATE(X,Y) ELSE X:=Y;
     END;
     SN[I]:=SN[I]+X;
    UNTIL L=N1;
    ZN[I]:=(SN[I]-N1*MU)/(SIGMA*ROOTN1);
   END;
  STATUSLINE('Be patient! This will take the computer some time!');
  QSORT(1,NUMBER,ZN); { sorts the vector F }
  CLEARDEVICE;
  COORDSYS;     { draws the coordinate system }
  HISTOGRAM(NUMBER,ZN); { plots the histogram }
  SETPARATOSCR(MU,SIGMA*SIGMA,N1);
  CR:='Histogram of relative frequencies divided by subinterval length';
  STATUSLINE(CR);
 UNTIL N1=N;

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X4X3 }