{ CHI-square goodness-of-fit test of the uniformly, exponentially and   }
{ Gaussian distributed pseudo-random number generators on this computer }
{ Written by Henri Schurz, 9.10. 1991                                   }

PROGRAM PRX1X5X2; { PC-Exerxise 1.9.3 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
  N=1000;        { sample size                                     }
  ALPHA1=0.01;   { significance level                              }
  ALPHA2=0.05;   { significance level                              }
  QUANTIL1=43.8; { percentage point of the CHI-square distribution }
  QUANTIL2=50.9; { percentage point of the CHI-square distribution }
  K=30;          { with K degrees of freedom                       }
  LAMBDA=1.0;    { parameter of the exponential distribution       }

TYPE
  VECTOR=ARRAY[1..N] OF REAL;
  VECTOR1=ARRAY[1..4] OF REAL;

VAR
  CR:STRING;   { help string                                 }
  I,L:INTEGER; { help integers                               }
  U:REAL;      { help number                                 }
  X:VECTOR;    { sample vector                               }
  CHI:VECTOR1; { test values for different random generators }

{ Provides integrals of the Gaussian density breaking off if the distance }
{ of two iterations following one another is smaller than EPS             }

PROCEDURE ROMBERG(A,B:REAL;VAR INTVALUE:REAL);
CONST
 MAXIT=5; { numbers of iterations                           }
 EPS=1E-10; { breaking off condition between two iterations }
VAR
 J,K,L,M:INTEGER;
 FAB,IS,IT,INT1,INT2,INN:REAL;
 H,Q,I:ARRAY[1..MAXIT] OF REAL;
FUNCTION F(X:REAL):REAL; { Gaussian density function }
BEGIN
 F:=EXP(-X*X/2)/SQRT(2*PI);
END;{ F }
BEGIN
 H[1]:=B-A;
 FOR K:=1 TO MAXIT-1 DO H[K+1]:=H[K]*0.5;
 FOR K:=1 TO MAXIT DO Q[K]:=SQR(H[K]);
 FAB:=F(A)+F(B);
 IT:=0;
 I[1]:=FAB*H[1]*0.5;
 L:=1;
 REPEAT
  L:=L+1;
  M:=TRUNC((B-A)/H[L]);
  FOR J:=1 TO TRUNC(M*0.5) DO IT:=IT+F(A+(J+J-1)*H[L]);
  IS:=(FAB+IT+IT)*H[L]*0.5;
  IF L>2 THEN
   FOR K:=3 TO L DO IS:=(I[K-2]*Q[L]-IS*Q[K-2])/(Q[L]-Q[K-2]);
  I[L]:=(I[L-1]*Q[L]-IS*Q[L-1])/(Q[L]-Q[L-1]);
  IF I[L]=0. THEN INN:=1. ELSE INN:=I[L];
 UNTIL (ABS((I[L]-I[L-1])/INN)<EPS) OR (L=MAXIT);
 IF (L=MAXIT) AND (ABS(I[L]-I[L-1])>=EPS) THEN
   BEGIN
    ROMBERG(A,A+(B-A)/2,INT1);ROMBERG(A+(B-A)/2,B,INT2);
    INTVALUE:=INT1+INT2
   END
  ELSE
   INTVALUE:=I[L];
END;{ ROMBERG }

{ Realizes the quick-sort-algorithm for a vector }

PROCEDURE QSORT(DOWN,UP:INTEGER;VAR F:VECTOR);
VAR I,J:INTEGER;
    TMP,MIDDLE:REAL;
BEGIN
 I:=DOWN;J:=UP;MIDDLE:=F[TRUNC((DOWN+UP)/2)];
 REPEAT
  WHILE ((I<UP) AND (F[I]<MIDDLE)) DO I:=I+1;
  WHILE ((J>DOWN) AND (F[J]>MIDDLE)) DO J:=J-1;
  IF I<=J THEN
   BEGIN
    TMP:=F[I];F[I]:=F[J];F[J]:=TMP;I:=I+1;J:=J-1
   END;
 UNTIL I>J;
 IF DOWN<J THEN QSORT(DOWN,J,F);
 IF I<UP THEN QSORT(I,UP,F);
END;{ QSORT }

{ Prepares the screen and plots a table with the results on it }

PROCEDURE SETTABLETOSCR;
VAR
 CR:STRING;
 IK,L:INTEGER;
BEGIN
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 IK:=TRUNC((MAXX-2)/10);
 FOR L:=0 TO 4 DO LINE(0,80+L*20,10*IK,80+L*20);
 OUTTEXTXY(TRUNC(MAXX/2),25,'Results of the goodness-of-fit test :');
 OUTTEXTXY(5*IK,60,'sample size N = '+CHCR(N));
 OUTTEXTXY(IK,90,'distribution');
 FOR L:=0 TO 5 DO
  BEGIN
   LINE(2*L*IK,80,2*L*IK,160);
   CASE L OF
     1 : CR:='unif. distr.';
     2 : CR:='exp. distr.';
     3 : CR:='Gaus. distr.';
     4 : CR:='Gaus. distr.';
    END;
   IF ((L<>0) AND (L<>5)) THEN OUTTEXTXY((2*L+1)*IK,90,CR);
  END;
 FOR L:=0 TO 2 DO
  CASE L OF
    0 : BEGIN
         FOR I:=0 TO 4 DO
          BEGIN
           CASE I OF
             0 : CR:='method';
             1 : CR:='PC-generator';
             2 : CR:='inverse transf.';
             3 : CR:='Box Muller';
             4 : CR:='Polar Mars.';
            END;
           OUTTEXTXY((2*I+1)*IK,110+L*20,CR);
          END;
        END;
    1 : OUTTEXTXY(IK,110+L*20,'x('+CHCR(1.0-ALPHA1)+')='+CHCR(QUANTIL1));
    2 : OUTTEXTXY(IK,110+L*20,'x('+CHCR(1.0-ALPHA2)+')='+CHCR(QUANTIL2));
   END;
 FOR L:=1 TO 4 DO
  BEGIN
   CR:=CHCR(CHI[L]);
   OUTTEXTXY((2*L+1)*IK,130,CR);OUTTEXTXY((2*L+1)*IK,150,CR);
  END;
END;{ SETTABLETOSCR }

{ Calculates the current test value assuming a sorted data vector X   }
{ DEGREE = number of degrees of freedom                               }
{ INDEX = choice of the distribution to be tested, SIZE = sample size }
{ Categories are chosen without adaptation to the given data          }

PROCEDURE CHITEST(DEGREE,INDEX,SIZE:INTEGER;X:VECTOR;VAR TESTVALUE:REAL);
VAR
 NOEND:BOOLEAN;  { control if the current data belongs to the category }
 KK:INTEGER;     { counter                                             }
 J:INTEGER;      { category index                                      }
 NJ:INTEGER;     { number of data falling into a category              }
 NECLEFT,NECRIGHT:INTEGER; { numbers of extra categories               }
 PJ:REAL;        { probability of a category                           }
 SUMPJ:REAL;     { sum of probabilities of the categories              }
 TJ:REAL;        { left end point of the j'th category                 }
 INVLENGTH:REAL; { length of subinterval                               }
BEGIN
 TESTVALUE:=0.0;
 CASE INDEX OF { choice of finite categories and control over its lengths }
   1 : BEGIN TJ:=0.0;INVLENGTH:=1./(DEGREE+1); END;
   2 : BEGIN TJ:=0.0;INVLENGTH:=10./(DEGREE*LAMBDA); END;
   3 : BEGIN TJ:=-3.;INVLENGTH:=6./DEGREE; END;
   4 : BEGIN TJ:=-3.;INVLENGTH:=6./DEGREE; END;
  END;
 KK:=1; { pointer to the current data index }
 NOEND:=TRUE;
 IF ((INDEX=3) OR (INDEX=4)) THEN { correction of the data index }
  BEGIN
   KK:=0;
   WHILE NOEND DO
    IF X[KK+1]<=TJ THEN BEGIN KK:=KK+1;IF KK=SIZE THEN NOEND:=FALSE; END
     ELSE NOEND:=FALSE;
   NECLEFT:=KK;KK:=KK+1;
  END;
 J:=0; { index of the current category }
 SUMPJ:=0.0;
 REPEAT
  J:=J+1;
  TJ:=TJ+INVLENGTH; { right end point of the current category }
  NJ:=0;NOEND:=TRUE;
  IF KK=SIZE+1 THEN NOEND:=FALSE;
  WHILE NOEND DO { provides the number of data falling into the category }
   IF X[KK]<=TJ THEN
     BEGIN
      KK:=KK+1;NJ:=NJ+1;IF KK=SIZE+1 THEN NOEND:=FALSE;
     END
    ELSE NOEND:=FALSE;
  CASE INDEX OF { generation of the probability of the current category }
      1 : PJ:=INVLENGTH;
      2 : PJ:=EXP(-LAMBDA*(TJ-INVLENGTH))-EXP(-LAMBDA*TJ);
    3,4 : ROMBERG(TJ-INVLENGTH,TJ,PJ);
   END;
  SUMPJ:=SUMPJ+PJ; { summation of the single probability }
 TESTVALUE:=TESTVALUE+SQR(NJ-SIZE*PJ)/(SIZE*PJ);
 UNTIL J=DEGREE;
 NECRIGHT:=SIZE+1-KK;
 IF ((INDEX=3) OR (INDEX=4)) THEN NJ:=NECLEFT+NECRIGHT ELSE NJ:=NECRIGHT;
 PJ:=1.-SUMPJ; { probability of the extra categories }
 TESTVALUE:=TESTVALUE+SQR(NJ-SIZE*PJ)/(SIZE*PJ);
END;{ CHITEST }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Problem 1.5.2 (PC-Exercise 1.9.3)');
 STATUSLINE('Be patient! This will take the computer some time!');

 L:=0; { index of the random number generator }
 REPEAT
  L:=L+1;
  FOR I:=1 TO N DO { initializes data vector X }
   CASE L OF
     1 : X[I]:=RANDOM;
     2 : GENER02(LAMBDA,X[I]);
     3 : IF I MOD 2 = 1 THEN GENER03(X[I],U) ELSE X[I]:=U;
     4 : IF I MOD 2 = 1 THEN GENERATE(X[I],U) ELSE X[I]:=U;
    END;
  QSORT(1,N,X); { sorts the vector X }
  CHITEST(K,L,N,X,CHI[L]); { calculates the current test value }
 UNTIL L=4;

{ Printout : }

 CLEARDEVICE;SETTABLETOSCR;
 CR:='Chi-square goodness-of-fit test with '+CHCR(K)+' degrees of freedom';
 STATUSLINE(CR);

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X5X2 }