{ Kolmogorov-Smirnov test of the uniformly, exponentially and Gaussian }
{ distributed pseudo-random number generators on this computer         }
{ Written by Henri Schurz, 9.10. 1991                                  }

PROGRAM PRX1X5X3; { PC-Exerxise 1.9.4 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
 N=1000;        { sample size                                     }
 ALPHA1=0.01;   { significance level                              }
 ALPHA2=0.05;   { significance level                              }
 QUANTIL1=1.63; { percentage point of the Kolmogorov distribution }
 QUANTIL2=1.36; { percentage point of the Kolmogorov distribution }
 LAMBDA=1.0;    { parameter of the exponential distribution       }

TYPE
 VECTOR=ARRAY[1..N] OF REAL;
 VECTOR1=ARRAY[1..4] OF REAL;

VAR
 CR:STRING;   { help string                                 }
 I,L:INTEGER; { help integers                               }
 U:REAL;      { help number                                 }
 X:VECTOR;    { sample vector                               }
 KOL:VECTOR1; { test values for different random generators }

{ Provides integrals of the Gaussian density breaking off if the distance }
{ of two iterations following one another is smaller than EPS             }

PROCEDURE ROMBERG(A,B:REAL;VAR INTVALUE:REAL);
CONST
 MAXIT=5; { numbers of iterations                           }
 EPS=1E-10; { breaking off condition between two iterations }
VAR
 J,K,L,M:INTEGER;
 FAB,IS,IT,INT1,INT2,INN:REAL;
 H,Q,I:ARRAY[1..MAXIT] OF REAL;
FUNCTION F(X:REAL):REAL; { Gaussian density function }
BEGIN
 F:=EXP(-X*X/2)/SQRT(2*PI);
END;{ F }
BEGIN
 H[1]:=B-A;
 FOR K:=1 TO MAXIT-1 DO H[K+1]:=H[K]*0.5;
 FOR K:=1 TO MAXIT DO Q[K]:=SQR(H[K]);
 FAB:=F(A)+F(B);
 IT:=0;
 I[1]:=FAB*H[1]*0.5;
 L:=1;
 REPEAT
  L:=L+1;
  M:=TRUNC((B-A)/H[L]);
  FOR J:=1 TO TRUNC(M*0.5) DO IT:=IT+F(A+(J+J-1)*H[L]);
  IS:=(FAB+IT+IT)*H[L]*0.5;
  IF L>2 THEN
   FOR K:=3 TO L DO IS:=(I[K-2]*Q[L]-IS*Q[K-2])/(Q[L]-Q[K-2]);
  I[L]:=(I[L-1]*Q[L]-IS*Q[L-1])/(Q[L]-Q[L-1]);
  IF I[L]=0. THEN INN:=1. ELSE INN:=I[L];
 UNTIL (ABS((I[L]-I[L-1])/INN)<EPS) OR (L=MAXIT);
 IF (L=MAXIT) AND (ABS(I[L]-I[L-1])>=EPS) THEN
   BEGIN
    ROMBERG(A,A+(B-A)/2,INT1);ROMBERG(A+(B-A)/2,B,INT2);
    INTVALUE:=INT1+INT2
   END
  ELSE
   INTVALUE:=I[L];
END;{ ROMBERG }

{ Realizes the quick-sort-algorithm for a vector }

PROCEDURE QSORT(DOWN,UP:INTEGER;VAR F:VECTOR);
VAR I,J:INTEGER;
    TMP,MIDDLE:REAL;
BEGIN
 I:=DOWN;J:=UP;MIDDLE:=F[TRUNC((DOWN+UP)/2)];
 REPEAT
  WHILE ((I<UP) AND (F[I]<MIDDLE)) DO I:=I+1;
  WHILE ((J>DOWN) AND (F[J]>MIDDLE)) DO J:=J-1;
  IF I<=J THEN
   BEGIN
    TMP:=F[I];F[I]:=F[J];F[J]:=TMP;I:=I+1;J:=J-1
   END;
 UNTIL I>J;
 IF DOWN<J THEN QSORT(DOWN,J,F);
 IF I<UP THEN QSORT(I,UP,F);
END;{ QSORT }

{ Prepares the screen and plots a table with the results on it }

PROCEDURE SETTABLETOSCR;
VAR
 CR:STRING;
 IK,L:INTEGER;
BEGIN
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 IK:=TRUNC((MAXX-2)/10);
 FOR L:=0 TO 4 DO LINE(0,80+L*20,10*IK,80+L*20);
 OUTTEXTXY(TRUNC(MAXX/2),25,'Results of the Kolmogorov-Smirnov test :');
 OUTTEXTXY(3*IK,50,'sample size N = '+CHCR(N));
 OUTTEXTXY(IK,90,'distribution');
 FOR L:=0 TO 5 DO
  BEGIN
   LINE(2*L*IK,80,2*L*IK,160);
   CASE L OF
     1 : CR:='unif. distr.';
     2 : CR:='exp. distr.';
     3 : CR:='Gaus. distr.';
     4 : CR:='Gaus. distr.';
    END;
   IF ((L<>0) AND (L<>5)) THEN OUTTEXTXY((2*L+1)*IK,90,CR);
  END;
 FOR L:=0 TO 2 DO
  CASE L OF
    0 : BEGIN
         FOR I:=0 TO 4 DO
          BEGIN
           CASE I OF
             0 : CR:='method';
             1 : CR:='PC-generator';
             2 : CR:='inverse transf.';
             3 : CR:='Box Muller';
             4 : CR:='Polar Mars.';
            END;
           OUTTEXTXY((2*I+1)*IK,110+L*20,CR);
          END;
        END;
    1 : OUTTEXTXY(IK,110+L*20,'x('+CHCR(1.0-ALPHA1)+')='+CHCR(QUANTIL1));
    2 : OUTTEXTXY(IK,110+L*20,'x('+CHCR(1.0-ALPHA2)+')='+CHCR(QUANTIL2));
   END;
 FOR L:=1 TO 4 DO
  BEGIN
   CR:=CHCR(KOL[L]);
   OUTTEXTXY((2*L+1)*IK,130,CR);OUTTEXTXY((2*L+1)*IK,150,CR);
  END;
END;{ SETTABLETOSCR }

{ Implements the Kolmogorov-Smirnov test                              }
{ Calculates the current test value assuming a sorted data vector X   }
{ INDEX = choice of the distribution to be tested, SIZE = sample size }

PROCEDURE KOLTEST(INDEX,SIZE:INTEGER;X:VECTOR;VAR TESTVALUE:REAL);
VAR
 J:INTEGER;     { current data index                                       }
 DISTANCE:REAL; { distance between the empirical and the test distribution }
 DN:REAL;       { maximum of these distances                               }
 F:REAL;        { value of the distribution to be tested                   }
 PJ:REAL;       { probability of the increment of two neighbouring data    }
 FNLEFT:REAL;   { left limit value of the empirical distribution           }
 FNRIGHT:REAL;  { value(=right limit value) of the empirical distribution  }
 XMIN:REAL;     { help variable for the initialization if INDEX=3 or 4     }
BEGIN
 TESTVALUE:=0.0;F:=0.0;DN:=0.0;FNRIGHT:=0.0; { initialization }
 IF ((INDEX=3) OR (INDEX=4)) THEN
  BEGIN XMIN:=-10.0;IF X[1]<XMIN THEN XMIN:=X[1]-10.0 END;
 DN:=0.0;
 J:=0; { indicates the current data }
 REPEAT
  J:=J+1;
  FNLEFT:=FNRIGHT;
  FNRIGHT:=J/SIZE; { value of the empirical distribution }
  CASE INDEX OF
     1 : F:=X[J];
     2 : F:=1-EXP(-LAMBDA*X[J]);
   3,4 : BEGIN
          IF J>1 THEN
            ROMBERG(X[J-1],X[J],PJ)
           ELSE
            ROMBERG(XMIN,X[J],PJ);
          F:=F+PJ;
         END;
    END;
  DISTANCE:=ABS(FNRIGHT-F); { current distance }
  IF DISTANCE<ABS(FNLEFT-F) THEN DISTANCE:=ABS(FNLEFT-F);
  IF DN<DISTANCE THEN DN:=DISTANCE; { maximum distance correction }
 UNTIL J=SIZE;
 TESTVALUE:=SQRT(SIZE)*DN;
END;{ KOLTEST }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Problem 1.5.3 (PC-Exercise 1.9.4)');
 STATUSLINE('Be patient! This will take the computer some time!');

 L:=0; { index of the random number generator }
 REPEAT
  L:=L+1;
  FOR I:=1 TO N DO { initializes data vector X }
   CASE L OF
     1 : X[I]:=RANDOM;
     2 : GENER02(LAMBDA,X[I]);
     3 : IF I MOD 2 = 1 THEN GENER03(X[I],U) ELSE X[I]:=U;
     4 : IF I MOD 2 = 1 THEN GENERATE(X[I],U) ELSE X[I]:=U;
    END;
  QSORT(1,N,X); { sorts the vector X }
  KOLTEST(L,N,X,KOL[L]); { calculates the current test value }
 UNTIL L=4;

{ Printout : }

 CLEARDEVICE;SETTABLETOSCR;
 CR:='Kolmogorov-Smirnov test';
 STATUSLINE(CR);

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X5X3 }