{ Shuffling of random numbers from a linear congruential generator }
{ Written by Henri Schurz, 9.10. 1991                              }

PROGRAM PRX1X5X4; { PC-Exercise 1.9.5 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE;

CONST
 N=1000;       { number of random numbers                    }
 FREQUENCY=20; { length of the shuffle vector                }
 X0=0;         { initial value of the congruential generator }
 A=1229;       { parameter of the congruential generator     }
 B=1;          { parameter of the congruential generator     }
 C=2048;       { parameter of the congruential generator     }

TYPE
 VECTOR1=ARRAY[1..FREQUENCY] OF REAL;
 VECTOR2=ARRAY[1..2*N] OF REAL;
 VECTOR3=ARRAY[0..2*N] OF LONGINT;

VAR
 CR:STRING;           { help string                                      }
 I:INTEGER;           { counter                                          }
 I1,I2:INTEGER;       { index of the shuffle vector                      }
 IY,IX,LY,LX:INTEGER; { global scaling parameters                        }
 XX:LONGINT;          { help longinteger                                 }
 QQ,Q1,Q2:REAL;       { converted longint-values                         }
 U0:REAL; { random number to get the current index of the shuffle vector }
 US1,US2:REAL;        { shuffled random numbers                          }
 UHELP:VECTOR1;       { help vector for the shuffle subroutine           }
 U:VECTOR2;           { unshuffled random numbers                        }
 X:VECTOR3;           { Xn                                               }

{ Draws two boxes on the screen and sets scaling parameters }

PROCEDURE SETBOXESAPARATOSCR;
BEGIN
 IX:=TRUNC(MAXX/9);LX:=3*IX;
 {IY:=TRUNC(IX*(MAXY/MAXX));LY:=TRUNC(LX*(MAXY/MAXX));}
 IY:=4*TEXTHEIGHT('M');;LY:=TRUNC(LX*(MAXY/(MAXX-15*TEXTHEIGHT('M'))));
 RECTANGLE(IX,IY,IX+LX,LY+IY);RECTANGLE(2*LX-IX,IY,3*LX-IX,LY+IY);
 OUTTEXTXY(IX-15,IY-5,'1');OUTTEXTXY(2*LX-IX-15,IY-5,'1');
 OUTTEXTXY(IX+LX+15,LY+IY+5,'1');OUTTEXTXY(3*LX-IX+15,LY+IY+5,'1');
 OUTTEXTXY(IX-15,LY+IY+5,'0');OUTTEXTXY(2*LX-IX-15,LY+IY+5,'0');
 OUTTEXTXY(TRUNC(6.5*IX),LY+IY+15,'with shuffling');
 OUTTEXTXY(IX+TRUNC(LX/2),LY+IY+15,'without shuffling');
END;{ SETBOXESAPARATOSCR }

{ Provides one step of the linear conqruential generator }
{ Realizes the MOD function for longint-types            }

FUNCTION MODUS(XN:LONGINT):LONGINT;
VAR
 XX:LONGINT;
BEGIN
 XX:=A*XN+B;
 WHILE XX>=C DO XX:=XX-C;
 MODUS:=XX;
END;{ MODUS }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW(''); { sets only the view port }
 STATUSLINE('The procedure works until all pixels have been generated!');
 SETBOXESAPARATOSCR; { draws boxes, sets scaling parameters }

{ Generation of the random numbers and output of the pixels on the screen : }

 QQ:=C; { converts into the real type }
 X[0]:=X0;
 I:=0;
 REPEAT
  I:=I+1;  { index of the random pair }
  X[2*I-1]:=MODUS(X[2*I-2]);X[2*I]:=MODUS(X[2*I-1]);
  Q1:=X[2*I-1];Q2:=X[2*I]; { converts into the real type              }
  U[2*I-1]:=Q1/QQ;U[2*I]:=Q2/QQ; { random numbers using the generator }
  PUTPIXEL(TRUNC(IX+U[2*I-1]*LX),TRUNC(IY+LY*(1.0-U[2*I])),MAXCOLOR);
 UNTIL I=N;

{ Shuffle subroutine and output of the pixels on the screen : }

 XX:=X[2*N]; { uses the last number generated              }
 FOR I:=1 TO FREQUENCY DO { initializes the shuffle vector }
  BEGIN XX:=MODUS(XX);Q1:=XX;UHELP[I]:=Q1/QQ; END;
 I:=0;
 REPEAT
  I:=I+1; { index of the random pair }
  XX:=MODUS(XX); { picking out one random number of the shuffle vector     }
  U0:=XX/C;I1:=TRUNC(U0*FREQUENCY+1.0); { index of the first number picked }
  US1:=UHELP[I1];      { picks the random number     }
  UHELP[I1]:=U[2*I-1]; { prepares the shuffle vector }
  XX:=MODUS(XX); { picking out one random number of the shuffle vector      }
  U0:=XX/C;I2:=TRUNC(U0*FREQUENCY+1.0); { index of the second number picked }
  UHELP[I2]:=U[2*I]; { prepares the shuffle vector }
  US2:=UHELP[I2];    { picks the random number     }
  PUTPIXEL(TRUNC(5*IX+US1*LX),TRUNC(IY+LY*(1.0-US2)),MAXCOLOR);
 UNTIL I=N;

 CR:='Shuffling of random numbers with : ';
 STATUSLINE(CR+'X0='+CHCR(X0)+'/A='+CHCR(A)+'/B='+CHCR(B)+'/C='+CHCR(C));

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X5X4 }