{ Simulation of a discrete time Markov chain                   }
{ Population distribution of a city with two districts E and W }
{ Written by Henri Schurz, 9.10. 1991                          }

PROGRAM PRX1X6X1; { PC-Exerxise 1.6.5 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
 N=1000; { number of transitions                                        }
 M=100;  { sample size                                                  }
 A=0.1;  { parameter a in the transition matrix                         }
 B=0.01; { parameter b in the transition matrix                         }
 P1=1.0; { initial probability to reside in E for the first simulation  }
 P2=1.0; { initial probability to reside in W for the second simulation }

TYPE
 MATRIX=ARRAY[1..2,1..2] OF REAL;

VAR
 CR:STRING;     { help string                                 }
 I1,I2:INTEGER; { graphic parameters                          }
 I,K,L:INTEGER; { counters                                    }
 U:REAL;        { help variable                               }
 PE,PW:REAL;    { probabilities to reside in E and W          }
 P:MATRIX;      { transition matrix                           }
 XT:REAL;       { value of the trajectory of the Markov chain }

{ Prepares the screen for the printout }

PROCEDURE SETTABLETOSCR;
VAR
 CR,CS,CT:STRING;
 I:INTEGER;
BEGIN
 LINE(0,80,MAXX-2,80);LINE(0,100,MAXX-2,100);LINE(0,80,0,140);
 LINE(0,120,MAXX-2,120);LINE(0,140,MAXX-2,140);LINE(MAXX-2,80,MAXX-2,140);
 I1:=TRUNC((MAXX-2)/12);I2:=2*I1;
 CR:='Estimated probabilities of person`s residing in E and W';
 CS:='after  n = '+CHCR(N)+' years and one further transition : ';
 OUTTEXTXY(3*I2,30,CR);OUTTEXTXY(3*I2,50,CS);
 FOR I:=0 TO 5 DO
  BEGIN
   IF I<5 THEN LINE((I+1)*I2,80,(I+1)*I2,140);
   CASE I OF
     0 : BEGIN CR:='P(0)(E)';CS:=CHCR(P1);CT:=CHCR(1-P2);END;
     1 : BEGIN CR:='P(0)(W)';CS:=CHCR(1-P1);CT:=CHCR(P2);END;
     2 : BEGIN CR:='P(n)(E)';CS:='';CT:='';END;
     3 : BEGIN CR:='P(n)(W)';CS:='';CT:='';END;
     4 : BEGIN CR:='P(n+1)(E)';CS:='';CT:=CS;END;
     5 : BEGIN CR:='P(n+1)(W)';CS:='';CT:=CS;END;
    END;
   OUTTEXTXY(I1+I*I2,90,CR);OUTTEXTXY(I1+I*I2,110,CS);
   OUTTEXTXY(I1+I*I2,130,CT);
  END;
 STATUSLINE('Be patient! This will take the computer some time!');
END;{ SETTABLETOSCR }

{ Sets data on the screen }

PROCEDURE SETDATATOSCR(COLUMN:INTEGER;DATA:REAL);
BEGIN
 OUTTEXTXY(I1+COLUMN*I2,90+K*20,CHCR(DATA));
END;{ SETDATATOSCR }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Problem 1.6.1 (PC-Exercise 1.6.5)');
 STATUSLINE('Be patient! This will take the computer some time!');

 P[1,1]:=1.0-A;P[1,2]:=A; { transition probabilities }
 P[2,1]:=B;P[2,2]:=1.0-B;
 K:=0;
 REPEAT
  K:=K+1; { simulation number }
  PE:=0.0;PW:=0.0;
  L:=0;
  REPEAT
   L:=L+1; { sample index }
   CASE K OF
     1 : U:=P1;
     2 : U:=1.0-P2;
    END;
   GENER01(U,0,1,XT); { generates the initial state }
   I:=0;
   REPEAT
    I:=I+1; { number of transitions }
    IF TRUNC(XT)=0 THEN GENER01(P[1,1],0,1,XT)
     ELSE GENER01(P[2,1],0,1,XT); { generates the current state }
   UNTIL I=N;
   PE:=PE+1-XT;PW:=PW+XT;
  UNTIL L=M;
  PE:=PE/M;PW:=PW/M;
  IF K=1 THEN BEGIN CLEARDEVICE;SETTABLETOSCR; END;
  SETDATATOSCR(2,PE);SETDATATOSCR(3,PW);
  U:=PE;
  PE:=P[1,1]*U+P[2,1]*PW; { one further transition }
  PW:=P[1,2]*U+P[2,2]*PW;
  SETDATATOSCR(4,PE);SETDATATOSCR(5,PW);
 UNTIL K=2;

 CR:='Empirical population distribution of residing in the two districts';
 CR:=CR+' E and W';
 STATUSLINE(CR);

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X6X1 }