{ Ergodicity of a discrete time Markov chain                                }
{ Calculates the probabilities person`s residing in districts E and W for   }
{ different initial probabilities after having T years of transitions       }
{ Plots a table on the screen to compare the estimate of the long-term time }
{ averages with the spatial averages with respect to the stationary distri- }
{ bution                                                                    }
{ Written by Henri Schurz, 9.10. 1991                                       }

PROGRAM PRX1X6X2; { PC-Exerxise 1.6.7 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
 T=1000; { number of years = number of transitions }
 A=0.1;  { parameter a in the transition matrix    }
 B=0.01; { parameter b in the transition matrix    }

TYPE
 VECTOR=ARRAY[1..12] OF REAL;
 VECTOR1=ARRAY[1..4] OF REAL;
 MATRIX=ARRAY[1..2,1..2] OF REAL;

VAR
 CR:STRING;        { help string                                   }
 I,K,L:INTEGER;    { counters                                      }
 I1,I2,I3:INTEGER; { graphic parameters                            }
 U:REAL;           { help variable                                 }
 LIMFXT:REAL;      { estimate of the long-time average             }
 PE,PW:REAL;       { probabilities of person`s residing in E and W }
 XT:REAL;          { current realization of the Markov chain       }
 P0:VECTOR;        { initial probabilities                         }
 P:MATRIX;         { transition matrix                             }
 FE,FW:VECTOR1;    { function values of f used for the averaging   }

{ Initializes data and prints out a data table on the screen }

PROCEDURE INITDATAAPRINT;
VAR
 CR:STRING;
BEGIN
 I1:=TRUNC(MAXX/12);I2:=2*I1;I3:=TRUNC((MAXY-2*TEXTHEIGHT('M')-30)/13);
 CASE L OF
   1 : BEGIN FE[L]:=0;FW[L]:=1; END;
   2 : BEGIN FE[L]:=1;FW[L]:=0; END;
   3 : BEGIN FE[L]:=1;FW[L]:=-1; END;
   4 : BEGIN FE[L]:=-1;FW[L]:=1; END;
  END;
 CR:='Long-time averages and spatial averages w.r.t. the stationary';
 CR:=CR+' distribution';
 MAINWINDOW(CR); { sets the window and displays the top line }
 FOR I:=0 TO 12 DO
  LINE(0,TEXTHEIGHT('M')+15+I*I3,MAXX,TEXTHEIGHT('M')+15+I*I3);
 OUTTEXTXY(I2,TEXTHEIGHT('M'),'T = '+CHCR(T));
 FOR I:=1 TO 5 DO LINE(I*I2,TEXTHEIGHT('M')+15,I*I2,TEXTHEIGHT('M')+15+13*I3);
 U:=-0.2;
 FOR K:=0 TO 12 DO
  BEGIN
   IF K<12 THEN U:=U+0.1 ELSE U:=1/11;
   IF K>0 THEN BEGIN P0[K]:=U;PE:=P0[K];PW:=1-PE; END;
   FOR I:=0 TO 5 DO
    BEGIN
     CASE K OF
       0 : CASE I OF
             0 : CR:='P(E)';
             1 : CR:='P(W)';
             2 : CR:='F(E)';
             3 : CR:='F(W)';
             4 : CR:='time average';
             5 : CR:='(F,p#)';
            END;
      1..12 : CASE I OF
                0 : CR:=CHCR(PE);
                1 : CR:=CHCR(PW);
                2 : CR:=CHCR(FE[L]);
                3 : CR:=CHCR(FW[L]);
                4 : CR:='';
                5 : CR:=CHCR(FE[L]*B/(A+B)+FW[L]*A/(A+B));
               END;
      END;
     OUTTEXTXY(I1+I*I2,TRUNC(TEXTHEIGHT('M')+15+(2*K+1)*I3/2),CR);
    END;
  END;
END;{ INITDATAAPRINT }

{ Sets the current estimate of the long-term time average on the screen }

PROCEDURE SETDATATOSCR;
BEGIN
 OUTTEXTXY(I1+4*I2,TRUNC(TEXTHEIGHT('M')+15+(2*K+1)*I3/2),CHCR(LIMFXT));
END;{ SETDATATOSCR }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Problem 1.6.2 (PC-Exercise 1.6.7)');
 STATUSLINE('Be patient! This will take the computer some time!');

 P[1,1]:=1-A;P[1,2]:=A; { initialization of transition probabilities }
 P[2,1]:=B;P[2,2]:=1-B;
 L:=0;
 REPEAT
  L:=L+1; { index of the function values of f(X(t)) used }
  INITDATAAPRINT; { generates the values of f(X(t)) and prints out a table }
  K:=0;
  REPEAT
   K:=K+1; { index of the initial probabilities used }
   PE:=P0[K];PW:=1-PE; { sets the initial probabilities }
   GENER01(PE,0,1,XT); { generates the realization of the Markov chain }
   I:=0;
   LIMFXT:=0.0; { initializes the estimate of the long-term time average }
   REPEAT
    I:=I+1; { counter of the transitions }
    LIMFXT:=LIMFXT+(1-XT)*FE[L]+XT*FW[L]; { corrects the long-term average }
    IF XT=0 THEN GENER01(P[1,1],0,1,XT) { generates the next transition }
     ELSE GENER01(P[2,1],0,1,XT);
   UNTIL I=T;
   LIMFXT:=LIMFXT/T;
   SETDATATOSCR; { prints out the current estimate of the long-term average }
  UNTIL K=12;

  CR:='Ergodicity of the Markov chain (Press any ';
  CR:=CR+'key to continue, <ESC> to end)';STATUSLINE(CR);

 { Stop : }

  WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
            { ! <ESC> terminates the program           }

 UNTIL L=4;

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X6X2 }