{ Telegraphic noise                        }
{ Generates a continuous time Markov chain }
{ Written by Henri Schurz, 9.10. 1991      }

PROGRAM PRX1X6X3; { PC-Exerxise 1.6.9 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
 N=100;    { number of simulations                           }
 T=10;     { endpoint of the time interval starting at zero  }
 A11=-0.5; { intensity parameter                             }
 A12=+0.5; { intensity parameter                             }
 A21=+0.5; { intensity parameter                             }
 A22=-0.5; { intensity parameter                             }
 PROB=0.5; { initial probability of starting in the state +1 }

TYPE
 VECTOR=ARRAY[1..2] OF REAL;

VAR
 CR:STRING;      { help string                                  }
 I:INTEGER;      { counter                                      }
 FREQUENCY:REAL; { frequency of being in the state +1 at time T }
 DT:REAL;        { exponentially distributed waiting time       }
 TI:REAL;        { time of the transition to the other state    }
 XT:REAL;        { current state                                }
 P0:VECTOR;      { initial probabilities                        }

{ Clears the screen and sets the data string on it }

PROCEDURE SETTEXTTOSCR;
VAR
 I1,I2,I3:INTEGER;
BEGIN
 I1:=TRUNC(MAXX/2);I3:=2*TEXTHEIGHT('M');I2:=TRUNC(MAXY/2-4*I3);CLEARDEVICE;
 CR:='Estimated relative frequency of being in the state +1';
 OUTTEXTXY(I1,I2,CR);I2:=I2+I3;
 CR:='at the time T = '+CHCR(T)+' is f = '+CHCR(FREQUENCY);
 OUTTEXTXY(I1,I2,CR);I2:=I2+2*I3;
 CR:='for n = '+CHCR(N)+' simulations';OUTTEXTXY(I1,I2,CR);I2:=I2+I3;
 CR:='with the intensity parameters a11 = '+CHCR(A11)+' , a12 = ';
 CR:=CR+CHCR(A12)+',';OUTTEXTXY(I1,I2,CR);I2:=I2+I3;
 CR:=' a21 = '+CHCR(A21)+' and a22 = '+CHCR(A22);
 OUTTEXTXY(I1,I2,CR);I2:=I2+I3;
 CR:='starting with the intial probability p(0) = ';
 CR:=CR+CHCR(PROB)+' that X(0) = +1';OUTTEXTXY(I1,I2,CR);
END;{ SETTEXTTOSCR }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Problem 1.6.3 (PC-Exercise 1.6.9)');
 STATUSLINE('Be patient! This will take the computer some time!');

 P0[1]:=PROB;P0[2]:=1.0-PROB; { sets the initial probabilities }
 I:=0;
 FREQUENCY:=0.0;
 REPEAT
  I:=I+1; { counts the number of simulations }
  GENER01(P0[1],1,-1,XT); { generates the starting state }
  TI:=0.0; { current time }
  REPEAT
   IF XT=1.0 THEN GENER02(A12,DT) ELSE GENER02(A21,DT); { exp. waiting time }
   TI:=TI+DT; { adds the current waiting time of the corresponding state    }
   IF (T-TI)>=0 THEN XT:=-XT; { transition to the new state                 }
  UNTIL TI>=T;
  IF XT=1.0 THEN FREQUENCY:=FREQUENCY+1.0; { corrects the frequency }
 UNTIL I=N;
 FREQUENCY:=FREQUENCY/N; { relative frequency }

 SETTEXTTOSCR; { sets the data string including the frequency on the screen }
 CR:='Simulation of telegraphic noise on the time interval';
 CR:=CR+' [0,'+CHCR(T)+']';
 STATUSLINE(CR);

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X6X3 }