{ Simulation of trajectories of the standard Wiener process  X(t) = W(t) }
{ with  X(0) = 0  using the Polar Marsaglia method to generate Gaussian  }
{ random numbers                                                         }
{ Written by Henri Schurz, 9.10. 1991                                    }

PROGRAM PRX1X7X1; { PC-Exercise 2.4.4 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
  T0=0.0;              { left end point                             }
  T=1.0;               { right end point                            }
  DELTA=(T-T0)/NUMINV; { minimum step size w.r.t. screen resolution }
  X0=0.0;              { initial value of the trajectory            }

VAR
 K:INTEGER;       { counter                          }
 TK:REAL;         { subinterval point                }
 SQDELTA:REAL;    { sqrt of the step size            }
 U1,U2:REAL;      { random number                    }
 WT:REAL;         { current value of the trajectory  }
 XT:VECTOR;       { values of the trajectory         }
 ABSCISSA:VECTOR; { values of the subinterval points }

{ Main program : }

BEGIN

 INITIALIZE;  { standard initialization }
 MAINWINDOW(''); { sets a view port     }

{ Generation of data : }

 SQDELTA:=SQRT(DELTA);
 U2:=0.0;WT:=0.0;
 TK:=T0-DELTA;
 K:=-1;
 REPEAT
  K:=K+1;          { counter              }
  TK:=TK+DELTA;    { time                 }
  ABSCISSA[K]:=TK; { values of the x-axis }
  IF K MOD 2 =1 THEN GENERATE(U1,U2) ELSE U1:=U2; { uses Polar Marsaglia }
  WT:=WT+U1*SQDELTA; { current value of the Wiener trajectory }
  XT[K]:=WT;         { values of the y-axis                   }
 UNTIL K=NUMINV;

{ Plots the graph of the density function using AAGRAPHS routine }
{ ! Scaling of the x-axis is done in powers of 2                 }
{ ! Scaling of the y-axis corresponds to the extremas of data    }

 GRAPH111(XT,ABSCISSA,'W(t)','t','');

 STATUSLINE('Trajectory of the Wiener process W = {W(t),t>=0}');

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X7X1 }