{ Simulates a trajectory of the truncated Karhunen-Loeve expansion of the  }
{ standard Wiener process W(t)                                             }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers      }
{ Written by Henri Schurz, 9.10.1991                                       }
{ Note : For a correct printout of the paths one has to choose the scaling }
{        parameter carefully.                                              }

PROGRAM PRX1X7X5; { PC-Exercise 2.4.2 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
 T=1.0;          { interval end                     }
 NUMBER=64;      { number of time steps             }
 DELTA=T/NUMBER; { time step size                   }
 K=50;           { number of random coefficients Zn }
 ABSCMIN=0.0;    { left end point                   }
 ABSCMAX=T;      { right end point                  }
 ORDMIN=-2.0;    { minimum of the ordinate          }
 ORDMAX=+2.0;    { maximum of the ordinate          }
 ORDPOINT=0.0;   { significant ordinate point       }

TYPE
 VECTOR=ARRAY[0..NUMBER] OF REAL;
 VECTOR1=ARRAY[0..K-1] OF REAL;

VAR
 CR:STRING;           { help string                            }
 I:INTEGER;           { counter                                }
 AXISX,AXISY:INTEGER; { location of the axes                   }
 DISTX,DISTY:INTEGER; { scale parameters                       }
 N:INTEGER;           { summation index                        }
 U:REAL;              { random number                          }
 TI:REAL;             { time step                              }
 XT:REAL;             { current value of the trajectory        }
 Z:VECTOR1;           { random coefficients Zn                 }
 KL50T:VECTOR;        { values of the Karhunen-Loeve expansion }
 ABSCISSA:VECTOR;     { subinterval points                     }

{ Prepares the screen for the printout                           }
{ X-axis is placed in the center; CY,CX ... strings for the axes }

PROCEDURE COORDSYS(CY,CX:STRING);
VAR
 FACTOR,I0,I1,I2,IH,K:INTEGER;
 DX,DY:REAL;
BEGIN
 IH:=TEXTHEIGHT('M')+10;
 AXISX:=TRUNC(MAXY/2);
 I0:=TEXTWIDTH(CHCR(ORDMAX))+7;I1:=TEXTWIDTH(CHCR(ORDMIN))+7;
 I2:=TEXTWIDTH(CHCR(ORDPOINT))+7;IF I0<I1 THEN I0:=I1;
 IF I0<I2 THEN I0:=I2;I1:=TRUNC(MAXX/10);
 IF I0>MAXX-NUMINV-40 THEN I0:=MAXX-NUMINV-40;
 IF I0<I1 THEN AXISY:=I1 ELSE AXISY:=I0;
 DISTX:=NUMINV;DISTY:=AXISX-2*IH-20;
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY,AXISX-DISTY-IH,'^');OUTTEXTXY(AXISY,AXISX-DISTY-2*IH,CY);
 LINE(AXISY,AXISX-DISTY-IH,AXISY,AXISX+DISTY+IH);
 LINE(AXISY-5,AXISX,AXISY+30+DISTX,AXISX);
 SETTEXTJUSTIFY(2,1);I0:=AXISX-DISTY;
 LINE(AXISY-3,AXISX-DISTY,AXISY+3,AXISX-DISTY);OUTTEXTXY(AXISY-7,I0,CHCR(ORDMAX));
 DY:=(ORDPOINT-ORDMIN)/(ORDMAX-ORDMIN);I0:=AXISX+TRUNC((0.5-DY)*2.0*DISTY);
 LINE(AXISY-3,I0,AXISY+3,I0);OUTTEXTXY(AXISY-7,I0,CHCR(ORDPOINT));
 LINE(AXISY-3,AXISX+DISTY,AXISY+3,AXISX+DISTY);
 OUTTEXTXY(AXISY-7,AXISX+DISTY,CHCR(ORDMIN));
 SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY+30+DISTX,AXISX+1,'>');OUTTEXTXY(AXISY+30+DISTX,AXISX+10,CX);
 IF ((ABSCMAX-ABSCMIN=2.0) OR (ABSCMAX+ABSCMIN=0.0)) THEN FACTOR:=2 ELSE
  IF ABSCMAX-ABSCMIN=3.0 THEN FACTOR:=3 ELSE
   IF ABSCMAX-ABSCMIN=4.0 THEN FACTOR:=4 ELSE
    IF ((ABSCMAX-ABSCMIN=5.0) OR ((ABSCMAX-ABSCMIN=1.0) AND (ABSCMIN=0.0)))
     THEN FACTOR:=5 ELSE FACTOR:=1;
 DX:=(ABSCMAX-ABSCMIN)/FACTOR;
 FOR K:=1 TO FACTOR DO
  BEGIN
   I1:=AXISY+TRUNC(K*DISTX/FACTOR+0.5);I2:=AXISX+15;
   LINE(I1,AXISX+3,I1,AXISX-3);
   OUTTEXTXY(I1,I2,CHCR(ABSCMIN+K*DX));
  END;
END;{ COORDSYS }

{ Plots the trajectory of the Karhunen-Loeve expansion on the screen     }
{ assuming COORDSYS was called before and x-axis is placed in the screen }
{ center; N0,NN = indices of the first and last data picked              }
{ LTN = line thickness                                                   }

PROCEDURE PLOTGRAPH(LTN,N0,NN:INTEGER;ORDINATE,ABSCISSA:VECTOR);
VAR
 IL,IR,IHL,IHR:INTEGER; { screen coordinates                      }
 I:INTEGER;             { data index                              }
 HALFORD:REAL;          { corresponds to the height of the x-axis }
 FACTORX,FACTORY:REAL;  { scaling parameters                      }
BEGIN
 SETLINESTYLE(0,0,LTN);
 FACTORX:=DISTX/(ABSCMAX-ABSCMIN);HALFORD:=(ORDMAX+ORDMIN)/2;
 FACTORY:=DISTY/(ORDMAX-HALFORD);
 IR:=AXISY+TRUNC((ABSCISSA[N0]-ABSCMIN)*FACTORX);
 IHR:=AXISX-TRUNC((ORDINATE[N0]-HALFORD)*FACTORY);
 I:=N0;
 REPEAT
  I:=I+1;
  IL:=IR;IHL:=IHR;
  IR:=AXISY+TRUNC((ABSCISSA[I]-ABSCMIN)*FACTORX);
  IHR:=AXISX-TRUNC((ORDINATE[I]-HALFORD)*FACTORY);
  LINE(IL,IHL,IR,IHR);
 UNTIL I=NN;
 SETLINESTYLE(0,0,1);
END;{ PLOTGRAPH }

{ Provides the value of the nth nonrandom function                  }
{ fi(n)(t) = 2*SQRT(2*T)/((2*n+1)*Pi)*SIN((2*n+1)*Pi*t/(2*T))   }

FUNCTION FI(NN:INTEGER;TI:REAL):REAL;
BEGIN
 FI:=2*SQRT(2*T)/((2*NN+1)*PI)*SIN((2*NN+1)*PI*TI/(2*T));
END;{ FI }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Problem 1.7.5 (PC-Exercise 2.4.2)');
 STATUSLINE('Be patient! This will take the computer some time.');

{ Generation of the Karhunen-Loeve expansion : }

 FOR N:=1 TO K DO { generates the values of Zn }
  IF N MOD 2 = 1 THEN GENERATE(Z[N-1],U) ELSE Z[N-1]:=U;
 TI:=-DELTA;
 I:=-1;
 REPEAT
  I:=I+1;
  TI:=TI+DELTA; { time }
  XT:=0.0;
  N:=-1;
  REPEAT { calculates the current value of the Karhunen-Loeve expansion }
   N:=N+1;
   XT:=XT+Z[N]*FI(N,TI);
  UNTIL N=K-1;
  KL50T[I]:=XT;
  ABSCISSA[I]:=TI;
 UNTIL I=NUMBER;

{ Printout : }

 CLEARDEVICE;
 COORDSYS('KL'+CHCR(K)+'(t)','t');     { draws the coordinate system        }
 PLOTGRAPH(1,0,NUMBER,KL50T,ABSCISSA); { plots the Karhunen-Loeve expansion }
 STATUSLINE('Truncated Karhunen-Loeve expansion of the Wiener process W(t)');

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X7X5 }