{ Simulation of paths of the Brownian bridge B(x)(y)(t) with          }
{ B(x)(y)(0) = x and B(x)(y)(T) = y  on a given time interval [0,T]   }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers }
{ Written by Henri Schurz, 9.10. 1991                                 }

PROGRAM PRX1X7X6;

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 T=1.0;          { right end point                            }
 DELTA=T/NUMINV; { minimum step size w.r.t. screen resolution }
 X=0.0;          { initial value of the trajectory            }
 Y=0.0;          { end value of the trajectory                }

VAR
 CR:STRING;       { help string                              }
 K:INTEGER;       { counter                                  }
 TK:REAL;         { subinterval point                        }
 SQDELTA:REAL;    { sqrt of the step size                    }
 U,U1,U2:REAL;    { random numbers                           }
 WT:VECTOR;       { values of the Wiener trajectory          }
 BXYT:VECTOR;     { values of the Brownian bridge trajectory }
 ABSCISSA:VECTOR; { values of the subinterval points         }

{ Main program : }

BEGIN

 INITIALIZE;  { standard initialization }
 MAINWINDOW(''); { sets a view port     }

{ Generation of the Wiener trajectory : }

 SQDELTA:=SQRT(DELTA);
 WT[0]:=0.0;U:=0.0;
 K:=0;
 REPEAT
  K:=K+1; { counter }
  IF K MOD 2 =1 THEN GENERATE(U1,U2) ELSE U1:=U2; { uses Polar Marsaglia }
  U:=U+U1;
  WT[K]:=U*SQDELTA; { value of the Wiener trajectory }
 UNTIL K=NUMINV;

{ Generation of the Brownian bridge trajectory and the abscissa data : }

 TK:=0.0-DELTA;
 K:=-1;
 REPEAT
  K:=K+1;       { counter }
  TK:=TK+DELTA; { time    }
  BXYT[K]:=X+WT[K]-(TK/T)*(WT[NUMINV]-Y+X); { value of the Brownian bridge }
  ABSCISSA[K]:=TK; { value of the X-axis }
 UNTIL K=NUMINV;

{ Plots the path of the Brownian using AAGRAPHS routine       }
{ ! Scaling of the x-axis is done in powers of 2              }
{ ! Scaling of the y-axis corresponds to the extremas of data }

 GRAPH111(BXYT,ABSCISSA,'B(x)(y)(t)','t','');

 CR:='Trajectory of the Brownian bridge B(x)(y)(t) on the time interval';
 CR:=CR+' [0,'+CHCR(T)+']';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X7X6 }