{ Simulation of paths of the Brownian bridge B(x)(y)(t) with B(x)(y)(0) = x }
{ and B(x)(y)(T) = y modified by the random walk on the time interval [0,T] }
{ Uses the random walk  S(N)(tk) = (X1+X2+...+Xk)*sqrt(delta)  with         }
{ S(N)(t) = S(N)(tk) + ((t-tk)/delta)*(S(N)(tk+1)-S(N)(tk))  on the sub-    }
{ interval  tk <= t < tk+1  for k = 0,1,...,N-1  where S(N)(0) = 0          }
{ Xk are i.i.d. random variables taking the values +1 and -1                }
{ Starts with N=10 and repeats it for N = 20,30,...,100                     }
{ Compares the sample paths of B(x)(y)(t) generated by S(100)(t) and the    }
{ restructured S(50)(t)                                                     }
{ Written by Henri Schurz, 9.10.1991                                        }
{ Note : For a correct printout of the paths one has to choose the scaling  }
{        parameter carefully.                                               }

PROGRAM PRX1X7X7; { PC-Exercise 1.8.8 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
 NUMBER=100;   { maximum number of random variables (NUMBER MOD 10 = 0) }
 P=0.5;        { probability that Xk = X1                               }
 X1=-1.0;      { first value of the two-point distributed Xk            }
 X2=+1.0;      { second value of the two-point distributed Xk           }
 X=0.0;        { left end point of the Brownian bridge B(x)(y)(t)       }
 Y=0.0;        { right end point of the Brownian bridge B(x)(y)(t)      }
 T=1.0;        { interval end                                           }
 ABSCMIN=0.0;  { left end point                                         }
 ABSCMAX=T;    { right end point                                        }
 ORDMIN=-2.0;  { minimum of the ordinate                                }
 ORDMAX=+2.0;  { maximum of the ordinate                                }
 ORDPOINT=0.0; { significant ordinate point                             }

TYPE
 VECTOR=ARRAY[0..NUMBER] OF REAL;

VAR
 CR:STRING;           { help string                                 }
 K:INTEGER;           { counter                                     }
 AXISX,AXISY:INTEGER; { location of the axes                        }
 DISTX,DISTY:INTEGER; { scale parameters                            }
 N:INTEGER;           { number of time steps                        }
 DELTA:REAL;          { time step size                              }
 SQDELTA:REAL;        { sqrt of the time step size                  }
 TK:REAL;             { subinterval end                             }
 XT:VECTOR;           { two-point distributed random numbers        }
 SK:REAL;             { value of the random walk S(N)(tk+1)         }
 SNT:VECTOR;          { values of the random walk                   }
 S50T:VECTOR;         { values of the restructured S50(t)           }
 BXYT:VECTOR;         { values of the Brownian bridge B(x)(y)(t)    }
 B50XYT:VECTOR;       { B(x)(y)(t) generated by S50(t) restructured }
 ABSCISSA:VECTOR;     { subinterval points                          }

{ Prepares the screen for the printout of the path of the Brownian bridge }
{ X-axis is placed in the center; CY,CX ... strings for the axes          }

PROCEDURE COORDSYS(CY,CX:STRING);
VAR
 FACTOR,I0,I1,I2,IH,K:INTEGER;
 DX,DY:REAL;
BEGIN
 IH:=TEXTHEIGHT('M')+10;
 AXISX:=TRUNC(MAXY/2);
 I0:=TEXTWIDTH(CHCR(ORDMAX))+7;I1:=TEXTWIDTH(CHCR(ORDMIN))+7;
 I2:=TEXTWIDTH(CHCR(ORDPOINT))+7;IF I0<I1 THEN I0:=I1;
 IF I0<I2 THEN I0:=I2;I1:=TRUNC(MAXX/10);
 IF I0>MAXX-NUMINV-40 THEN I0:=MAXX-NUMINV-40;
 IF I0<I1 THEN AXISY:=I1 ELSE AXISY:=I0;
 DISTX:=NUMINV;DISTY:=AXISX-2*IH-20;
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY,AXISX-DISTY-IH,'^');OUTTEXTXY(AXISY,AXISX-DISTY-2*IH,CY);
 LINE(AXISY,AXISX-DISTY-IH,AXISY,AXISX+DISTY+IH);
 LINE(AXISY-5,AXISX,AXISY+30+DISTX,AXISX);
 SETTEXTJUSTIFY(2,1);I0:=AXISX-DISTY;
 LINE(AXISY-3,AXISX-DISTY,AXISY+3,AXISX-DISTY);OUTTEXTXY(AXISY-7,I0,CHCR(ORDMAX));
 DY:=(ORDPOINT-ORDMIN)/(ORDMAX-ORDMIN);I0:=AXISX+TRUNC((0.5-DY)*2.0*DISTY);
 LINE(AXISY-3,I0,AXISY+3,I0);OUTTEXTXY(AXISY-7,I0,CHCR(ORDPOINT));
 LINE(AXISY-3,AXISX+DISTY,AXISY+3,AXISX+DISTY);
 OUTTEXTXY(AXISY-7,AXISX+DISTY,CHCR(ORDMIN));
 SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY+30+DISTX,AXISX+1,'>');OUTTEXTXY(AXISY+30+DISTX,AXISX+10,CX);
 IF ((ABSCMAX-ABSCMIN=2.0) OR (ABSCMAX+ABSCMIN=0.0)) THEN FACTOR:=2 ELSE
  IF ABSCMAX-ABSCMIN=3.0 THEN FACTOR:=3 ELSE
   IF ABSCMAX-ABSCMIN=4.0 THEN FACTOR:=4 ELSE
    IF ((ABSCMAX-ABSCMIN=5.0) OR ((ABSCMAX-ABSCMIN=1.0) AND (ABSCMIN=0.0)))
     THEN FACTOR:=5 ELSE FACTOR:=1;
 DX:=(ABSCMAX-ABSCMIN)/FACTOR;
 FOR K:=1 TO FACTOR DO
  BEGIN
   I1:=AXISY+TRUNC(K*DISTX/FACTOR+0.5);I2:=AXISX+15;
   LINE(I1,AXISX+3,I1,AXISX-3);
   OUTTEXTXY(I1,I2,CHCR(ABSCMIN+K*DX));
  END;
END;{ COORDSYS }

{ Plots the trajectory of the Brownian bridge on the screen assuming   }
{ COORDSYS was called before and x-axis is placed in the screen center }
{ N0,NN = indices of the first and last data picked                    }
{ LTN = line thickness                                                 }

PROCEDURE PLOTGRAPH(LTN,N0,NN:INTEGER;ORDINATE,ABSCISSA:VECTOR);
VAR
 IL,IR,IHL,IHR:INTEGER; { screen coordinates                      }
 I:INTEGER;             { data index                              }
 HALFORD:REAL;          { corresponds to the height of the x-axis }
 FACTORX,FACTORY:REAL;  { scaling parameters                      }
BEGIN
 SETLINESTYLE(0,0,LTN);
 FACTORX:=DISTX/(ABSCMAX-ABSCMIN);HALFORD:=(ORDMAX+ORDMIN)/2;
 FACTORY:=DISTY/(ORDMAX-HALFORD);
 IR:=AXISY+TRUNC((ABSCISSA[N0]-ABSCMIN)*FACTORX);
 IHR:=AXISX-TRUNC((ORDINATE[N0]-HALFORD)*FACTORY);
 I:=N0;
 REPEAT
  I:=I+1;
  IL:=IR;IHL:=IHR;
  IR:=AXISY+TRUNC((ABSCISSA[I]-ABSCMIN)*FACTORX);
  IHR:=AXISX-TRUNC((ORDINATE[I]-HALFORD)*FACTORY);
  LINE(IL,IHL,IR,IHR);
 UNTIL I=NN;
 SETLINESTYLE(0,0,1);
END;{ PLOTGRAPH }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Problem 1.7.7 (PC-Exercise 1.8.8)');
 STATUSLINE('Be patient! This will take the computer some time.');

 N:=0;
 REPEAT { repeats for different parameters N }
  N:=N+10;

 { Generation of the random walk : }

  DELTA:=(ABSCMAX-ABSCMIN)/N;SQDELTA:=SQRT(DELTA);
  SK:=0.0;SNT[0]:=0.0;
  K:=0;
  REPEAT
   K:=K+1;
   GENER01(P,X1,X2,XT[K]);
   SK:=SK+XT[K];
   SNT[K]:=SK*SQDELTA;
  UNTIL K=N;

 { Generation of the Brownian bridge using the path of the random walk : }

  TK:=ABSCMIN-DELTA;
  K:=-1;
  REPEAT
   K:=K+1;       { counter }
   TK:=TK+DELTA; { time    }
   BXYT[K]:=X+SNT[K]-(TK/T)*(SNT[N]-Y+X); { value of the Brownian bridge }
   ABSCISSA[K]:=TK; { value of the X-axis }
  UNTIL K=N;

 { Printout : }

  CLEARDEVICE;
  COORDSYS('B(x)(y)(t)','t'); { draws the coordinate system }
  PLOTGRAPH(1,0,N,BXYT,ABSCISSA); { plots the trajectory    }
  CR:='Trajectory of the Brownian brigde modified by the';
  CR:=CR+' random walk(N='+CHCR(N)+')';
  STATUSLINE(CR);

 { Stop : }

  WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
            { ! <ESC> terminates the program           }

 UNTIL N=NUMBER;

{ Calculation of B(x)(y)(t) generated by S50(t) restructured : }

 N:=TRUNC(NUMBER/2.0+0.1);
 DELTA:=(ABSCMAX-ABSCMIN)/N;SQDELTA:=SQRT(DELTA);
 SK:=0.0;S50T[0]:=0.0;
 K:=0;
 REPEAT { calculates S(50)(t) w.r.t. the last 100 random numbers Xk }
  K:=K+1;
  SK:=SK+XT[2*K-1]+XT[2*K];
  S50T[K]:=SK*SQDELTA;
 UNTIL K=N;
 TK:=ABSCMIN-DELTA;
 K:=-1;
 REPEAT
  K:=K+1;       { counter }
  TK:=TK+DELTA; { time    }
  B50XYT[K]:=X+S50T[K]-(TK/T)*(S50T[N]-Y+X); { value of the Brownian bridge }
  ABSCISSA[K]:=TK; { value of the X-axis }
 UNTIL K=N;

{ Printout in the last graphic : }

 PLOTGRAPH(3,0,N,B50XYT,ABSCISSA); { plots the trajectory }
 CR:='Trajectories of the Brownian Bridge using S'+CHCR(N)+'T(t){thick} and ';
 CR:=CR+'S'+CHCR(2*N)+'T(t)';
 STATUSLINE(CR);

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX1X7X7 }