{ Simulation of trajectories of the stochastic Ito integrals X(t) satis- }
{ fying the stochastic differential equation dX(t,w) = W(t,w) dW(t,w) on }
{ the time interval [T0,T] starting at X(T0) = X0                        }
{ Approximation of X(t) by Ito sums with the time step size DELTA        }
{ Plots the linearly interpolated trajectories of X(t) and its approxi-  }
{ mation by the corresponding Ito sum in the same graphic table          }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers    }
{ Written by Henri Schurz, 9.10. 1991                                    }

PROGRAM PRX2X1X1;

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
 N=100;          { number of time steps            }
 T0=0.0;         { left end point                  }
 T=1.0;          { right end point                 }
 DELTA=(T-T0)/N; { time step size                  }
 X0=0.0;         { initial value of the trajectory }
 ABSCMIN=T0;     { left end point                  }
 ABSCMAX=T;      { right end point                 }
 ORDMIN=-1.0;    { minimum of the ordinate         }
 ORDMAX=+1.0;    { maximum of the ordinate         }
 ORDPOINT=0.0;   { significant ordinate point      }

TYPE
 VECTOR=ARRAY[0..N] OF REAL;

VAR
 CR:STRING;         { help string                                            }
 K:INTEGER;         { counter                                                }
 AXISX,AXISY:INTEGER; { location of the axes                                 }
 DISTX,DISTY:INTEGER; { scale parameters                                     }
 TK:REAL;           { subinterval point                                      }
 SQDELTA:REAL;      { square root of the time step size                      }
 U1,U2:REAL;        { random numbers                                         }
 RSTK:REAL;         { help variable                                          }
 DWT:REAL;          { current increment of the Wiener trajectory             }
 WT:REAL;           { current value of the Wiener trajectory                 }
 XT:VECTOR;         { values of the trajectory of the explicit Ito solution  }
 RST:VECTOR;        { values of the trajectory of the Ito sums approximation }
 ABSCISSA:VECTOR;   { values of the subinterval points                       }

{ Prepares the screen for the printout of the trajectories       }
{ X-axis is placed in the center; CY,CX ... strings for the axes }

PROCEDURE COORDSYS(CY,CX:STRING);
VAR
 FACTOR,I0,I1,I2,IH,K:INTEGER;
 DX,DY:REAL;
BEGIN
 IH:=TEXTHEIGHT('M')+10;
 AXISX:=TRUNC(MAXY/2);
 I0:=TEXTWIDTH(CHCR(ORDMAX))+7;I1:=TEXTWIDTH(CHCR(ORDMIN))+7;
 I2:=TEXTWIDTH(CHCR(ORDPOINT))+7;IF I0<I1 THEN I0:=I1;
 IF I0<I2 THEN I0:=I2;I1:=TRUNC(MAXX/10);
 IF I0>MAXX-NUMINV-40 THEN I0:=MAXX-NUMINV-40;
 IF I0<I1 THEN AXISY:=I1 ELSE AXISY:=I0;
 DISTX:=NUMINV;DISTY:=AXISX-2*IH-20;
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY,AXISX-DISTY-IH,'^');OUTTEXTXY(AXISY,AXISX-DISTY-2*IH,CY);
 LINE(AXISY,AXISX-DISTY-IH,AXISY,AXISX+DISTY+IH);
 LINE(AXISY-5,AXISX,AXISY+30+DISTX,AXISX);
 SETTEXTJUSTIFY(2,1);I0:=AXISX-DISTY;
 LINE(AXISY-3,AXISX-DISTY,AXISY+3,AXISX-DISTY);OUTTEXTXY(AXISY-7,I0,CHCR(ORDMAX));
 DY:=(ORDPOINT-ORDMIN)/(ORDMAX-ORDMIN);I0:=AXISX+TRUNC((0.5-DY)*2.0*DISTY);
 LINE(AXISY-3,I0,AXISY+3,I0);OUTTEXTXY(AXISY-7,I0,CHCR(ORDPOINT));
 LINE(AXISY-3,AXISX+DISTY,AXISY+3,AXISX+DISTY);
 OUTTEXTXY(AXISY-7,AXISX+DISTY,CHCR(ORDMIN));
 SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY+30+DISTX,AXISX+1,'>');OUTTEXTXY(AXISY+30+DISTX,AXISX+10,CX);
 IF ((ABSCMAX-ABSCMIN=2.0) OR (ABSCMAX+ABSCMIN=0.0)) THEN FACTOR:=2 ELSE
  IF ABSCMAX-ABSCMIN=3.0 THEN FACTOR:=3 ELSE
   IF ABSCMAX-ABSCMIN=4.0 THEN FACTOR:=4 ELSE
    IF ((ABSCMAX-ABSCMIN=5.0) OR ((ABSCMAX-ABSCMIN=1.0) AND (ABSCMIN=0.0)))
     THEN FACTOR:=5 ELSE FACTOR:=1;
 DX:=(ABSCMAX-ABSCMIN)/FACTOR;
 FOR K:=1 TO FACTOR DO
  BEGIN
   I1:=AXISY+TRUNC(K*DISTX/FACTOR+0.5);I2:=AXISX+15;
   LINE(I1,AXISX+3,I1,AXISX-3);
   OUTTEXTXY(I1,I2,CHCR(ABSCMIN+K*DX));
  END;
END;{ COORDSYS }

{ Plots the trajectory of on the screen assuming COORDSYS was called }
{ before and x-axis is placed in the screen center                   }
{ N0,NN = indices of the first and last data picked                  }
{ LTN = line thickness                                               }

PROCEDURE PLOTGRAPH(LTN,N0,NN:INTEGER;ORDINATE,ABSCISSA:VECTOR);
VAR
 IL,IR,IHL,IHR:INTEGER; { screen coordinates                      }
 I:INTEGER;             { data index                              }
 HALFORD:REAL;          { corresponds to the height of the x-axis }
 FACTORX,FACTORY:REAL;  { scaling parameters                      }
BEGIN
 SETLINESTYLE(0,0,LTN);
 FACTORX:=DISTX/(ABSCMAX-ABSCMIN);HALFORD:=(ORDMAX+ORDMIN)/2;
 FACTORY:=DISTY/(ORDMAX-HALFORD);
 IR:=AXISY+TRUNC((ABSCISSA[N0]-ABSCMIN)*FACTORX);
 IHR:=AXISX-TRUNC((ORDINATE[N0]-HALFORD)*FACTORY);
 I:=N0;
 REPEAT
  I:=I+1;
  IL:=IR;IHL:=IHR;
  IR:=AXISY+TRUNC((ABSCISSA[I]-ABSCMIN)*FACTORX);
  IHR:=AXISX-TRUNC((ORDINATE[I]-HALFORD)*FACTORY);
  LINE(IL,IHL,IR,IHR);
 UNTIL I=NN;
 SETLINESTYLE(0,0,1);
END;{ PLOTGRAPH }

{ Main program : }

BEGIN

 INITIALIZE;  { standard initialization }
 MAINWINDOW('Problem 2.1.1');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Generation of data : }

 SQDELTA:=SQRT(DELTA);
 U2:=0.0;WT:=0.0;RSTK:=0.0;
 TK:=T0-DELTA;
 K:=-1;
 REPEAT
  K:=K+1;          { counter              }
  TK:=TK+DELTA;    { time                 }
  IF K MOD 2 =1 THEN GENERATE(U1,U2) ELSE U1:=U2; { uses Polar Marsaglia }
  DWT:=U1*SQDELTA; { increment of the Wiener trajectory     }
  WT:=WT+DWT;      { current value of the Wiener trajectory }
  XT[K]:=0.5*(WT*WT-TK);     { values of the explicit Ito solution }
  RST[K]:=RSTK+(WT-DWT)*DWT; { value of the Ito sum                }
  ABSCISSA[K]:=TK; { values of the x-axis }
  RSTK:=RST[K];
 UNTIL K=N;

{ Printout : }

 CLEARDEVICE;
 COORDSYS('X(t)','t');          { draws the coordinate system      }
 PLOTGRAPH(1,0,N,XT,ABSCISSA);  { plots the explicit Ito solution  }
 PLOTGRAPH(3,0,N,RST,ABSCISSA); { plots the Ito sums approximation }
 CR:='Exact Ito integral and its Ito sums approximation(thick)';
 CR:=CR+' with DELTA='+CHCR(DELTA);
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX2X1X1 }