{ Simulation of trajectories of a given stochastic process  X(t) starting }
{ at X(T0) = X0 on the time interval [T0,T]                               }
{ X(t) is satisfying the linear stochastic differential equation          }
{                dX(t) = a * X(t) dt + b * X(t) dW(t)                     }
{ Uses the Polar Marsaglia method to generate Gaussian random numbers     }
{ Written by Henri Schurz, 9.10. 1991                                     }
{ Note : If using other time step sizes DELTA then bear in mind that      }
{        AAGRAPHS routines uses data vectors of the length NUMINV+1 .     }

PROGRAM PRX2X2X1;

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 T0=0.0;              { left end point                                 }
 T=1.0;               { right end point                                }
 DELTA=(T-T0)/NUMINV; { minimum step size w.r.t. screen resolution     }
 X0=1.0;              { initial value of the trajectory                }
 A=1.0;               { parameter of the drift function of the SDE     }
 B=1.0;               { parameter of the diffusion function of the SDE }
 WPT0=0.0;            { initial value of the Wiener trajectory         }

VAR
 CR:STRING;       { help string                       }
 K:INTEGER;       { counter                           }
 TK:REAL;         { subinterval point                 }
 SQDELTA:REAL;    { square root of the time step size }
 U1,U2:REAL;      { random number                     }
 WT:REAL;         { value of the Wiener trajectory    }
 XT:VECTOR;       { values of the trajectory of X(t)  }
 ABSCISSA:VECTOR; { values of the subinterval points  }

{ Functional form of the explicit solution }

FUNCTION EXPLSOL(TT,WPT:REAL):REAL; { can be replaced by other functions }
BEGIN
 EXPLSOL:=X0*EXP((A-0.5*B*B)*(TT-T0)+B*(WPT-WPT0)); 
END;{ EXPLSOL }

{ Main program : }

BEGIN

 INITIALIZE;  { standard initialization }
 MAINWINDOW(''); { sets a view port     }

{ Generation of data : }

 SQDELTA:=SQRT(DELTA);
 U2:=0.0;WT:=WPT0;
 TK:=T0-DELTA;
 K:=-1;
 REPEAT
  K:=K+1;          { counter              }
  TK:=TK+DELTA;    { time                 }
  ABSCISSA[K]:=TK; { values of the x-axis }
  IF K MOD 2 =1 THEN GENERATE(U1,U2) ELSE U1:=U2; { uses Polar Marsaglia }
  WT:=WT+U1*SQDELTA;     { current value of the Wiener trajectory }
  XT[K]:=EXPLSOL(TK,WT); { values of the y-axis                   }
 UNTIL K=NUMINV;

{ Plots the graph of the density function using AAGRAPHS routine }
{ ! Scaling of the x-axis is done in powers of 2                 }
{ ! Scaling of the y-axis corresponds to the extremas of data    }

 GRAPH111(XT,ABSCISSA,'X(t)','t','');
 CR:=' of dX(t) = '+CHCR(A)+'*X(t) dt + '+CHCR(B)+'*X(t) dW(t)';
 CR:='Trajectory of the exact solution X(t)'+CR;
 IF TEXTWIDTH(CR)>MAXX-5 THEN CR:='Trajectory of the exact solution X(t)';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX2X2X1 }