{ Calculation and approximation of multiple Stratonovich integrals of a    }
{ single Wiener process as functions of time over an interval [T0,T]       }
{ Plots trajectories of the multiple integrals required                    }
{ Written by Henri Schurz, 9.10.1991                                       }
{ Note : For a correct printout of the paths one has to choose the scaling }
{        parameter carefully.                                              }

PROGRAM PRX2X3X1;

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB,AAGRAPHS;

CONST
 N=512;          { number of the subintervals                             }
 T0=0.0;         { begin of the time interval                             }
 T=1.0;          { end of the time interval                               }
 DELTA=(T-T0)/N; { time step size                                         }
 P=20;           { truncation index in the approximate multiple integrals }
 ABSCMIN=T0;     { left end point                                         }
 ABSCMAX=T;      { right end point                                        }
 ORDPOINT=0.0;   { significant ordinate point                             }

VAR
 CR:STRING;           { help string                                  }
 I,K:INTEGER;         { counters                                     }
 AXISX,AXISY:INTEGER; { location of the axes                         }
 DISTX,DISTY:INTEGER; { scale parameters                             }
 ORDMIN:REAL;         { minimum of the ordinate                      }
 ORDMAX:REAL;         { maximum of the ordinate                      }
 SQDELTA:REAL;        { square root of the time step size            }
 TI:REAL;             { subinterval end                              }
 ALPHAP,ROP:REAL;     { approximation parameters                     }
 J1,J11:REAL;         { exact multiple Stratonovich integrals        }
 J01,J10:REAL;        { multiple Stratonovich integrals approximated }
 J011,J101,J110:REAL; { multiple Stratonovich integrals approximated }
 DWT:VECTOR;          { Gaussian random numbers                      }
 WT:VECTOR;           { trajectory of the Wiener process             }
 XJ01T:VECTOR;        { values of the trajectory of J01              }
 XJ10T:VECTOR;        { values of the trajectory of J10              }
 XJ11T:VECTOR;        { values of the trajectory of J11              }
 XJ011T:VECTOR;       { values of the trajectory of J011             }
 XJ101T:VECTOR;       { values of the trajectory of J101             }
 XJ110T:VECTOR;       { values of the trajectory of J110             }
 ABSCISSA:VECTOR;     { subinterval points                           }

{ Prepares the screen for the printout of the trajectories required }
{ X-axis is placed in the center; CY,CX ... strings for the axes    }

PROCEDURE COORDSYS(CY,CX:STRING);
VAR
 FACTOR,I0,I1,I2,IH,K:INTEGER;
 DX,DY:REAL;
BEGIN
 IH:=TEXTHEIGHT('M')+10;
 AXISX:=TRUNC(MAXY/2);
 I0:=TEXTWIDTH(CHCR(ORDMAX))+7;I1:=TEXTWIDTH(CHCR(ORDMIN))+7;
 I2:=TEXTWIDTH(CHCR(ORDPOINT))+7;IF I0<I1 THEN I0:=I1;
 IF I0<I2 THEN I0:=I2;I1:=TRUNC(MAXX/10);
 IF I0>MAXX-NUMINV-40 THEN I0:=MAXX-NUMINV-40;
 IF I0<I1 THEN AXISY:=I1 ELSE AXISY:=I0;
 DISTX:=NUMINV;DISTY:=AXISX-2*IH-20;
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY,AXISX-DISTY-IH,'^');OUTTEXTXY(AXISY,AXISX-DISTY-2*IH,CY);
 LINE(AXISY,AXISX-DISTY-IH,AXISY,AXISX+DISTY+IH);
 LINE(AXISY-5,AXISX,AXISY+30+DISTX,AXISX);
 SETTEXTJUSTIFY(2,1);I0:=AXISX-DISTY;
 LINE(AXISY-3,AXISX-DISTY,AXISY+3,AXISX-DISTY);OUTTEXTXY(AXISY-7,I0,CHCR(ORDMAX));
 DY:=(ORDPOINT-ORDMIN)/(ORDMAX-ORDMIN);I0:=AXISX+TRUNC((0.5-DY)*2.0*DISTY);
 LINE(AXISY-3,I0,AXISY+3,I0);OUTTEXTXY(AXISY-7,I0,CHCR(ORDPOINT));
 LINE(AXISY-3,AXISX+DISTY,AXISY+3,AXISX+DISTY);
 OUTTEXTXY(AXISY-7,AXISX+DISTY,CHCR(ORDMIN));
 SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY+30+DISTX,AXISX+1,'>');OUTTEXTXY(AXISY+30+DISTX,AXISX+10,CX);
 IF ((ABSCMAX-ABSCMIN=2.0) OR (ABSCMAX+ABSCMIN=0.0)) THEN FACTOR:=2 ELSE
  IF ABSCMAX-ABSCMIN=3.0 THEN FACTOR:=3 ELSE
   IF ABSCMAX-ABSCMIN=4.0 THEN FACTOR:=4 ELSE
    IF ((ABSCMAX-ABSCMIN=5.0) OR ((ABSCMAX-ABSCMIN=1.0) AND (ABSCMIN=0.0)))
     THEN FACTOR:=5 ELSE FACTOR:=1;
 DX:=(ABSCMAX-ABSCMIN)/FACTOR;
 FOR K:=1 TO FACTOR DO
  BEGIN
   I1:=AXISY+TRUNC(K*DISTX/FACTOR+0.5);I2:=AXISX+15;
   LINE(I1,AXISX+3,I1,AXISX-3);
   OUTTEXTXY(I1,I2,CHCR(ABSCMIN+K*DX));
  END;
END;{ COORDSYS }

{ Plots one trajectory on the screen assuming COORDSYS has been called }
{ before and x-axis is placed in the screen center                     }
{ N0,NN = indices of the first and last data picked                    }
{ LTN = line thickness                                                 }

PROCEDURE PLOTGRAPH(LTN,N0,NN:INTEGER;ORDINATE,ABSCISSA:VECTOR);
VAR
 IL,IR,IHL,IHR:INTEGER; { screen coordinates                      }
 I:INTEGER;             { data index                              }
 HALFORD:REAL;          { corresponds to the height of the x-axis }
 FACTORX,FACTORY:REAL;  { scaling parameters                      }
BEGIN
 SETLINESTYLE(0,0,LTN);
 FACTORX:=DISTX/(ABSCMAX-ABSCMIN);HALFORD:=(ORDMAX+ORDMIN)/2;
 FACTORY:=DISTY/(ORDMAX-HALFORD);
 IR:=AXISY+TRUNC((ABSCISSA[N0]-ABSCMIN)*FACTORX);
 IHR:=AXISX-TRUNC((ORDINATE[N0]-HALFORD)*FACTORY);
 I:=N0;
 REPEAT
  I:=I+1;
  IL:=IR;IHL:=IHR;
  IR:=AXISY+TRUNC((ABSCISSA[I]-ABSCMIN)*FACTORX);
  IHR:=AXISX-TRUNC((ORDINATE[I]-HALFORD)*FACTORY);
  LINE(IL,IHL,IR,IHR);
 UNTIL I=NN;
 SETLINESTYLE(0,0,1);
END;{ PLOTGRAPH }

{ Controls the output on the screen }

PROCEDURE CONTROLSCR(CL,BOTTOMCR:STRING;ORD1,ORD2:REAL;XT:VECTOR);
BEGIN
 CLEARDEVICE;
 ORDMIN:=ORD1; { minimum of the ordinate }
 ORDMAX:=ORD2; { maximum of the ordinate }
 COORDSYS(CL+'(w)(t)','t');    { draws the coordinate system }
 PLOTGRAPH(1,0,N,XT,ABSCISSA); { plots the trajectory        }
 STATUSLINE(BOTTOMCR);

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

END;{ CONTROLSCR }

{ Sets the parameters for the procedure MULTIINT }

PROCEDURE SETUPPARAMULTIINT(P:INTEGER;VAR ALPHAP,ROP:REAL);
VAR
 R:INTEGER;
 INCRE:REAL;
BEGIN
 ALPHAP:=0.0;ROP:=0.0;
 FOR R:=1 TO P DO
  BEGIN
   INCRE:=1/(R*R);ROP:=ROP+INCRE;ALPHAP:=ALPHAP+INCRE*INCRE;
  END;
 ALPHAP:=(PI*PI*PI*PI/90-ALPHAP)/(2*PI*PI);
 ROP:=PI*PI/6-ROP;ROP:=ROP/(2*PI*PI);
END;{ SETUPPARAMULTIINT }

{ Generates the multiple Stratonovich integrals                         }
{ J1, J01, J10, J11, J011, J101, and J110                               }
{ Uses the time step size DELTA; P = accuracy parameter                 }
{ Assumes the Gaussian random number DWT has already been generated and }
{ SETUPPARAMULTIINT has been called before                              }

PROCEDURE MULTIINT(P:INTEGER;DELTA,DWT:REAL;
           VAR J1,J01,J10,J11,J011,J101,J110:REAL);
VAR
 R,L:INTEGER;
 A10,B11P,B1P,C11P,FI1P,GSI,MUE1P:REAL;
 ETA1,FI1:VECTOR;
BEGIN
 GENERATE(FI1P,MUE1P);
 A10:=0.0;B1P:=0.0;B11P:=0.0;
 FOR R:=1 TO P DO
  BEGIN
   GENERATE(FI1[R],ETA1[R]);
   A10:=A10+FI1[R]/R;
   B1P:=B1P+ETA1[R]/(R*R);
   B11P:=B11P+(FI1[R]*FI1[R]+ETA1[R]*ETA1[R])/(R*R);
  END;
 A10:=-(1./PI)*A10*SQRT(2.0)*SQDELTA;
 A10:=A10-2.*SQDELTA*SQRT(ROP)*MUE1P;
 B1P:=B1P*SQDELTA/SQRT(2.0)+SQDELTA*SQRT(ALPHAP)*FI1P;
 B11P:=B11P/(4.*PI*PI);
 GSI:=DWT;
 J1:=GSI*SQDELTA; { increment of the Wiener trajectory = J1 }
 J10:=0.5*DELTA*(J1+A10); { multiple integral J10 }
 J01:=J1*DELTA-J10; { multiple integral J01 }
 J11:=0.5*J1*J1; { multiple integral J11 }
 C11P:=0.0;
 R:=0;
 REPEAT
  R:=R+1;
  L:=0;
  REPEAT
   L:=L+1;
   IF L<>R THEN
    C11P:=C11P+(R/(R*R-L*L))*(FI1[R]*FI1[L]/L-ETA1[R]*ETA1[L]*L/R);
  UNTIL L=P;
 UNTIL R=P;
 C11P:=-C11P/(2.*PI*PI);
 J101:=SQR(DELTA*GSI)/6-DELTA*A10*A10/4;
 J101:=J101+SQDELTA*DELTA*GSI*B1P/PI;
 J101:=J101-DELTA*DELTA*B11P; { multiple integral J101 }
 J110:=SQR(DELTA*GSI)/6+DELTA*A10*A10/4;
 J110:=J110-SQDELTA*DELTA*GSI*B1P/(2.*PI);
 J110:=J110+SQDELTA*DELTA*A10*GSI/4;
 J110:=J110-DELTA*DELTA*C11P; { multiple integral J110 }
 J011:=J11*DELTA-J101-J110; { multiple integral J011 }
END;{ MULTIINT }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Problem 2.3.1');
 STATUSLINE('Be patient! This will take the computer some time.');

 SQDELTA:=SQRT(DELTA);
 SETUPPARAMULTIINT(P,ALPHAP,ROP); { sets approximation parameters }

 I:=0;       { time step index                         }
 TI:=T0;     { initial time                            }
 WT[0]:=0.0; { starting value of the Wiener trajectory }
 J1:=0.0;J01:=0.0;J10:=0.0;J11:=0.0;J011:=0.0;J101:=0.0;J110:=0.0;
 ABSCISSA[0]:=ABSCMIN; { initial value of the x-axis }
 XJ01T[0]:=J01;        { multiple integral J01       }
 XJ10T[0]:=J10;        { multiple integral J10       }
 XJ11T[0]:=J11;        { multiple integral J11       }
 XJ011T[0]:=J011;      { multiple integral J011      }
 XJ101T[0]:=J101;      { multiple integral J101      }
 XJ110T[0]:=J110;      { multiple integral J110      }
 WHILE (TI < T) DO
  BEGIN
   I:=I+1;
   TI:=TI+DELTA;

  { Generation of the Wiener process increments using Polar Marsaglia method : }

   IF I MOD 2 = 1 THEN GENERATE(DWT[I-1],DWT[I]);

  { Approximation of the multiple Stratonovich integrals : }

   MULTIINT(P,DELTA,DWT[I-1],J1,J01,J10,J11,J011,J101,J110);

  { Pick up of data : }

   ABSCISSA[I]:=TI;             { value of the x-axis    }
   WT[I]:=WT[I-1]+J1;           { Wiener trajectory      }
   XJ01T[I]:=XJ01T[I-1]+J01;    { multiple integral J01  }
   XJ10T[I]:=XJ10T[I-1]+J10;    { multiple integral J10  }
   XJ11T[I]:=XJ11T[I-1]+J11;    { multiple integral J11  }
   XJ011T[I]:=XJ011T[I-1]+J011; { multiple integral J011 }
   XJ101T[I]:=XJ101T[I-1]+J101; { multiple integral J101 }
   XJ110T[I]:=XJ110T[I-1]+J110; { multiple integral J110 }

  END;{ WHILE }

{ Printout of the trajectories required : }

 FOR K:=1 TO 7 DO
  BEGIN
   CASE K OF
     1 : BEGIN
          ORDMIN:=-2.*(T-T0); { minimum of the ordinate }
          ORDMAX:=+2.*(T-T0); { maximum of the ordinate }
          CR:='Trajectory of the Wiener Process W(w)(t) with DELTA = ';
          CR:=CR+CHCR(DELTA);
          CONTROLSCR('W',CR,ORDMIN,ORDMAX,WT);
         END;
     2 : BEGIN
          ORDMIN:=-DELTA; { minimum of the ordinate }
          ORDMAX:=+DELTA; { maximum of the ordinate }
          CR:='Trajectory of the multiple integral J01 with P = ';
          CR:=CR+CHCR(P)+' and DELTA = '+CHCR(DELTA);
          CONTROLSCR('J01',CR,ORDMIN,ORDMAX,XJ01T);
         END;
     3 : BEGIN
          ORDMIN:=-DELTA; { minimum of the ordinate }
          ORDMAX:=+DELTA; { maximum of the ordinate }
          CR:='Trajectory of the multiple integral J10 with P = ';
          CR:=CR+CHCR(P)+' and DELTA = '+CHCR(DELTA);
          CONTROLSCR('J10',CR,ORDMIN,ORDMAX,XJ10T);
         END;
     4 : BEGIN
          ORDMIN:=-(T-T0); { minimum of the ordinate }
          ORDMAX:=+(T-T0); { maximum of the ordinate }
          CR:='Trajectory of the multiple integral J11 with ';
          CR:=CR+'DELTA = '+CHCR(DELTA);
          CONTROLSCR('J11',CR,ORDMIN,ORDMAX,XJ11T);
         END;
     5 : BEGIN
          ORDMIN:=-(T-T0)/1000; { minimum of the ordinate }
          ORDMAX:=+(T-T0)/1000; { maximum of the ordinate }
          CR:='Trajectory of the multiple integral J011 with P = ';
          CR:=CR+CHCR(P)+' and DELTA = '+CHCR(DELTA);
          CONTROLSCR('J011',CR,ORDMIN,ORDMAX,XJ011T);
         END;
     6 : BEGIN
          ORDMIN:=-(T-T0)/1000; { minimum of the ordinate }
          ORDMAX:=+(T-T0)/1000; { maximum of the ordinate }
          CR:='Trajectory of the multiple integral J101 with P = ';
          CR:=CR+CHCR(P)+' and DELTA = '+CHCR(DELTA);
          CONTROLSCR('J101',CR,ORDMIN,ORDMAX,XJ101T);
         END;
     7 : BEGIN
          ORDMIN:=-(T-T0)/1000; { minimum of the ordinate }
          ORDMAX:=+(T-T0)/1000; { maximum of the ordinate }
          CR:='Trajectory of the multiple integral J110 with P = ';
          CR:=CR+CHCR(P)+' and DELTA = '+CHCR(DELTA);
          CONTROLSCR('J110',CR,ORDMIN,ORDMAX,XJ110T);
         END;
   END;{ CASE }
  END;

 IF N=NUMINV THEN { automatically data adapted plotting }
  BEGIN
   CLEARDEVICE;
   GRAPH111(XJ101T,ABSCISSA,'J101(w)(t)','t','');
   CR:='Trajectory of the multiple integral J101 with P = ';
   CR:=CR+CHCR(P)+' and DELTA = '+CHCR(DELTA);
   STATUSLINE(CR);

  { Stop : }

   WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
             { ! <ESC> terminates the program           }
  END;

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX2X3X1 }