{ Calculation and approximation of the multiple Stratonovich integrals of }
{ a single Wiener process on the time interval [0,DELTA]                  }
{ Estimates the sample average and variance of the multiple integral J10  }
{ Written by Henri Schurz, 9.10.1991                                      }

PROGRAM PRX2X3X2;

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
 N=1000;     { sample size          }
 DELTA=0.05; { time step size       }
 P1=2;       { truncation parameter }
 P2=5;       { truncation parameter }
 P3=10;      { truncation parameter }

TYPE
 VECTOR=ARRAY[1..N] OF REAL;

VAR
 CR:STRING;           { help string                                       }
 I:INTEGER;           { counter                                           }
 SQDELTA:REAL;        { square root of the time step size                 }
 ALPHAP,ROP:REAL;     { current approximation parameters                  }
 AP1,AP2,AP3:REAL;    { approximation parameters                          }
 ROP1,ROP2,ROP3:REAL; { approximation parameters                          }
 J1,J11:REAL;         { exact multiple Stratonovich integrals             }
 J01,J10:REAL;        { multiple Stratonovich integrals approximated      }
 J011,J101,J110:REAL; { multiple Stratonovich integrals approximated      }
 DWT,U:REAL;          { Gaussian random numbers                           }
 AV1,AV2,AV3:REAL;    { sample averages                                   }
 VAR1,VAR2,VAR3:REAL; { sample variances                                  }
 J10P1:VECTOR;        { sample values of the multiple integral J10 for P1 }
 J10P2:VECTOR;        { sample values of the multiple integral J10 for P2 }
 J10P3:VECTOR;        { sample values of the multiple integral J10 for P3 }

{ Prepares the screen and plots a table with the results on it }

PROCEDURE SETTABLETOSCR;
VAR
 CR:STRING;
 IK,L:INTEGER;
BEGIN
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 IK:=TRUNC((MAXX-2)/6);
 FOR L:=0 TO 4 DO LINE(0,80+L*20,6*IK,80+L*20);
 OUTTEXTXY(TRUNC(MAXX/2),25,'Sample average and variance of J10 :');
 OUTTEXTXY(3*IK,60,'sample size N = '+CHCR(N));
 FOR L:=0 TO 4 DO
  BEGIN
   LINE(2*L*IK,80,2*L*IK,160);
   CASE L OF
     1 : CR:='p';
     2 : CR:='average';
     3 : CR:='variance';
    END;
   IF ((L<>0) AND (L<>4)) THEN OUTTEXTXY((2*L-1)*IK,90,CR);
  END;
 FOR L:=0 TO 2 DO
  CASE L OF
    0 : BEGIN
         FOR I:=0 TO 2 DO
          BEGIN
           CASE I OF
             0 : CR:=CHCR(P1);
             1 : CR:=CHCR(AV1);
             2 : CR:=CHCR(VAR1);
            END;
           OUTTEXTXY((2*I+1)*IK,110+L*20,CR);
          END;
        END;
    1 : BEGIN
         FOR I:=0 TO 2 DO
          BEGIN
           CASE I OF
             0 : CR:=CHCR(P2);
             1 : CR:=CHCR(AV2);
             2 : CR:=CHCR(VAR2);
            END;
           OUTTEXTXY((2*I+1)*IK,110+L*20,CR);
          END;
        END;
    2 : BEGIN
         FOR I:=0 TO 2 DO
          BEGIN
           CASE I OF
             0 : CR:=CHCR(P3);
             1 : CR:=CHCR(AV3);
             2 : CR:=CHCR(VAR3);
            END;
           OUTTEXTXY((2*I+1)*IK,110+L*20,CR);
          END;
        END;
   END;
END;{ SETTABLETOSCR }

{ Computes the sample average and variance of a given data vector X }
{ with sample size NN                                               }

PROCEDURE COMPSAMPLEPARA(NN:INTEGER;X:VECTOR;VAR SAVERAGE,SVARIANCE:REAL);
VAR
 J:INTEGER; { data index    }
 SQ:REAL;   { help variable }
BEGIN
 SAVERAGE:=0.0;SVARIANCE:=0.0;SQ:=0.0; { initialization }
 FOR J:=1 TO NN DO BEGIN SAVERAGE:=SAVERAGE+X[J];SQ:=SQ+X[J]*X[J]; END;
 SVARIANCE:=(SQ-SAVERAGE*SAVERAGE/NN)/(NN-1);
 SAVERAGE:=SAVERAGE/NN;
END;{ COMPSAMPLEPARA }

{ Sets the parameters for the procedure MULTIINT }

PROCEDURE SETUPPARAMULTIINT(P:INTEGER;VAR ALPHAP,ROP:REAL);
VAR
 R:INTEGER;
 INCRE:REAL;
BEGIN
 ALPHAP:=0.0;ROP:=0.0;
 FOR R:=1 TO P DO
  BEGIN
   INCRE:=1/(R*R);ROP:=ROP+INCRE;ALPHAP:=ALPHAP+INCRE*INCRE;
  END;
 ALPHAP:=(PI*PI*PI*PI/90-ALPHAP)/(2*PI*PI);
 ROP:=PI*PI/6-ROP;ROP:=ROP/(2*PI*PI);
END;{ SETUPPARAMULTIINT }

{ Generates the multiple Stratonovich integrals                         }
{ J1, J01, J10, J11, J011, J101, and J110                               }
{ Uses the time step size DELTA; P = accuracy parameter                 }
{ Assumes the Gaussian random number DWT has already been generated and }
{ SETUPPARAMULTIINT has been called before                              }

PROCEDURE MULTIINT(P:INTEGER;DELTA,DWT:REAL;
           VAR J1,J01,J10,J11,J011,J101,J110:REAL);
VAR
 R,L:INTEGER;
 A10,B11P,B1P,C11P,FI1P,GSI,MUE1P:REAL;
 ETA1,FI1:VECTOR;
BEGIN
 GENERATE(FI1P,MUE1P);
 A10:=0.0;B1P:=0.0;B11P:=0.0;
 FOR R:=1 TO P DO
  BEGIN
   GENERATE(FI1[R],ETA1[R]);
   A10:=A10+FI1[R]/R;
   B1P:=B1P+ETA1[R]/(R*R);
   B11P:=B11P+(FI1[R]*FI1[R]+ETA1[R]*ETA1[R])/(R*R);
  END;
 A10:=-(1./PI)*A10*SQRT(2.0)*SQDELTA;
 A10:=A10-2.*SQDELTA*SQRT(ROP)*MUE1P;
 B1P:=B1P*SQDELTA/SQRT(2.0)+SQDELTA*SQRT(ALPHAP)*FI1P;
 B11P:=B11P/(4.*PI*PI);
 GSI:=DWT;
 J1:=GSI*SQDELTA; { increment of the Wiener trajectory = J1 }
 J10:=0.5*DELTA*(J1+A10); { multiple integral J10 }
 J01:=J1*DELTA-J10; { multiple integral J01 }
 J11:=0.5*J1*J1; { multiple integral J11 }
 C11P:=0.0;
 R:=0;
 REPEAT
  R:=R+1;
  L:=0;
  REPEAT
   L:=L+1;
   IF L<>R THEN
    C11P:=C11P+(R/(R*R-L*L))*(FI1[R]*FI1[L]/L-ETA1[R]*ETA1[L]*L/R);
  UNTIL L=P;
 UNTIL R=P;
 C11P:=-C11P/(2.*PI*PI);
 J101:=SQR(DELTA*GSI)/6-DELTA*A10*A10/4;
 J101:=J101+SQDELTA*DELTA*GSI*B1P/PI;
 J101:=J101-DELTA*DELTA*B11P; { multiple integral J101 }
 J110:=SQR(DELTA*GSI)/6+DELTA*A10*A10/4;
 J110:=J110-SQDELTA*DELTA*GSI*B1P/(2.*PI);
 J110:=J110+SQDELTA*DELTA*A10*GSI/4;
 J110:=J110-DELTA*DELTA*C11P; { multiple integral J110 }
 J011:=J11*DELTA-J101-J110; { multiple integral J011 }
END;{ MULTIINT }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Problem 2.3.2');
 STATUSLINE('Be patient! This will take the computer some time.');

 SQDELTA:=SQRT(DELTA);
 SETUPPARAMULTIINT(P1,AP1,ROP1); { sets approximation parameters }
 SETUPPARAMULTIINT(P2,AP2,ROP2); { sets approximation parameters }
 SETUPPARAMULTIINT(P3,AP3,ROP3); { sets approximation parameters }

 I:=0; { data index }
 J1:=0.0;J01:=0.0;J10:=0.0;J11:=0.0;J011:=0.0;J101:=0.0;J110:=0.0;
 REPEAT
  I:=I+1;

 { Generation of the Wiener process increments using Polar Marsaglia method : }

  IF I MOD 2 = 1 THEN GENERATE(DWT,U) ELSE DWT:=U;

 { Approximation of the multiple Stratonovich integrals : }

  ALPHAP:=AP1;ROP:=ROP1; { sets up the current parameters }
  MULTIINT(P1,DELTA,DWT,J1,J01,J10,J11,J011,J101,J110);J10P1[I]:=J10;
  ALPHAP:=AP2;ROP:=ROP2; { sets up the current parameters }
  MULTIINT(P2,DELTA,DWT,J1,J01,J10,J11,J011,J101,J110);J10P2[I]:=J10;
  ALPHAP:=AP3;ROP:=ROP3; { sets up the current parameters }
  MULTIINT(P3,DELTA,DWT,J1,J01,J10,J11,J011,J101,J110);J10P3[I]:=J10;

 UNTIL I=N;

{ Calculation of the sample parameters : }

 COMPSAMPLEPARA(N,J10P1,AV1,VAR1);
 COMPSAMPLEPARA(N,J10P2,AV2,VAR2);
 COMPSAMPLEPARA(N,J10P3,AV3,VAR3);

{ Printout of the data on the screen : }

 CLEARDEVICE;
 SETTABLETOSCR;
 CR:='Sample parameters of the multiple integral J10 (P=';
 CR:=CR+CHCR(P1)+'/'+CHCR(P2)+'/'+CHCR(P3)+') with DELTA = '+CHCR(DELTA);
 STATUSLINE(CR);

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX2X3X2 }