{ Approximation of the multiple Stratonovich integral J12              }
{ Calculates the multiple integral on the time interval [0,DELTA]      }
{ Plots a table to compare J12 with dW1*dW2/2 for different truncation }
{ parameters P1, P2 and P3 (assuming P1<P2<P3<=100)                    }
{ Written by Henri Schurz, 9.10.1991                                   }

PROGRAM PRX2X3X3;

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,RANDNUMB;

CONST
 DELTA=1.0; { time step size       }
 P1=5;      { truncation parameter }
 P2=20;     { truncation parameter }
 P3=100;    { truncation parameter }

TYPE
 VECTOR=ARRAY[1..3] OF REAL;

VAR
 CR:STRING;       { help string                                          }
 SQDELTA:REAL;    { square root of the time step size                    }
 ROP:REAL;        { current approximation parameter                      }
 SUMVAL:REAL;     { summation help variable                              }
 MU1,MU2:REAL;    { Gaussian random numbers                              }
 GSI1,GSI2:REAL;  { Gaussian random numbers generating Wiener increments }
 HALFDW1DW2:REAL; { dW1*dW2/2                                            }
 J12P:VECTOR;     { multiple Stratonovich integral J12 approximated      }

{ Prepares the screen and plots a table of the results }

PROCEDURE SETTABLETOSCR;
VAR
 CR:STRING;
 IK,L:INTEGER;
BEGIN
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 IK:=TRUNC((MAXX-2)/6);
 FOR L:=0 TO 4 DO LINE(0,80+L*20,6*IK,80+L*20);
 CR:='Approximation of the same sample path of the multiple Stratonovich';
 OUTTEXTXY(TRUNC(MAXX/2),20,CR);
 CR:='integral J12 and comparison with half of the product of the';
 OUTTEXTXY(TRUNC(MAXX/2),40,CR);
 CR:='corresponding Wiener increments dW1 and dW2';
 OUTTEXTXY(TRUNC(MAXX/2),60,CR);
 FOR L:=0 TO 4 DO
  BEGIN
   LINE(2*L*IK,80,2*L*IK,160);
   CASE L OF
     1 : CR:='p';
     2 : CR:='J12(p)';
     3 : CR:='dW1*dW2/2';
    END;
   IF ((L<>0) AND (L<>4)) THEN OUTTEXTXY((2*L-1)*IK,90,CR);
  END;
 FOR L:=0 TO 2 DO
  BEGIN
   CASE L OF
     0 : CR:=CHCR(P1);
     1 : CR:=CHCR(P2);
     2 : CR:=CHCR(P3);
    END;
   OUTTEXTXY(IK,110+L*20,CR);
   CR:=CHCR(J12P[L+1]);OUTTEXTXY(3*IK,110+L*20,CR);
   CR:=CHCR(HALFDW1DW2);OUTTEXTXY(5*IK,110+L*20,CR);
  END;
END;{ SETTABLETOSCR }

{ Sets the parameter ROP of the procedure MULTIINTJ12 }

PROCEDURE SETUPPARAMULTIINTJ12(P:INTEGER;VAR ROP:REAL);
VAR
 R:INTEGER;
BEGIN
 ROP:=0.0;
 FOR R:=1 TO P DO ROP:=ROP+1/(R*R);
 ROP:=PI*PI/6-ROP;ROP:=ROP/(2*PI*PI);
END;{ SETUPPARAMULTIINTJ12 }

{ Generates the multiple Stratonovich integral J12                          }
{ Uses the time step size DELTA; PL and PR(<=100) are accuracy parameters   }
{ Assumes the Gaussian random numbers GSI1,GSI2,MU1 and MU2 have already    }
{ been generated and ROP has been calculated by SETUPPARAMULTIINTJ12 before }
{ GSI1 and GSI2 are involved in the generation of the Wiener increments     }
{ SUMVAL is the help value to continue the summations                       }

PROCEDURE MULTIINTJ12(PL,PR:INTEGER;ROP,DELTA,GSI1,GSI2,MU1,MU2:REAL;
                                    VAR SUMVAL,J12:REAL);
VAR
 R:INTEGER;
 ETA,ZETA:ARRAY[1..2,1..100] OF REAL;
BEGIN
 FOR R:=PL TO PR DO
  BEGIN
   GENERATE(ZETA[1,R],ZETA[2,R]);GENERATE(ETA[1,R],ETA[2,R]);
   SUMVAL:=SUMVAL+(1/R)*(ZETA[1,R]*(SQRT(2)*GSI2+ETA[2,R])
                 -ZETA[2,R]*(SQRT(2)*GSI1+ETA[1,R]));
  END;
 J12:=SUMVAL*DELTA/PI;
 J12:=J12+DELTA*(GSI1*GSI2/2+SQRT(ROP)*(MU1*GSI2-MU2*GSI1));
END;{ MULTIINTJ12 }

{ Main program : }

BEGIN

 INITIALIZE; { initialization }
 MAINWINDOW('Problem 2.3.3');
 STATUSLINE('Be patient! This will take the computer some time.');

{ Generation of the Wiener process increments using Polar Marsaglia method : }

 GENERATE(GSI1,GSI2);
 HALFDW1DW2:=GSI1*GSI2*DELTA/2;

{ Approximation of the multiple Stratonovich integral J12 : }

 GENERATE(MU1,MU2); { generates the Gaussian random values MU1 and MU2 }
 SETUPPARAMULTIINTJ12(P1,ROP); { sets the current parameter ROP }
 SUMVAL:=0.0; { help value for the summation }
 MULTIINTJ12(1,P1,ROP,DELTA,GSI1,GSI2,MU1,MU2,SUMVAL,J12P[1]);
 SETUPPARAMULTIINTJ12(P2,ROP); { sets the current parameter ROP }
 MULTIINTJ12(P1+1,P2,ROP,DELTA,GSI1,GSI2,MU1,MU2,SUMVAL,J12P[2]);
 SETUPPARAMULTIINTJ12(P3,ROP); { sets the current parameter ROP }
 MULTIINTJ12(P2+1,P3,ROP,DELTA,GSI1,GSI2,MU1,MU2,SUMVAL,J12P[3]);

{ Printout of the data on the screen : }

 CLEARDEVICE;
 SETTABLETOSCR;
 CR:='Approximation of the multiple integral J12';
 CR:=CR+' on the time interval [0,'+CHCR(DELTA)+']';
 STATUSLINE(CR);

{ Stop : }

 WAITTOGO; { waits for <ENTER> or <ESC> to be pressed }
           { ! <ESC> terminates the program           }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX2X3X3 }