{ Exact solution and Euler approximation                                   }
{ Considers the deterministic ordinary differential equation               }
{  dX(t) = A(t,X(t)) dt   with  X(T0) = X0   on the time interval [T0,T]   }
{ Equidistant approximation of X(t) by the Euler scheme with the time step }
{ sizes DELTA1 and DELTA2                                                  }
{ Plots the linearly interpolated trajectories of X(t) and its Euler ap-   }
{ proximations in the same graphic                                         }
{ Written by Henri Schurz, 9.10. 1991                                      }
{ Note : Be careful if changing the time step sizes and the scaling para-  }
{        meters. The maximum of the numbers of the time steps used may not }
{        larger than NUM.                                                  }

PROGRAM PRX3X1X1; { PC-Exercise 8.1.1 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE;

CONST
 NUM=NUMINV;        { maximum number of time steps used              }
 T0=0.0;            { left end point                                 }
 T=1.0;             { right end point                                }
 DELTA0=(T-T0)/NUM; { time step size for plotting the exact solution }
 DELTA1=(T-T0)/8;   { time step size of the Euler approximation      }
 DELTA2=(T-T0)/32;  { time step size of the Euler approximation      }
 X0=1.0;            { initial value                                  }
 ALPHA=-5.0;        { parameter of the function A(t,x)               }
 ABSCMIN=T0;        { left end point                                 }
 ABSCMAX=T;         { right end point                                }
 ORDMIN=0.0;        { minimum of the ordinate                        }
 ORDMAX=+1.0;       { maximum of the ordinate                        }
 ORDPOINT=0.5;      { significant ordinate point                     }

TYPE
 VECTOR=ARRAY[0..NUM] OF REAL;

VAR
 CR:STRING;           { help string                                    }
 AXISX,AXISY:INTEGER; { location of the axes                           }
 DISTX,DISTY:INTEGER; { scale parameters                               }
 N0,N1,N2:INTEGER;    { numbers of time steps                          }
 I:INTEGER;           { time step                                      }
 TI:REAL;             { subinterval point                              }
 YTOLD:REAL;          { last value of the approximation                }
 XT:VECTOR;           { values of the exact solution X(t)              }
 YT1:VECTOR;          { values of the Euler approximation using DELTA1 }
 YT2:VECTOR;          { values of the Euler approximation using DELTA2 }
 ABSCISSA0:VECTOR;    { values of the subinterval points               }
 ABSCISSA1:VECTOR;    { values of the subinterval points               }
 ABSCISSA2:VECTOR;    { values of the subinterval points               }

{ Prepares the screen for the printout of the trajectories       }
{ X-axis is placed in the bottom; CY,CX ... strings for the axes }

PROCEDURE COORDSYS(CY,CX:STRING);
VAR
 FACTOR,I0,I1,I2,IH,K:INTEGER;
 DX,DY:REAL;
BEGIN
 IH:=TEXTHEIGHT('M')+10;
 AXISX:=TRUNC(MAXY-4*IH);
 I0:=TEXTWIDTH(CHCR(ORDMAX))+7;I1:=TEXTWIDTH(CHCR(ORDMIN))+7;
 I2:=TEXTWIDTH(CHCR(ORDPOINT))+7;IF I0<I1 THEN I0:=I1;
 IF I0<I2 THEN I0:=I2;I1:=TRUNC(MAXX/10);
 IF I0>MAXX-NUMINV-40 THEN I0:=MAXX-NUMINV-40;
 IF I0<I1 THEN AXISY:=I1 ELSE AXISY:=I0;
 DISTX:=NUMINV;DISTY:=AXISX-2*IH-20;
 SETTEXTSTYLE(DEFAULTFONT,HORIZDIR,1);SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY,AXISX-DISTY-IH,'^');OUTTEXTXY(AXISY,AXISX-DISTY-2*IH,CY);
 LINE(AXISY,AXISX-DISTY-IH,AXISY,AXISX+5);
 LINE(AXISY-5,AXISX,AXISY+30+DISTX,AXISX);
 SETTEXTJUSTIFY(2,1);I0:=AXISX-DISTY;
 LINE(AXISY-3,I0,AXISY+3,I0);OUTTEXTXY(AXISY-7,I0,CHCR(ORDMAX));
 DY:=(ORDPOINT-ORDMIN)/(ORDMAX-ORDMIN);I0:=AXISX-TRUNC(DY*DISTY);
 LINE(AXISY-3,I0,AXISY+3,I0);OUTTEXTXY(AXISY-7,I0,CHCR(ORDPOINT));
 OUTTEXTXY(AXISY-7,AXISX,CHCR(ORDMIN));SETTEXTJUSTIFY(1,1);
 OUTTEXTXY(AXISY+30+DISTX,AXISX+1,'>');OUTTEXTXY(AXISY+30+DISTX,AXISX+10,CX);
 IF ((ABSCMAX-ABSCMIN=2.0) OR (ABSCMAX+ABSCMIN=0.0)) THEN FACTOR:=2 ELSE
  IF ABSCMAX-ABSCMIN=3.0 THEN FACTOR:=3 ELSE
   IF ABSCMAX-ABSCMIN=4.0 THEN FACTOR:=4 ELSE
    IF ((ABSCMAX-ABSCMIN=5.0) OR ((ABSCMAX-ABSCMIN=1.0) AND (ABSCMIN=0.0)))
     THEN FACTOR:=5 ELSE FACTOR:=1;
 DX:=(ABSCMAX-ABSCMIN)/FACTOR;
 FOR K:=0 TO FACTOR DO
  BEGIN
   I1:=AXISY+TRUNC(K*DISTX/FACTOR+0.5);I2:=AXISX+IH;
   LINE(I1,AXISX+3,I1,AXISX-3);
   OUTTEXTXY(I1,I2,CHCR(ABSCMIN+K*DX));
  END;
END;{ COORDSYS }

{ Plots the trajectory on the screen assuming COORDSYS was called }
{ before and x-axis is placed in the bottom of the screen         }
{ N0,NN = indices of the first and last data picked               }
{ LTN = line thickness                                            }

PROCEDURE PLOTGRAPH1(LTN,N0,NN:INTEGER;ORDINATE,ABSCISSA:VECTOR);
VAR
 IL,IR,IHL,IHR:INTEGER; { screen coordinates }
 I:INTEGER;             { data index         }
 FACTORX,FACTORY:REAL;  { scaling parameters }
BEGIN
 SETLINESTYLE(0,0,LTN);
 FACTORX:=DISTX/(ABSCMAX-ABSCMIN);
 FACTORY:=DISTY/(ORDMAX-ORDMIN);
 IR:=AXISY+TRUNC((ABSCISSA[N0]-ABSCMIN)*FACTORX);
 IHR:=AXISX-TRUNC((ORDINATE[N0]-ORDMIN)*FACTORY);
 I:=N0;
 REPEAT
  I:=I+1;
  IL:=IR;IHL:=IHR;
  IR:=AXISY+TRUNC((ABSCISSA[I]-ABSCMIN)*FACTORX);
  IHR:=AXISX-TRUNC((ORDINATE[I]-ORDMIN)*FACTORY);
  LINE(IL,IHL,IR,IHR);
 UNTIL I=NN;
 SETLINESTYLE(0,0,1);
END;{ PLOTGRAPH1 }

{ Generates the function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=ALPHA*XI;
END;{ A }

{ Generates the functional form of the explicit solution }

FUNCTION EXPLSOL(TI:REAL):REAL;
BEGIN
 EXPLSOL:=X0*EXP(ALPHA*(TI-T0));
END;{ EXPLSOL }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 3.1.1 (PC-Exercise 8.1.1)');
 STATUSLINE('Be patient! This will take the computer some time!');
 N0:=TRUNC((T-T0)/DELTA0+0.1);N1:=TRUNC((T-T0)/DELTA1+0.1);
 N2:=TRUNC((T-T0)/DELTA2+0.1);

{ Evaluates the explicit solution : }

 TI:=T0-DELTA0;
 I:=-1;
 REPEAT
  I:=I+1;             { time step                   }
  TI:=TI+DELTA0;      { time                        }
  XT[I]:=EXPLSOL(TI); { exact value of the solution }
  ABSCISSA0[I]:=TI;   { value of the x-axis         }
 UNTIL I=N0;

{ Generation of the Euler approximations : }

 YT1[0]:=X0;ABSCISSA1[0]:=T0;
 TI:=T0;
 I:=0;
 REPEAT
  I:=I+1; { time step }
  YTOLD:=YT1[I-1];
  YT1[I]:=YTOLD+A(TI,YTOLD)*DELTA1; { Euler scheme }
  TI:=TI+DELTA1;    { time                }
  ABSCISSA1[I]:=TI; { value of the x-axis }
 UNTIL I=N1;
 YT2[0]:=X0;ABSCISSA2[0]:=T0;
 TI:=T0;
 I:=0;
 REPEAT
  I:=I+1; { time step }
  YTOLD:=YT2[I-1];
  YT2[I]:=YTOLD+A(TI,YTOLD)*DELTA2; { Euler scheme }
  TI:=TI+DELTA2;    { time                }
  ABSCISSA2[I]:=TI; { value of the x-axis }
 UNTIL I=N2;

{ Printout : }

 CLEARDEVICE;COORDSYS('X(t),Y(t)','t'); { draws the coordinate system       }
 PLOTGRAPH1(3,0,N0,XT,ABSCISSA0);  { plots the values of the exact solution }
 PLOTGRAPH1(1,0,N1,YT1,ABSCISSA1); { plots the Euler approx. for DELTA1     }
 PLOTGRAPH1(1,0,N2,YT2,ABSCISSA2); { plots the Euler approx. for DELTA2     }
 CR:='Exact solution(thick) and Euler approximations(thin';
 CR:=CR+',DELTA='+CHCR(DELTA1)+'/'+CHCR(DELTA2)+')';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX3X1X1 }