{ Linear interpolated trajectories of log2(f(DELTA)) plotted against }
{ log2(DELTA) for the two functions                                  }
{       f1(DELTA) = DELTA and f2(DELTA) = DELTA*DELTA                }
{ with DELTA = 2^(-k)  for k = 0,1,...,5                             }
{ Written by Henri Schurz, 9.10. 1991                                }

PROGRAM PRX3X1X2;

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,AAGRAPHS;

CONST
 NUM=6; { number of interpolation points }

VAR
 C1,C2,CR:STRING;  { help strings    }
 I:INTEGER;        { counter         }
 DELTA:REAL;       { time step size  }
 F1,F2:VECTOR1;    { ordinate points }
 ABSCISSA:VECTOR1; { abscissa points }

{ Main program : }

BEGIN

 INITIALIZE;  { standard initialization }
 MAINWINDOW(''); { sets a view port     }

{ Generation of data : }

 DELTA:=2.0;
 I:=0;
 REPEAT
  I:=I+1;             { counter              }
  DELTA:=DELTA/2;     { time step size       }
  ABSCISSA[I]:=DELTA; { values of the x-axis }
  F1[I]:=DELTA;       { values of the y-axis }
  F2[I]:=DELTA*DELTA; { values of the y-axis }
 UNTIL I=NUM;

{ Plots the two graphs of the logarithms of data using AAGRAPHS routine }
{ ! Scaling of the x and y-axis corresponds to the extremas of data     }

 C1:='log2(f1(DELTA))';C2:='log2(f2(DELTA))';
 GRAPH312(NUM,F1,F2,ABSCISSA,'log2(f(DELTA))','log2(DELTA)',C1,C2);
 CR:='Linearly interpolated logarithms of f1(DELTA) = DELTA and ';
 CR:=CR+'f2(DELTA) = DELTA^2';
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX3X1X2 }