{ Illustrates the global discretization error                            }
{ Considers the deterministic ordinary differential equation             }
{  dX(t) = A(t,X(t)) dt   with  X(T0) = X0   on the time interval [T0,T] }
{ Equidistant approximation of X(t) by the modified trapezoidal method   }
{ with different time step sizes DELTA                                   }
{ Plots the linearly interpolated logarithms to the base 2 of the global }
{ discretization error at the time T against log2(DELTA)                 }
{ Written by Henri Schurz, 9.10. 1991                                    }

PROGRAM PRX3X1X4; { PC-Exercise 8.1.3 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,AAGRAPHS;

CONST
 T0=0;       { left end point                      }
 T=1;        { right end point                     }
 DELTA=1;    { largest time step size              }
 NUM=13;     { number of different time step sizes }
 X0=1.0;     { initial value                       }
 ALPHA=-5.0; { parameter of the function A(t,x)    }

VAR
 CR:STRING;    { help string                                  }
 I:INTEGER;    { time step                                    }
 K:INTEGER;    { index of the time step size used             }
 TI:REAL;      { subinterval point                            }
 DELTA_Y:REAL; { time step size                               }
 AA:REAL;      { value of A at the left subinterval end point }
 XT:REAL;      { exact solution X(t) at time t=T              }
 YT:VECTOR1;   { approximations                               }
 EPS:VECTOR1;  { global discretization errors                 }
 DEL:VECTOR1;  { time step sizes                              }

{ Generates the function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=ALPHA*XI;
END;{ A }

{ Generates the functional form of the explicit solution }

FUNCTION EXPLSOL(TI:REAL):REAL;
BEGIN
 EXPLSOL:=X0*EXP(ALPHA*(TI-T0));
END;{ EXPLSOL }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 3.1.4 (PC-Exercise 8.1.3)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Evaluation of the explicit solution : }

 XT:=EXPLSOL(T); { exact value of the solution }

{ Generation of the Euler approximations : }

 DELTA_Y:=DELTA*2;
 K:=0;
 REPEAT
  K:=K+1;             { index of the time step size DELTA used }
  I:=0;               { number of time steps                   }
  TI:=T0;             { initial time                           }
  YT[K]:=X0;          { initial value of the approximation     }
  DELTA_Y:=DELTA_Y/2; { current time step size                 }
  WHILE (TI < T) DO
   BEGIN
    I:=I+1; { time step }
    TI:=TI+DELTA_Y; { right subinterval end point }

   { Modified trapezoidal scheme : }

    AA:=A(TI-DELTA_Y,YT[K]);
    YT[K]:=YT[K]+0.5*(AA+A(TI,YT[K]+AA*DELTA_Y))*DELTA_Y;

   END;
 UNTIL K=NUM;

{ Initialization of data and printout : }

 FOR K:=1 TO NUM DO
  BEGIN
   EPS[K]:=ABS(XT-YT[K]); { global discretization error at time T }
   IF K>1 THEN DEL[K]:=DEL[K-1]/2 ELSE DEL[K]:=DELTA;
  END;
 CLEARDEVICE;
 CR:='EPS(modified trapezoidal)';
 GRAPH313(NUM,EPS,DEL,'log2(EPS)','log2(DELTA)',CR);
 CR:='Global discretization error EPS at the time T = '+CHCR(T);
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX3X1X4 }