{ Illustrates the global discretization error                              }
{ Considers the deterministic ordinary differential equation               }
{  dX(t) = A(t,X(t)) dt   with  X(T0) = X0   on the time interval [T0,T]   }
{ Equidistant approximation of X(t) by the Euler method and the Richardson }
{ extrapolation with different time step sizes DELTA                       }
{ Plots the linearly interpolated logarithms to the base 2 of the global   }
{ discretization errors of the both approximations at the time T against   }
{ log2(DELTA) in the same graphic                                          }
{ Written by Henri Schurz, 9.10. 1991                                      }

PROGRAM PRX3X1X6; { PC-Exercise 8.1.7 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,AAGRAPHS;

CONST
 T0=0;       { left end point                               }
 T=1;        { right end point                              }
 DELTA=1/8;  { largest time step size                       }
 NUM=8;      { number of time step sizes for the comparison }
 X0=1.0;     { initial value                                }
 ALPHA=-1.0; { parameter of the function A(t,x)             }

VAR
 C1,C2,CR:STRING; { help strings                                           }
 I:INTEGER;       { time step                                              }
 K:INTEGER;       { index of the time step size used                       }
 TI:REAL;         { subinterval point                                      }
 DELTA_Y:REAL;    { time step size                                         }
 XT:REAL;         { exact solution X(t) at time t=T                        }
 YT:VECTOR1;      { Euler approximations                                   }
 ZT:VECTOR1;      { Richardson extrapolations                              }
 EPS1:VECTOR1;    { global discretization errors(Euler approximation)      }
 EPS2:VECTOR1;    { global discretization errors(Richardson extrapolation) }
 DEL:VECTOR1;     { time step sizes                                        }

{ Generates the function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=ALPHA*XI;
END;{ A }

{ Generates the functional form of the explicit solution }

FUNCTION EXPLSOL(TI:REAL):REAL;
BEGIN
 EXPLSOL:=X0*EXP(ALPHA*(TI-T0));
END;{ EXPLSOL }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 3.1.6 (PC-Exercise 8.1.7)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Evaluation of the explicit solution : }

 XT:=EXPLSOL(T); { exact value of the solution }

{ Generation of the Euler approximations : }

 DELTA_Y:=DELTA*2;
 K:=0;
 REPEAT
  K:=K+1;             { index of the time step size DELTA used }
  I:=0;               { number of time steps                   }
  TI:=T0;             { initial time                           }
  YT[K]:=X0;          { initial value of the approximation     }
  DELTA_Y:=DELTA_Y/2; { current time step size                 }
  WHILE (TI < T) DO
   BEGIN
    I:=I+1; { time step }
    TI:=TI+DELTA_Y; { right subinterval end point }

   { Euler scheme : }

    YT[K]:=YT[K]+A(TI-DELTA_Y,YT[K])*DELTA_Y;

   END;
 UNTIL K=NUM+1;

{ Initialization of data and printout : }

 FOR K:=1 TO NUM DO
  BEGIN
   ZT[K]:=2*YT[K+1]-YT[K]; { value of the Richardson extrapolation at t=T   }
   EPS1[K]:=ABS(XT-YT[K]); { global discretization error(Euler) at t=T      }
   EPS2[K]:=ABS(XT-ZT[K]); { global discretization error(Richardson) at t=T }
   IF K>1 THEN DEL[K]:=DEL[K-1]/2 ELSE DEL[K]:=DELTA;
  END;
 CLEARDEVICE;
 C1:='EPS1(Euler approximation)';
 C2:='EPS2(Richardson extrapolation)';
 GRAPH312(NUM,EPS1,EPS2,DEL,'log2(EPS)','log2(DELTA)',C1,C2);
 CR:='Global discretization errors EPS1 and EPS2 at the time T = '+CHCR(T);
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX3X1X6 }