{ Illustrates the global discretization error                              }
{ Considers the deterministic ordinary differential equation               }
{  dX(t) = A(t,X(t)) dt   with  X(T0) = X0   on the time interval [T0,T]   }
{ Equidistant approximation of X(t) by the 2nd and the 3rd order truncated }
{ Taylor methods with different time step sizes DELTA                      }
{ Plots the linearly interpolated logarithms to the base 2 of the global   }
{ discretization errors for the both approximations at the time T against  }
{ log2(DELTA) in the same graphic                                          }
{ Written by Henri Schurz, 9.10. 1991                                      }

PROGRAM PRX3X1X7; { PC-Exercise 8.2.1 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,AAGRAPHS;

CONST
 T0=0;      { left end point                               }
 T=0.5;     { right end point                              }
 DELTA=1/8; { largest time step size                       }
 NUM=8;     { number of time step sizes for the comparison }
 X0=1.0;    { initial value( 0 < X0 < 2 )                  }

VAR
 C1,C2,CR:STRING; { help strings                                   }
 I:INTEGER;       { time step                                      }
 K:INTEGER;       { index of the time step size used               }
 TI:REAL;         { subinterval point                              }
 DELTA_Y:REAL;    { time step size                                 }
 AA,D1,D2,DD11,DD12,DD22,H1:REAL; { help variables                 }
 XT:REAL;         { exact solution X(t) at time t=T                }
 Y1T:VECTOR1;     { 2nd order Taylor approximations                }
 Y2T:VECTOR1;     { 3rd order Taylor approximations                }
 EPS1:VECTOR1;    { global discretization errors(2nd order Taylor) }
 EPS2:VECTOR1;    { global discretization errors(3rd order Taylor) }
 DEL:VECTOR1;     { time step sizes                                }

{ Generates the function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=TI*XI*(2.-XI);
END;{ A }

{ Generates the first partial derivations of A(t,x). }

FUNCTION DAT(TI,XI:REAL):REAL;
BEGIN
 DAT:=XI*(2.-XI);
END;{ DAT }

FUNCTION DAX(TI,XI:REAL):REAL;
BEGIN
 DAX:=TI*(2.-2.*XI);
END;{ DAX }

{ The following functions generate the second partial derivations of A(t,x). }

FUNCTION DDATT(TI,XI:REAL):REAL;
BEGIN
 DDATT:=0.0;
END;{ DDATT }

FUNCTION DDATX(TI,XI:REAL):REAL;
BEGIN
 DDATX:=2.*(1.-XI);
END;{ DDATX }

FUNCTION DDAXX(TI,XI:REAL):REAL;
BEGIN
 DDAXX:=-2.*TI;
END;{ DDAXX }

{ Generates the functional form of the explicit solution }

FUNCTION EXPLSOL(TI:REAL):REAL;
VAR
 C:REAL;
BEGIN
 C:=X0/(2.-X0);
 EXPLSOL:=2.*(C/(C+EXP(-TI*TI)));
END;{ EXPLSOL }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 3.1.7 (PC-Exercise 8.2.1)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Evaluation of the explicit solution : }

 XT:=EXPLSOL(T); { exact value of the solution }

{ Generation of the Taylor approximations : }

 DELTA_Y:=DELTA*2;
 K:=0;
 REPEAT
  K:=K+1;             { index of the time step size DELTA used              }
  I:=0;               { number of time steps                                }
  TI:=T0;             { initial time                                        }
  Y1T[K]:=X0;         { initial value of the 2nd order Taylor approximation }
  Y2T[K]:=X0;         { initial value of the 3rd order Taylor approximation }
  DELTA_Y:=DELTA_Y/2; { current time step size                              }
  WHILE (TI < T) DO
   BEGIN
    I:=I+1; { time step }
    TI:=TI+DELTA_Y; { right subinterval end point }

   { 2nd order Taylor scheme : }

    AA:=A(TI-DELTA_Y,Y1T[K]);
    D1:=DAT(TI-DELTA_Y,Y1T[K]);
    D2:=DAX(TI-DELTA_Y,Y1T[K]);
    Y1T[K]:=Y1T[K]+AA*DELTA_Y+0.5*(D1+D2*AA)*DELTA_Y*DELTA_Y;

   { 3nd order Taylor scheme : }

    AA:=A(TI-DELTA_Y,Y2T[K]);
    D1:=DAT(TI-DELTA_Y,Y2T[K]);
    D2:=DAX(TI-DELTA_Y,Y2T[K]);
    DD11:=DDATT(TI-DELTA_Y,Y2T[K]);
    DD12:=DDATX(TI-DELTA_Y,Y2T[K]);
    DD22:=DDAXX(TI-DELTA_Y,Y2T[K]);
    H1:=DD11+2*DD12*AA+DD22*AA*AA+D1*D2+D2*D2*AA;
    H1:=H1*DELTA_Y*DELTA_Y*DELTA_Y;
    Y2T[K]:=Y2T[K]+AA*DELTA_Y+(1/2)*(D1+D2*AA)*DELTA_Y*DELTA_Y+H1/6;

   END;
 UNTIL K=NUM;

{ Initialization of data and printout : }

 FOR K:=1 TO NUM DO
  BEGIN
   EPS1[K]:=ABS(XT-Y1T[K]); { global discretization error(2nd Taylor) at t=T }
   EPS2[K]:=ABS(XT-Y2T[K]); { global discretization error(3rd Taylor) at t=T }
   IF K>1 THEN DEL[K]:=DEL[K-1]/2 ELSE DEL[K]:=DELTA;
  END;
 CLEARDEVICE;
 C1:='EPS1(2nd order Taylor)';
 C2:='EPS2(3rd order Taylor)';
 GRAPH312(NUM,EPS1,EPS2,DEL,'log2(EPS)','log2(DELTA)',C1,C2);
 CR:='Global discretization errors EPS1 and EPS2 at the time T = '+CHCR(T);
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX3X1X7 }