{ Illustrates the global discretization error                              }
{ Considers the deterministic ordinary differential equation               }
{  dX(t) = A(t,X(t)) dt   with  X(T0) = X0   on the time interval [T0,T]   }
{ Equidistant approximation of X(t) by the classical 4th order Runge-Kutta }
{ method with different time step sizes DELTA                              }
{ Plots the linearly interpolated logarithms to the base 2 of the global   }
{ discretization errors of the Runge-Kutta approximation at the time T     }
{ against log2(DELTA)                                                      }
{ Written by Henri Schurz, 9.10. 1991                                      }

PROGRAM PRX3X1X8; { PC-Exercise 8.2.2 }

USES CRT,DOS,GRAPH,INIT,SETSCR,SERVICE,AAGRAPHS;

CONST
 T0=0;       { left end point                   }
 T=0.5;      { right end point                  }
 DELTA=1/4;  { largest time step size           }
 NUM=6;      { number of time step sizes used   }
 X0=1.0;     { initial value( 0 < X0 < 2 )      }
 ALPHA=-1.0; { parameter of the function A(t,x) }

VAR
 CR:STRING;        { help string                          }
 I:INTEGER;        { time step                            }
 K:INTEGER;        { index of the time step size used     }
 TI:REAL;          { subinterval point                    }
 DELTA_Y:REAL;     { time step size                       }
 K1,K2,K3,K4:REAL; { help variables                       }
 XT:REAL;          { exact solution X(t) at time t=T      }
 YT:VECTOR1;       { 4th order Runge-Kutta approximations }
 EPS:VECTOR1;      { global discretization errors         }
 DEL:VECTOR1;      { time step sizes                      }

{ Generates the function A(t,x) }

FUNCTION A(TI,XI:REAL):REAL;
BEGIN
 A:=TI*XI*(2.-XI);
END;{ A }

{ Generates the functional form of the explicit solution }

FUNCTION EXPLSOL(TI:REAL):REAL;
VAR
 C:REAL;
BEGIN
 C:=X0/(2.-X0);
 EXPLSOL:=2.*(C/(C+EXP(-TI*TI)));
END;{ EXPLSOL }

{ Main program : }

BEGIN

 INITIALIZE; { standard initialization }
 MAINWINDOW('Problem 3.1.8 (PC-Exercise 8.2.2)');
 STATUSLINE('Be patient! This will take the computer some time!');

{ Evaluation of the explicit solution : }

 XT:=EXPLSOL(T); { exact value of the solution }

{ Generation of the 4th order Runge-Kutta approximation : }

 DELTA_Y:=DELTA*2;
 K:=0;
 REPEAT
  K:=K+1;             { index of the time step size DELTA used         }
  I:=0;               { number of time steps                           }
  TI:=T0;             { initial time                                   }
  YT[K]:=X0;          { initial value of the Runge-Kutta approximation }
  DELTA_Y:=DELTA_Y/2; { current time step size                         }
  WHILE (TI < T) DO
   BEGIN
    I:=I+1; { time step }
    TI:=TI+DELTA_Y; { right subinterval end point }

   { 4th order Runge-Kutta scheme : }

    K1:=A(TI-DELTA_Y,YT[K]);
    K2:=A(TI-DELTA_Y/2,YT[K]+K1*DELTA_Y/2);
    K3:=A(TI-DELTA_Y/2,YT[K]+K2*DELTA_Y/2);
    K4:=A(TI,YT[K]+K3*DELTA_Y);
    YT[K]:=YT[K]+(1/6)*(K1+2*K2+2*K3+K4)*DELTA_Y;

   END;
 UNTIL K=NUM;

{ Initialization of data and printout : }

 FOR K:=1 TO NUM DO
  BEGIN
   EPS[K]:=ABS(XT-YT[K]); { global discretization error at the time T }
   IF K>1 THEN DEL[K]:=DEL[K-1]/2 ELSE DEL[K]:=DELTA;
  END;
 CLEARDEVICE;
 CR:='EPS(4th order Runge-Kutta)';
 GRAPH313(NUM,EPS,DEL,'log2(EPS)','log2(DELTA)',CR);
 CR:='Global discretization error EPS at the time T = '+CHCR(T);
 STATUSLINE(CR);

 WAITTOGO; { waits for <ENTER> to be pressed }
           { ! <ESC> terminates the program  }

 MYEXITPROC; { closes graphics mode and sets the old procedure address }
END.{ PRX3X1X8 }